/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.camera.utils;

import android.app.Activity;
import com.tuya.smart.android.common.utils.L;
import com.tuya.smart.camera.utils.R;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public final class ActivityUtils {
    private static final String TAG = "ActivityUtils";
    private static ArrayList<WeakReference<Activity>> activityStack = new ArrayList();

    private ActivityUtils() {
    }

    public static void finishCamera() {
        L.i((String)TAG, (String)"finishCamera");
        ActivityUtils.finishActivity();
    }

    public static boolean isAttachActivity() {
        return activityStack.isEmpty();
    }

    public static void attachActivity(Activity activity) {
        WeakReference<Activity> act = new WeakReference<Activity>(activity);
        if (activityStack.indexOf(act) == -1) {
            activityStack.add(act);
        }
    }

    public static Activity getTopActivity() {
        if (activityStack.isEmpty()) {
            return null;
        }
        return (Activity)activityStack.get(activityStack.size() - 1).get();
    }

    public static void detachActivity(Activity activity) {
        if (ActivityUtils.isAttachActivity()) {
            return;
        }
        ArrayList<WeakReference<Activity>> activityStacks = new ArrayList<WeakReference<Activity>>();
        for (int i = activityStack.size() - 1; i >= 0; --i) {
            WeakReference<Activity> activityWeakReference = activityStack.get(i);
            if (activityWeakReference == null || activityWeakReference.get() != activity) continue;
            activityStacks.add(activityWeakReference);
        }
        activityStack.removeAll(activityStacks);
        activityStacks.clear();
    }

    public static void finishActivity() {
        L.i((String)TAG, (String)("finishActivity, stack size: " + activityStack.size()));
        if (activityStack.size() == 0) {
            return;
        }
        try {
            for (int i = activityStack.size() - 1; i >= 0; --i) {
                if (activityStack.size() == i) {
                    return;
                }
                WeakReference<Activity> activity = activityStack.get(i);
                if (activity == null || activity.get() == null || ((Activity)activity.get()).isFinishing()) continue;
                ((Activity)activity.get()).finish();
                ((Activity)activity.get()).overridePendingTransition(R.anim.slide_in_left, R.anim.slide_out_right);
            }
            activityStack.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

