/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.camera.middleware.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.tuya.smart.android.common.utils.L;
import com.tuya.smart.camera.camerasdk.typlayer.callback.OnCameraGestureListener;
import com.tuya.smart.camera.camerasdk.typlayer.callback.OnRenderDirectionCallback;
import com.tuya.smart.camera.camerasdk.typlayer.callback.OnRenderZoomListener;
import com.tuya.smart.camera.ipccamerasdk.monitor.IMonitorView;
import com.tuya.smart.camera.ipccamerasdk.monitor.Monitor;
import com.tuya.smart.camera.ipccamerasdk.monitor.MonitorClickCallback;
import com.tuyasmart.camera.devicecontrol.model.PTZDirection;

public class TuyaCameraView
extends RelativeLayout {
    private static final String TAG = "TuyaCameraView";
    private static final int SCROLL_DISTANCE = 150;
    private Context mContext;
    private int mProvider;
    private IMonitorView mMonitor;
    private CreateVideoViewCallback mCallback;
    float mDistanceX = 0.0f;
    float mDistanceY = 0.0f;

    public TuyaCameraView(Context context) {
        super(context);
        this.mContext = context;
    }

    public TuyaCameraView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
    }

    public TuyaCameraView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mContext = context;
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
    }

    public void createVideoView(int n) {
        this.mProvider = n;
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        if (1 == n) {
            try {
                Class<?> clazz = Class.forName("com.tuya.smart.camera.camerasdk.view.TutkMoniterView");
                this.mMonitor = (IMonitorView)clazz.getConstructor(Context.class).newInstance(this.mContext);
            }
            catch (Exception exception) {
                L.d((String)TAG, (String)("TutkMoniterView newInstance with exception: " + exception.toString()));
                exception.printStackTrace();
                this.mMonitor = null;
            }
            if (this.mMonitor != null) {
                L.d((String)TAG, (String)"TutkMoniterView newInstance success");
                ((View)this.mMonitor).setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                this.addView((View)this.mMonitor);
                if (this.mCallback != null) {
                    this.mCallback.onCreated(this.mMonitor);
                }
                this.mMonitor.setOnMonitorClickListener((Object)new MonitorClickCallback(){

                    public void onClick() {
                        TuyaCameraView.this.mCallback.videoViewClick();
                    }
                });
                return;
            }
        } else {
            this.mMonitor = new Monitor(this.mContext);
            ((View)this.mMonitor).setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.addView((View)this.mMonitor);
            if (this.mCallback != null) {
                this.mCallback.onCreated(this.mMonitor);
            }
            this.mMonitor.setOnCameraGestureListener((Object)new OnCameraGestureListener(){

                public void onActionUp() {
                    if (TuyaCameraView.this.mCallback != null) {
                        TuyaCameraView.this.mCallback.videoViewClick();
                    }
                }
            });
        }
    }

    public void setOnRenderDirectionCallback(OnRenderDirectionCallback onRenderDirectionCallback) {
        if (this.mMonitor == null || onRenderDirectionCallback == null) {
            return;
        }
        if (2 == this.mProvider || 3 == this.mProvider) {
            this.mMonitor.setOnRenderDirectionCallback((Object)onRenderDirectionCallback);
        }
    }

    public void onPause() {
        if (this.mMonitor != null) {
            this.mMonitor.onPause();
        }
    }

    public void onResume() {
        if (this.mMonitor != null) {
            this.mMonitor.onResume();
        }
    }

    public Object createdView() {
        return this.mMonitor;
    }

    public void supportPTZ() {
        if (this.mMonitor != null && 1 == this.mProvider) {
            this.mMonitor.setOnGestureListener((Object)new GestureDetector(this.mContext, (GestureDetector.OnGestureListener)new OnPlayViewGestureListener()));
        }
    }

    public void setCameraViewCallback(CreateVideoViewCallback createVideoViewCallback) {
        this.mCallback = createVideoViewCallback;
    }

    public void setMonitorFullScale() {
        if (this.mMonitor != null) {
            this.mMonitor.setFullScale();
        }
    }

    public void setZoomListener(OnRenderZoomListener onRenderZoomListener) {
        if (this.mMonitor != null) {
            this.mMonitor.setZoomListener(onRenderZoomListener);
        }
    }

    public void setMonitorScaleMode(int n) {
        if (this.mMonitor != null) {
            this.mMonitor.setShowMode(n);
        }
    }

    public static interface CreateVideoViewCallback<T> {
        public void onCreated(T var1);

        public void videoViewClick();

        public void startCameraMove(PTZDirection var1);

        public void onActionUP();
    }

    class OnPlayViewGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        OnPlayViewGestureListener() {
        }

        public boolean onSingleTapUp(MotionEvent motionEvent) {
            return false;
        }

        public void onLongPress(MotionEvent motionEvent) {
        }

        public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
            if (TuyaCameraView.this.mMonitor != null && TuyaCameraView.this.mMonitor.getScale() > 1.0f) {
                return true;
            }
            TuyaCameraView.this.mDistanceX += f;
            TuyaCameraView.this.mDistanceY += f2;
            if (Math.abs(TuyaCameraView.this.mDistanceX) > 150.0f || Math.abs(TuyaCameraView.this.mDistanceY) > 150.0f) {
                if (Math.abs(TuyaCameraView.this.mDistanceX) > Math.abs(TuyaCameraView.this.mDistanceY)) {
                    if (TuyaCameraView.this.mDistanceX > 0.0f) {
                        if (TuyaCameraView.this.mCallback != null) {
                            TuyaCameraView.this.mCallback.startCameraMove(PTZDirection.RIGHT);
                        }
                    } else if (TuyaCameraView.this.mCallback != null) {
                        TuyaCameraView.this.mCallback.startCameraMove(PTZDirection.LEFT);
                    }
                } else if (TuyaCameraView.this.mDistanceY > 0.0f) {
                    if (TuyaCameraView.this.mCallback != null) {
                        TuyaCameraView.this.mCallback.startCameraMove(PTZDirection.DOWN);
                    }
                } else if (TuyaCameraView.this.mCallback != null) {
                    TuyaCameraView.this.mCallback.startCameraMove(PTZDirection.UP);
                }
                TuyaCameraView.this.mDistanceX = 0.0f;
                TuyaCameraView.this.mDistanceY = 0.0f;
            }
            return false;
        }

        public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
            if (TuyaCameraView.this.mMonitor != null && TuyaCameraView.this.mMonitor.getScale() == 1.0f) {
                TuyaCameraView.this.mCallback.onActionUP();
                return true;
            }
            return false;
        }

        public void onShowPress(MotionEvent motionEvent) {
        }

        public boolean onDown(MotionEvent motionEvent) {
            return false;
        }

        public boolean onDoubleTap(MotionEvent motionEvent) {
            return false;
        }

        public boolean onDoubleTapEvent(MotionEvent motionEvent) {
            return false;
        }

        public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
            return false;
        }
    }
}

