/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.camera.middleware.cloud.bean;

import com.tuya.smart.camera.utils.DateUtils;
import io.reactivex.annotations.NonNull;
import java.util.Calendar;
import java.util.Date;

public class CloudDayBean
implements Comparable<CloudDayBean> {
    private int sumDuration;
    private String uploadDay;
    private long currentDayStart;
    private long currentDayEnd;
    private STATUS status = STATUS.UN_SELECT;
    private static String FORMAT_SHORT = "yyyy-MM-dd";

    public int getSumDuration() {
        return this.sumDuration;
    }

    public void setSumDuration(int n) {
        this.sumDuration = n;
    }

    public String getUploadDay() {
        return this.uploadDay;
    }

    public void setUploadDay(String string) {
        this.uploadDay = string;
    }

    public String getMonthAndDay() {
        if (this.uploadDay != null) {
            return this.uploadDay.substring(5).replace("-", ".");
        }
        return null;
    }

    public long getCurrentStartDayTime() {
        this.currentDayStart = this.getTodayStart(DateUtils.parse((String)this.uploadDay, (String)FORMAT_SHORT));
        return this.currentDayStart;
    }

    public long getCurrentDayEndTime() {
        this.currentDayEnd = this.getTodayEnd(DateUtils.parse((String)this.uploadDay, (String)FORMAT_SHORT));
        return this.currentDayEnd;
    }

    public STATUS getStatus() {
        return this.status;
    }

    public void setStatus(STATUS sTATUS) {
        this.status = sTATUS;
    }

    @Override
    public int compareTo(@NonNull CloudDayBean cloudDayBean) {
        if (this.currentDayStart < cloudDayBean.getCurrentStartDayTime()) {
            return 1;
        }
        return -1;
    }

    private int getTodayStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return (int)(calendar.getTimeInMillis() / 1000L);
    }

    private int getTodayEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.add(5, 1);
        return (int)(calendar.getTimeInMillis() / 1000L);
    }

    public static enum STATUS {
        SELECT,
        UN_SELECT;

    }
}

