/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.ipc.cloud.panel.presenter;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.os.Message;
import com.tuya.smart.android.mvp.presenter.BasePresenter;
import com.tuya.smart.api.MicroContext;
import com.tuya.smart.api.router.UrlRouter;
import com.tuya.smart.camera.base.bean.CloudDayBean;
import com.tuya.smart.camera.base.bean.TimeRangeBean;
import com.tuya.smart.camera.base.callback.RecordCallback;
import com.tuya.smart.camera.base.utils.CameraUIThemeUtils;
import com.tuya.smart.camera.base.utils.UrlRouterUtils;
import com.tuya.smart.camera.uiview.bean.TimePieceBean;
import com.tuya.smart.camera.utils.DateUtils;
import com.tuya.smart.camera.utils.ObjectUtils;
import com.tuya.smart.camera.utils.TimeZoneUtils;
import com.tuya.smart.camera.utils.permission.PermissionChecker;
import com.tuya.smart.ipc.cloud.panel.R;
import com.tuya.smart.ipc.cloud.panel.model.CameraCloudModel;
import com.tuya.smart.ipc.cloud.panel.model.ICameraCloudModel;
import com.tuya.smart.ipc.cloud.panel.view.ICameraCloudView;
import com.tuya.smart.uispecs.component.dialog.BooleanConfirmAndCancelListener;
import com.tuya.smart.uispecs.component.util.FamilyDialogUtils;
import com.tuya.smart.utils.ToastUtil;
import java.util.List;
import java.util.TimeZone;

public class CameraCloudPresenter
extends BasePresenter {
    private ICameraCloudView mView;
    private Context mContext;
    private ICameraCloudModel mModel;
    private String mDevId;
    private boolean isDefaultStatus = false;
    private boolean isPortrait = true;
    private int servedDataStatus;
    private Dialog deleteDialog;
    private Dialog downloadDialog;

    public CameraCloudPresenter(Context context, String devId, ICameraCloudView mView) {
        super(context);
        this.mView = mView;
        this.mContext = context;
        this.mDevId = devId;
        this.mModel = new CameraCloudModel(context, devId, this.mHandler);
    }

    public void playByTimeRangeData(TimeRangeBean timeRangeBean) {
        this.mView.showVideoLoading(1, R.string.ipc_status_stream);
        this.mView.allControllerBtnEnableState(false);
        this.mModel.playCloudDataWithStartTime(timeRangeBean.getStartTime(), timeRangeBean.getEndTime(), true);
    }

    public void playByTimePieceData(TimePieceBean timePieceBean) {
        if (timePieceBean == null) {
            this.mView.showVideoLoading(1, R.string.ipc_status_stream);
            this.mView.allControllerBtnEnableState(false);
            int startTime = (int)this.mModel.getCurrentPlayTimestamp();
            if (startTime > 0 && this.isBelongSelectDay(startTime)) {
                this.mModel.playCloudDataWithStartTime(startTime, 0, false);
            } else {
                this.getSelectDayCloudTimes(this.mModel.getCurrentCloudBean());
            }
        } else {
            int startTime;
            int n = startTime = timePieceBean.getPlayTime() == 0 ? timePieceBean.getStartTime() : timePieceBean.getPlayTime();
            if (this.isBelongSelectDay(startTime)) {
                this.mView.showVideoLoading(1, R.string.ipc_status_stream);
                this.mView.allControllerBtnEnableState(false);
                this.mModel.playCloudDataWithStartTime(startTime, timePieceBean.getEndTime(), false);
            } else {
                this.mView.clearTimeViewPieceData();
                this.mView.updateTimerRulerCurrentTime(this.mModel.getCurrentPlayTimestamp() * 1000L);
            }
        }
    }

    private boolean isBelongSelectDay(int startTime) {
        CloudDayBean currentCloudBean = this.mModel.getCurrentCloudBean();
        if (null != currentCloudBean) {
            return (long)startTime >= currentCloudBean.getCurrentStartDayTime() && (long)startTime <= currentCloudBean.getCurrentDayEndTime();
        }
        return false;
    }

    public void checkRecordingAction(final RecordCallback callback) {
        if (this.mModel.isRecording()) {
            Dialog dialog = FamilyDialogUtils.showConfirmAndCancelDialog((Context)this.mContext, (String)this.mContext.getString(R.string.point_out), (String)this.mContext.getString(R.string.pps_video_shift_tip), (String)this.mContext.getString(R.string.Confirm), (String)this.mContext.getString(R.string.cancel), (BooleanConfirmAndCancelListener)new BooleanConfirmAndCancelListener(){

                public boolean onConfirm(Object o) {
                    CameraCloudPresenter.this.mModel.stopCloudRecordLocalMP4();
                    callback.onStop();
                    return true;
                }

                public boolean onCancel(Object o) {
                    CameraCloudPresenter.this.mView.clearTimeViewPieceData();
                    callback.onContinue();
                    return true;
                }
            });
            dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                    callback.onContinue();
                }
            });
            dialog.show();
        } else {
            callback.onStop();
        }
    }

    public boolean isRecording() {
        return null != this.mModel && this.mModel.isRecording();
    }

    public void onBackPressed() {
        if (this.mModel.isRecording()) {
            this.mModel.stopCloudRecordLocalMP4();
        }
    }

    public void setMuteValue() {
        this.mModel.setMuteValue();
    }

    public int getSdkProvider() {
        return this.mModel.getSdkProvider();
    }

    public void pauseOrResumeVideo() {
        if (this.mModel.getPlayState() == 3) {
            this.mModel.pausePlayCloudVideo(true);
        } else {
            this.mModel.resumePlayCloudVideo();
        }
    }

    public void resumeVideo() {
        if (!this.mModel.isClickPause() && null != this.mModel.getWaitingTimePiece() && 5 != this.mModel.getPlayState()) {
            this.mModel.resumePlayCloudVideo();
        }
    }

    public void pauseVideo() {
        if (this.mModel.getPlayState() != 4 && this.mModel.getPlayState() != 5) {
            this.mModel.pausePlayCloudVideo(false);
            this.mModel.setPauseMute();
        }
    }

    public void generateMonitor(Object monitor) {
        this.mModel.generateMonitor(monitor);
    }

    public List<CloudDayBean> getCloudDays() {
        return this.mModel.getCloudStorageDays();
    }

    public void snapshotClick() {
        if (PermissionChecker.requestPermission((Context)this.mContext, (String)"android.permission.WRITE_EXTERNAL_STORAGE", (int)10, (int)R.string.pps_open_storage)) {
            this.mModel.snapshot();
            this.mView.startSnapshot();
        }
    }

    public void handleRecordClick() {
        if (PermissionChecker.requestPermission((Context)this.mContext, (String)"android.permission.WRITE_EXTERNAL_STORAGE", (int)10, (int)R.string.pps_open_storage)) {
            if (this.mModel.isRecording()) {
                this.mModel.stopCloudRecordLocalMP4();
            } else {
                this.mModel.startCloudRecordLocalMP4();
            }
        }
    }

    public void onResume() {
        this.mModel.onResume();
        if (!this.mModel.isClickPause() && null != this.mModel.getWaitingTimePiece() && 5 != this.mModel.getPlayState()) {
            this.mModel.resumePlayCloudVideo();
        }
    }

    public void onPause() {
        this.mModel.onPause();
        if (this.mModel.isRecording()) {
            this.mModel.stopCloudRecordLocalMP4();
        }
        if (null != this.downloadDialog) {
            this.downloadDialog.dismiss();
        }
        if (null != this.deleteDialog) {
            this.deleteDialog.dismiss();
        }
        if (this.mModel.isDownloading()) {
            this.cancelDownload();
        } else {
            this.mView.showTimeBarSelectView(false, false);
            this.mView.dismissProgress();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mModel.stopPlayCloudVideo();
        this.mModel.onDestroy();
        this.mHandler.removeCallbacksAndMessages(null);
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 2100: {
                this.handleCloudStorageState(msg);
                break;
            }
            case 2072: {
                this.handleCloudDayList(msg);
                break;
            }
            case 2073: {
                this.handleCloudTimeRangList(msg);
                break;
            }
            case 2074: {
                this.handleCloudTimeLineList(msg);
                break;
            }
            case 2075: {
                this.handleConfig();
                break;
            }
            case 2092: {
                this.handleGotoHybrid(msg);
                break;
            }
            case 2076: {
                this.handleCloudPlay(msg);
                break;
            }
            case 2024: {
                this.handleMute(msg);
                break;
            }
            case 2017: {
                this.handleMsgSnapShot(msg);
                break;
            }
            case 2019: {
                this.handleRecordBegin();
                break;
            }
            case 2018: {
                this.handleRecordFail();
                break;
            }
            case 2020: {
                this.handleRecordOver(msg);
                break;
            }
            case 2079: {
                this.handleCloudPlayStop(msg);
                break;
            }
            case 2080: {
                this.handleCloudVideoInfo(msg);
                break;
            }
            case 2078: {
                this.handleCloudResume(msg);
                break;
            }
            case 2077: {
                this.handleCloudPause(msg);
                break;
            }
            case 7105: {
                this.mView.disMissCloudTip();
                break;
            }
            case 2096: {
                this.handleDismissPhoto();
                break;
            }
            case 2200: {
                this.handleDownload(msg);
                break;
            }
            case 2201: {
                this.handleDownloadProgress(msg);
                break;
            }
            case 2202: {
                this.handleDownloadFinished(msg);
                break;
            }
            case 2203: {
                this.handleCancelDownload(msg);
                break;
            }
            case 2210: {
                this.handleDelete(msg);
                break;
            }
        }
        return super.handleMessage(msg);
    }

    private void handleCloudStorageState(Message msg) {
        int servedStatus = (Integer)msg.obj;
        if (servedStatus == 10010 || servedStatus == 10011) {
            this.servedDataStatus = servedStatus;
            this.mModel.getCloudStorageDayList(servedStatus);
        } else {
            this.mView.showNoCloudDataView(servedStatus);
        }
    }

    private void handleCloudDayList(Message msg) {
        int servedStatus = (Integer)msg.obj;
        this.mView.showNoCloudDataView(servedStatus);
        List<CloudDayBean> cloudDays = this.getCloudDays();
        if (null != cloudDays && cloudDays.size() > 0) {
            int position = cloudDays.size() - 1;
            long currentPlayTimestamp = this.mModel.getCurrentPlayTimestamp();
            if (currentPlayTimestamp > 0L) {
                String selectDay = DateUtils.parseDateToString((long)(currentPlayTimestamp * 1000L), (String)"yyyy-MM-dd", (TimeZone)TimeZoneUtils.getTimeZone((Context)this.mContext, (String)this.mDevId));
                for (int i = 0; i < cloudDays.size(); ++i) {
                    if (!cloudDays.get(i).getUploadDay().equals(selectDay)) continue;
                    position = i;
                    break;
                }
            }
            this.mModel.setCurrentCloudBean(cloudDays.get(position));
            this.mView.updateDayListView();
            this.mView.setSelectDayView(position);
            this.initCloudCamera();
            this.getSelectDayCloudTimes(cloudDays.get(position));
        }
    }

    private void initCloudCamera() {
        this.mModel.initCloudCamera();
    }

    public void getSelectDayCloudTimes(CloudDayBean cloudDayBean) {
        if (cloudDayBean == null) {
            return;
        }
        if (this.mModel.isRecording()) {
            this.mModel.stopCloudRecordLocalMP4();
        }
        this.mView.showVideoLoading(1, R.string.ipc_status_stream);
        this.mView.allControllerBtnEnableState(false);
        this.mView.initCloudTimerBar(cloudDayBean);
        this.mModel.setCurrentCloudBean(cloudDayBean);
        this.getTimeLineInfo(String.valueOf(cloudDayBean.getCurrentStartDayTime()), String.valueOf(cloudDayBean.getCurrentDayEndTime() - 1L));
        this.getMotionDetectByRange(String.valueOf(cloudDayBean.getCurrentStartDayTime()), String.valueOf(cloudDayBean.getCurrentDayEndTime()));
        this.mView.updateDayListView();
    }

    private void getTimeLineInfo(String startTime, String endTime) {
        this.mModel.getTimeLineInfo(startTime, endTime);
    }

    private void handleCloudTimeLineList(Message msg) {
        if (0 == msg.arg1) {
            TimePieceBean timePieceBean = (TimePieceBean)msg.obj;
            if (null == timePieceBean) {
                this.mView.showVideoLoading(4, R.string.ipc_cloudstorage_no_data);
                this.mView.allControllerBtnEnableState(false);
                this.mView.updateTimerRuler(this.mModel.getmTimePieceList(), 0L);
            } else {
                this.mView.updateTimerRuler(this.mModel.getmTimePieceList(), timePieceBean.getStartTimeInMillisecond());
            }
        } else {
            this.mView.showVideoLoading(3, R.string.ipc_status_stream_failed);
            this.mView.allControllerBtnEnableState(false);
        }
    }

    private void getMotionDetectByRange(String timeGT, String timeLT) {
        this.mModel.getMotionDetectByRange(timeGT, timeLT);
    }

    private void handleCloudTimeRangList(Message msg) {
        if (0 == msg.arg1) {
            this.mView.updateTimeRangeListView(this.mModel.getmTimeRangeList(), this.getEncryptKey());
        } else if (1 == msg.arg1) {
            this.mView.showVideoLoading(3, R.string.ipc_status_stream_failed);
            this.mView.allControllerBtnEnableState(false);
        } else {
            this.mView.showTimeRangNull();
            this.mView.allControllerBtnEnableState(false);
        }
    }

    public String getEncryptKey() {
        return this.mModel.getEncryptKey();
    }

    private void handleConfig() {
        int currentPlayTimestamp = (int)this.mModel.getCurrentPlayTimestamp();
        if (!this.isBelongSelectDay(currentPlayTimestamp)) {
            currentPlayTimestamp = -1;
        }
        this.mModel.playCloudDataWithStartTime(currentPlayTimestamp, -1, false);
    }

    private void handleGotoHybrid(Message msg) {
        if (0 == msg.arg1) {
            String ipcUrl = (String)msg.obj;
            UrlRouter.execute((Context)MicroContext.getApplication(), (String)ipcUrl);
        } else {
            ToastUtil.shortToast((Context)this.mContext, (String)this.mContext.getString(R.string.voice_nonetwork));
        }
    }

    private void handleCloudPause(Message msg) {
        if (msg.arg1 == 0) {
            this.mView.videoOnPause();
        }
    }

    private void handleCloudResume(Message msg) {
        this.mView.videoOnResume();
        this.mModel.setResumeMute();
    }

    private void handleCloudVideoInfo(Message msg) {
        if (msg.arg1 == 0) {
            long nTimeStamp = ObjectUtils.getLong((Object)msg.obj);
            this.mView.updateTimerRulerCurrentTime(nTimeStamp * 1000L);
        } else {
            this.mView.showVideoLoading(3, R.string.ipc_status_cloudstorage_stream_failed);
            this.mView.allControllerBtnEnableState(false);
        }
    }

    private void handleCloudPlayStop(Message msg) {
        if (msg.arg1 == 0) {
            this.mView.errorCameraCloudLiveUI(R.string.ipc_video_end);
        } else {
            this.mView.showVideoLoading(3, R.string.ipc_status_cloudstorage_stream_failed);
            this.mView.allControllerBtnEnableState(false);
        }
        if (this.mModel.isRecording()) {
            this.mModel.stopCloudRecordLocalMP4();
        }
    }

    private void handleRecordBegin() {
        this.mView.startRecordRefresh();
        this.mView.otherControllerBtnEableState(false);
    }

    private void handleRecordFail() {
        this.mView.stopRecordRefresh();
        this.mView.showToast(R.string.fail, 1);
        this.mView.otherControllerBtnEableState(true);
    }

    private void handleRecordOver(Message msg) {
        this.mView.stopRecordRefresh();
        if (this.mModel.getPlayState() == 3) {
            this.mView.otherControllerBtnEableState(true);
        }
        if (msg.arg1 == 0) {
            String filePath = (String)msg.obj;
            this.mView.startVideoSnapshot();
            this.mView.showPhoto(filePath, this.mContext.getResources().getString(R.string.ipc_video_saved_tips_android));
        } else {
            this.mView.showToast(R.string.ipc_errmsg_record_failed, 1);
        }
    }

    private void handleMsgSnapShot(Message msg) {
        if (msg.arg1 == 0) {
            String photoPath = (String)msg.obj;
            this.mView.showPhoto(photoPath, this.mContext.getResources().getString(R.string.ipc_screenshot_saved_tips_android));
        } else {
            this.mView.showToast(R.string.fail, 1);
        }
    }

    private void handleMute(Message msg) {
        if (msg.arg1 == 0) {
            if (msg.obj != null) {
                int mute = (Integer)msg.obj;
                this.mView.muteView(mute);
            }
        } else {
            this.mView.showToast(R.string.fail, 1);
        }
    }

    private void handleCloudPlay(Message msg) {
        if (msg.arg1 == 0) {
            this.mView.showVideoLoading(2, R.string.ipc_status_stream);
            this.mView.videoOnResume();
            this.mView.allControllerBtnEnableState(true);
            if (this.isDefaultStatus) {
                this.setMuteValue();
                this.isDefaultStatus = false;
            }
        } else {
            this.mView.videoOnPause();
            this.mView.showVideoLoading(3, R.string.ipc_status_stream_failed);
            this.mView.allControllerBtnEnableState(false);
        }
    }

    public void setTimeRangeBeanStartTime(int timeRangeBeanStartTime) {
        this.mModel.setCurrentPlayTimestamp(timeRangeBeanStartTime);
    }

    public void gotoHybridCloudActivity() {
        this.mModel.getCloudStorageUrl();
    }

    public void dismissDelayedExpiredCloudTip() {
        this.mHandler.sendEmptyMessageDelayed(7105, 6000L);
    }

    public List<TimeRangeBean> getTimeRangeList() {
        return this.mModel.getmTimeRangeList();
    }

    public void selectCloudDay(CloudDayBean dayBean) {
        if (this.mModel.getPlayState() == 1 || this.mModel.isRequestMotionDetect()) {
            return;
        }
        this.mModel.stopPlayCloudVideoWithoutCall();
        this.mView.updateSelectDayView(dayBean);
        this.setTimeRangeBeanStartTime(-1);
        this.mModel.setWaitingTimePiece(null);
        this.getSelectDayCloudTimes(dayBean);
    }

    public boolean isPortrait() {
        return this.isPortrait;
    }

    public int getPlayState() {
        return this.mModel.getPlayState();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        this.isPortrait = newConfig.orientation == 1;
        this.mView.screenViewConfigurationChanged(this.isPortrait);
    }

    public void videoViewClick() {
        if (!this.isPortrait && !this.mModel.isRecording()) {
            this.mView.screenToolBarShow(!this.mView.isScreenOperatorVisible());
        }
    }

    public void showFullScreen() {
        this.mView.screenToolBarShow(!this.mView.isScreenOperatorVisible());
    }

    public void dismissPhotoDelay(int time) {
        this.mHandler.sendEmptyMessageDelayed(2096, (long)time);
    }

    private void handleDismissPhoto() {
        this.mView.dismissPhoto();
    }

    public void dismissPhotoHandle() {
        this.mHandler.removeMessages(2096);
    }

    public void deleteToday() {
        CloudDayBean currentCloudBean = this.mModel.getCurrentCloudBean();
        if (null != currentCloudBean) {
            this.deleteSelect(currentCloudBean.getCurrentStartDayTime(), currentCloudBean.getCurrentDayEndTime(), true);
        }
    }

    @Deprecated
    public void deleteSelect(long mSelectStartTime, long mSelectEndTime) {
        this.deleteSelect(mSelectStartTime, mSelectEndTime, false);
    }

    private void deleteSelect(final long mSelectStartTime, final long mSelectEndTime, boolean isAllDay) {
        this.deleteDialog = FamilyDialogUtils.showConfirmAndCancelDialog((Context)this.mContext, (String)this.mContext.getString(R.string.ipc_cloud_delete_comfirm), (String)(isAllDay ? this.mContext.getString(R.string.ipc_cloud_delete_comfirm_today) : this.mContext.getString(R.string.ipc_cloud_delete_comfirm_selected)), (String)this.mContext.getString(R.string.ipc_cloud_delete), (String)this.mContext.getString(R.string.cancel), (BooleanConfirmAndCancelListener)new BooleanConfirmAndCancelListener(){

            public boolean onConfirm(Object o) {
                CameraCloudPresenter.this.mModel.deleteSelectCloudData(mSelectStartTime, mSelectEndTime);
                CameraCloudPresenter.this.mView.showProgress(CameraCloudPresenter.this.mContext.getString(R.string.ipc_cloud_delete));
                return true;
            }

            public boolean onCancel(Object o) {
                return true;
            }
        });
        if (this.deleteDialog != null) {
            this.deleteDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                    CameraCloudPresenter.this.mView.showTimeBarSelectView(false);
                }
            });
            this.deleteDialog.show();
        }
    }

    private void handleDelete(Message msg) {
        String dialogContext;
        String dialogTitle;
        this.mView.dismissProgress();
        if (msg.arg1 == 0) {
            this.mModel.stopPlayCloudVideoWithoutCall();
            this.mView.showTimeBarSelectView(false, false);
            this.mModel.getCloudStorageDayList(this.servedDataStatus);
            dialogTitle = this.mContext.getString(R.string.ipc_cloud_delete_success);
            dialogContext = this.mContext.getString(R.string.ipc_cloud_delete_complete_message);
        } else {
            dialogTitle = this.mContext.getString(R.string.ipc_cloud_delete_failure);
            dialogContext = (String)msg.obj;
        }
        FamilyDialogUtils.showConfirmDialog((Context)this.mContext, (String)dialogTitle, (String)dialogContext, (String)this.mContext.getString(R.string.ipc_confirm_sure), null);
    }

    public void downloadSelect(final long mSelectStartTime, final long mSelectEndTime) {
        this.downloadDialog = FamilyDialogUtils.showConfirmAndCancelDialog((Context)this.mContext, (String)this.mContext.getString(R.string.ipc_cloud_download_start), (String)this.mContext.getString(R.string.ipc_cloud_download_start_body), (String)this.mContext.getString(R.string.Confirm), (String)this.mContext.getString(R.string.cancel), (BooleanConfirmAndCancelListener)new BooleanConfirmAndCancelListener(){

            public boolean onConfirm(Object o) {
                if (PermissionChecker.requestPermission((Context)CameraCloudPresenter.this.mContext, (String)"android.permission.WRITE_EXTERNAL_STORAGE", (int)10, (int)R.string.pps_open_storage)) {
                    CameraCloudPresenter.this.mView.showDownloadProgress(0);
                    CameraCloudPresenter.this.mModel.startCloudDataDownload(mSelectStartTime, mSelectEndTime);
                }
                return true;
            }

            public boolean onCancel(Object o) {
                CameraCloudPresenter.this.mView.showTimeBarSelectView(false);
                return true;
            }
        });
        this.downloadDialog.show();
    }

    private void handleDownload(Message msg) {
        if (msg.arg1 == 0) {
            this.mView.showDownloadStart();
        } else {
            int errorCode = (Integer)msg.obj;
            FamilyDialogUtils.showConfirmDialog((Context)this.mContext, (String)this.mContext.getString(R.string.ipc_cloud_download_failed), (String)(errorCode == -20002 ? this.mContext.getString(R.string.ipc_errmsg_cdf_cant_found_video) : this.mContext.getString(R.string.ipc_errmsg_cdf_network)), (String)this.mContext.getString(R.string.ipc_confirm_sure), null);
        }
    }

    private void handleDownloadProgress(Message msg) {
        int progress = (Integer)msg.obj;
        this.mView.showDownloadProgress(progress);
    }

    private void handleDownloadFinished(Message msg) {
        this.mView.dismissProgress();
        if (msg.arg1 == 0) {
            FamilyDialogUtils.showConfirmAndCancelDialog((Context)this.mContext, (String)this.mContext.getString(R.string.ipc_cloud_download_complete), (String)this.mContext.getString(R.string.ipc_cloud_download_complete_body), (String)this.mContext.getString(R.string.ipc_cloud_download_check_now), (String)this.mContext.getString(R.string.cancel), (BooleanConfirmAndCancelListener)new BooleanConfirmAndCancelListener(){

                public boolean onConfirm(Object o) {
                    UrlRouterUtils.gotoLocalVideoPhoto((Context)CameraCloudPresenter.this.mContext, (String)CameraCloudPresenter.this.mDevId, (int)CameraUIThemeUtils.getCurrentThemeId());
                    return true;
                }

                public boolean onCancel(Object o) {
                    return true;
                }
            }).show();
            this.mView.showTimeBarSelectView(false);
        } else {
            int errorCode = (Integer)msg.obj;
            FamilyDialogUtils.showConfirmDialog((Context)this.mContext, (String)this.mContext.getString(R.string.ipc_cloud_download_failed), (String)(errorCode == -20002 ? this.mContext.getString(R.string.ipc_errmsg_cdf_cant_found_video) : this.mContext.getString(R.string.ipc_errmsg_cdf_network)), (String)this.mContext.getString(R.string.ipc_confirm_sure), null);
        }
    }

    public void cancelDownload() {
        this.mModel.stopCloudDataDownload();
    }

    private void handleCancelDownload(Message msg) {
        this.mView.showTimeBarSelectView(false);
        this.mView.dismissProgress();
    }
}

