/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.ipc.cloud.panel.model;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tuya.smart.android.common.utils.L;
import com.tuya.smart.android.common.utils.SafeHandler;
import com.tuya.smart.android.network.Business;
import com.tuya.smart.android.network.http.BusinessResponse;
import com.tuya.smart.api.MicroContext;
import com.tuya.smart.api.service.MicroServiceManager;
import com.tuya.smart.camera.base.bean.CloudDayBean;
import com.tuya.smart.camera.base.bean.CloudUrlBean;
import com.tuya.smart.camera.base.bean.TimeRangeBean;
import com.tuya.smart.camera.base.business.HBusiness;
import com.tuya.smart.camera.base.utils.FamilyManagerUtils;
import com.tuya.smart.camera.base.utils.MessageUtil;
import com.tuya.smart.camera.camerasdk.typlayer.callback.IRegistorIOTCListener;
import com.tuya.smart.camera.camerasdk.typlayer.callback.OnP2PCameraListener;
import com.tuya.smart.camera.camerasdk.typlayer.callback.OperationCallBack;
import com.tuya.smart.camera.camerasdk.typlayer.callback.OperationDelegateCallBack;
import com.tuya.smart.camera.camerasdk.typlayer.callback.ProgressCallBack;
import com.tuya.smart.camera.uiview.bean.TimePieceBean;
import com.tuya.smart.camera.uiview.timerrulerview.CalendarUtils;
import com.tuya.smart.camera.utils.IPCCameraUtils;
import com.tuya.smart.camera.utils.TimeZoneUtils;
import com.tuya.smart.ipc.cloud.panel.model.BaseCloudModel;
import com.tuya.smart.ipc.cloud.panel.model.ICameraCloudModel;
import com.tuya.smart.ipc.panel.api.AbsCameraCloudService;
import com.tuya.smart.ipc.panel.api.CameraCloudServiceListener;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class CameraCloudModel
extends BaseCloudModel
implements ICameraCloudModel,
CameraCloudServiceListener {
    private static final String TAG = "CameraCloudModel";
    private static final int LIMIT = -1;
    private List<TimePieceBean> mTimePieceList = new ArrayList<TimePieceBean>();
    private List<TimeRangeBean> mTimeRangeList = new ArrayList<TimeRangeBean>();
    private List<Integer> mPrefixs = new ArrayList<Integer>();
    private int offset = 0;
    private CloudDayBean mCurrentDayBean;
    private long mCurrentPlayTimestamp;
    private TimePieceBean mWaitingTimePiece;
    private boolean isRecording;
    private boolean isDownloading;
    private int muteValue = 1;
    private int playState = 0;
    private boolean isRequestMotionDetect;
    private boolean mIsClick;
    private List<CloudDayBean> mDayBeanList = new ArrayList<CloudDayBean>();
    private String mEncryptKey = "";
    private String mAuthorityJson;
    private boolean isInitCamera;
    private HBusiness mHBusiness;
    private String mIpcUrl;
    private CompositeDisposable mCompositeDisposable = new CompositeDisposable();

    public CameraCloudModel(Context ctx, String devId, SafeHandler handler) {
        super(ctx, devId, handler);
        this.getCameraCloudService().registerCameraCloudServiceListener((CameraCloudServiceListener)this);
        this.getCloudStorageState();
    }

    private AbsCameraCloudService getCameraCloudService() {
        AbsCameraCloudService cameraCloudService = (AbsCameraCloudService)MicroServiceManager.getInstance().findServiceByInterface(AbsCameraCloudService.class.getName());
        if (cameraCloudService == null) {
            L.e((String)TAG, (String)"impl of AbsCameraCloudService not found");
        }
        return cameraCloudService;
    }

    private void getCloudStorageState() {
        if (this.getCameraCloudService() != null) {
            this.getCameraCloudService().queryCloudServiceStatus(this.mDeviceBean);
        } else {
            this.mHandler.sendMessage(MessageUtil.getMessage((int)2100, (int)1, (Object)10006));
        }
    }

    @Override
    public void getCloudStorageDayList(final int servedStatus) {
        if (this.mDeviceBean == null) {
            return;
        }
        Observable daysOb = this.mCameraBusiness.queryCloudMediaCount(this.mDeviceBean.getDevId(), TimeZoneUtils.getTimezoneGCMById((String)TimeZoneUtils.getTimeZone((Context)this.mContext, (String)this.mDeviceBean.getDevId()).getID()));
        Observable secretOb = this.mCameraBusiness.getCloudSecret(this.mDeviceBean.getDevId());
        Disposable disposable = Observable.zip((ObservableSource)daysOb, (ObservableSource)secretOb, (BiFunction)new BiFunction<JSONArray, JSONObject, Integer>(){

            public Integer apply(JSONArray objects, JSONObject jsonObject) throws Exception {
                int code = 10006;
                CameraCloudModel.this.mDayBeanList.clear();
                if (objects != null) {
                    CameraCloudModel.this.mDayBeanList = JSONArray.parseArray((String)objects.toJSONString(), CloudDayBean.class);
                    if (CameraCloudModel.this.mDayBeanList != null && CameraCloudModel.this.mDayBeanList.size() > 0) {
                        Collections.sort(CameraCloudModel.this.mDayBeanList);
                        TimeZone timeZone = TimeZoneUtils.getTimeZone((Context)CameraCloudModel.this.mContext, (String)CameraCloudModel.this.mDeviceBean.getDevId());
                        for (CloudDayBean bean : CameraCloudModel.this.mDayBeanList) {
                            bean.setTimeZone(timeZone);
                        }
                        code = servedStatus == 10010 ? 10003 : 10004;
                    } else {
                        int n = code = servedStatus == 10010 ? 10002 : 10005;
                    }
                }
                if (jsonObject != null) {
                    CameraCloudModel.this.mEncryptKey = jsonObject.getString("encryptKey");
                    L.d((String)CameraCloudModel.TAG, (String)("mEncryptKey " + CameraCloudModel.this.mEncryptKey));
                    if (TextUtils.isEmpty((CharSequence)CameraCloudModel.this.mEncryptKey)) {
                        code = 10006;
                    }
                }
                return code;
            }
        }).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Integer>(){

            public void accept(Integer integer) throws Exception {
                CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2072, (int)0, (Object)integer));
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2072, (int)1, (Object)10006));
            }
        });
        this.mCompositeDisposable.add(disposable);
    }

    @Override
    public List<CloudDayBean> getCloudStorageDays() {
        return this.mDayBeanList;
    }

    @Override
    public void initCloudCamera() {
        if (null == this.mCloudCamera || null == this.mDeviceBean) {
            return;
        }
        if (!this.isInitCamera) {
            this.mCloudCamera.createCloudDevice(MicroContext.getApplication().getCacheDir().getPath(), this.mDeviceBean.getDevId());
            this.isInitCamera = true;
        }
    }

    @Override
    public void getMotionDetectByRange(String timeGT, String timeLT) {
        if (this.isFont) {
            this.isRequestMotionDetect = true;
            Disposable disposable = this.mCameraBusiness.getTimeRange(this.mDeviceBean.getDevId(), timeGT, timeLT, this.offset, -1).subscribeOn(Schedulers.io()).subscribe((Consumer)new Consumer<JSONObject>(){

                public void accept(JSONObject o) {
                    L.d((String)CameraCloudModel.TAG, (String)("o  getTimeRange +++++ " + o));
                    int totalCount = o.getInteger("totalCount");
                    if (totalCount > 0) {
                        CameraCloudModel.this.mTimeRangeList.clear();
                        JSONArray jsonArray = o.getJSONArray("datas");
                        CameraCloudModel.this.mTimeRangeList = JSONArray.parseArray((String)jsonArray.toJSONString(), TimeRangeBean.class);
                        CameraCloudModel.this.mHandler.sendEmptyMessage(2073);
                    } else {
                        CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2073, (int)-1));
                    }
                    CameraCloudModel.this.isRequestMotionDetect = false;
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) {
                    CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2073, (int)1));
                    CameraCloudModel.this.isRequestMotionDetect = false;
                }
            });
            this.mCompositeDisposable.add(disposable);
        }
    }

    @Override
    public List<TimeRangeBean> getmTimeRangeList() {
        return this.mTimeRangeList;
    }

    @Override
    public int getSdkProvider() {
        return this.sdkProvider;
    }

    @Override
    public List<TimePieceBean> getmTimePieceList() {
        return this.mTimePieceList;
    }

    @Override
    public CloudDayBean getCurrentCloudBean() {
        return this.mCurrentDayBean;
    }

    @Override
    public void setCurrentCloudBean(CloudDayBean dayBean) {
        this.mCurrentDayBean = dayBean;
        for (int i = 0; i < this.getCloudStorageDays().size(); ++i) {
            if (dayBean.getUploadDay().equals(this.getCloudStorageDays().get(i).getUploadDay())) {
                this.getCloudStorageDays().get(i).setStatus(CloudDayBean.STATUS.SELECT);
                continue;
            }
            this.getCloudStorageDays().get(i).setStatus(CloudDayBean.STATUS.UN_SELECT);
        }
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    public void getTimeLineInfo(String timeGT, String timeLT) {
        if (this.isFont) {
            this.playState = 1;
            Disposable disposable = this.mCameraBusiness.getCloudTimeLine(this.mDeviceBean.getDevId(), timeGT, timeLT).observeOn(Schedulers.io()).concatMap(new Function(){

                public Object apply(Object o) {
                    CameraCloudModel.this.mTimePieceList.clear();
                    CameraCloudModel.this.mTimePieceList = JSONArray.parseArray((String)((JSONArray)o).toJSONString(), TimePieceBean.class);
                    L.d((String)CameraCloudModel.TAG, (String)("o  getTimeLineInfo +++++ " + o));
                    if (CameraCloudModel.this.mTimePieceList != null && CameraCloudModel.this.mTimePieceList.size() > 0) {
                        CameraCloudModel.this.mPrefixs.clear();
                        for (int i = 0; i < CameraCloudModel.this.mTimePieceList.size(); ++i) {
                            CameraCloudModel.this.mPrefixs.add(((TimePieceBean)CameraCloudModel.this.mTimePieceList.get(i)).getPrefix());
                        }
                        CameraCloudModel.this.mWaitingTimePiece = (TimePieceBean)CameraCloudModel.this.mTimePieceList.get(0);
                        CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2074, (int)0, CameraCloudModel.this.mTimePieceList.get(0)));
                        return CameraCloudModel.this.mCameraBusiness.getMediaPrefixs(CameraCloudModel.this.mDeviceBean.getDevId(), JSON.toJSONString((Object)CameraCloudModel.this.mPrefixs));
                    }
                    CameraCloudModel.this.playState = 0;
                    CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2074, (int)0, null));
                    return Observable.empty();
                }
            }).subscribe((Consumer)new Consumer<String>(){

                public void accept(String o) {
                    L.d((String)CameraCloudModel.TAG, (String)("o  configCloudDataTags +++++ " + o));
                    CameraCloudModel.this.configCloudDataTags(o);
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) {
                    CameraCloudModel.this.playState = -1;
                    CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2074, (int)1));
                }
            });
            this.mCompositeDisposable.add(disposable);
        }
    }

    private void configCloudDataTags(String configCloudTags) {
        if (this.mCloudCamera == null) {
            return;
        }
        this.mCloudCamera.configCloudDataTags(configCloudTags, new OperationDelegateCallBack(){

            public void onSuccess(int sessionId, int requestId, String data) {
                CameraCloudModel.this.playState = 1;
                CameraCloudModel.this.requestAuthToken(CameraCloudModel.this.mDeviceBean.getDevId(), data);
            }

            public void onFailure(int sessionId, int requestId, int errCode) {
                CameraCloudModel.this.playState = -1;
                CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2074, (int)1));
            }
        });
    }

    private void requestAuthToken(String devId, String data) {
        if (null != this.mCameraBusiness) {
            Disposable disposable = this.mCameraBusiness.getAuthorityGet(devId, data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<String>(){

                public void accept(String o) {
                    L.d((String)CameraCloudModel.TAG, (String)(" mAuthorityJson " + o));
                    if (o != null) {
                        CameraCloudModel.this.mAuthorityJson = o;
                        CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2075, (int)0));
                    } else {
                        CameraCloudModel.this.playState = -1;
                        CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2074, (int)1));
                    }
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) {
                    CameraCloudModel.this.playState = -1;
                    CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2074, (int)1));
                }
            });
            this.mCompositeDisposable.add(disposable);
        }
    }

    @Override
    public TimePieceBean getWaitingTimePiece() {
        return this.mWaitingTimePiece;
    }

    @Override
    public void setWaitingTimePiece(TimePieceBean timePiece) {
        this.mWaitingTimePiece = timePiece;
    }

    @Override
    public void generateMonitor(Object monitor) {
        if (this.mCloudCamera == null) {
            return;
        }
        if (monitor instanceof IRegistorIOTCListener) {
            this.mCloudCamera.generateCloudCameraView((IRegistorIOTCListener)monitor);
        }
    }

    @Override
    public void playCloudDataWithStartTime(int startTime, int endTime, final boolean isEvent) {
        if (this.isFont) {
            if (this.mWaitingTimePiece == null) {
                this.playState = -1;
                this.mHandler.sendMessage(MessageUtil.getMessage((int)2076, (int)1));
                return;
            }
            if (startTime == -1 && endTime == -1) {
                startTime = this.mWaitingTimePiece.getStartTime();
            }
            final int tempEndTime = (int)(CalendarUtils.getTodayEnd((long)((long)startTime * 1000L)) / 1000L) - 1;
            final int tempStartTime = startTime;
            if (this.mCloudCamera == null) {
                return;
            }
            if (TextUtils.isEmpty((CharSequence)this.mAuthorityJson)) {
                return;
            }
            Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Object>(){

                public void subscribe(ObservableEmitter<Object> e) {
                    CameraCloudModel.this.playState = 1;
                    CameraCloudModel.this.mCloudCamera.playCloudDataWithStartTime((long)tempStartTime, (long)tempEndTime, isEvent, CameraCloudModel.this.mAuthorityJson, CameraCloudModel.this.mEncryptKey, new OperationCallBack(){

                        public void onSuccess(int sessionId, int requestId, String data, Object camera) {
                            CameraCloudModel.this.playState = 3;
                            CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2076, (int)0));
                        }

                        public void onFailure(int sessionId, int requestId, int errCode, Object camera) {
                            CameraCloudModel.this.playState = -1;
                            CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2076, (int)1));
                        }
                    }, new OperationCallBack(){

                        public void onSuccess(int sessionId, int requestId, String data, Object camera) {
                            CameraCloudModel.this.playState = 5;
                            CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2079, (int)0));
                        }

                        public void onFailure(int sessionId, int requestId, int errCode, Object camera) {
                            CameraCloudModel.this.playState = 5;
                            CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2079, (int)1));
                        }
                    });
                }
            }).subscribeOn(Schedulers.newThread()).subscribe();
        }
    }

    @Override
    public void resumePlayCloudVideo() {
        if (this.mCloudCamera == null) {
            return;
        }
        Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Object>(){

            public void subscribe(ObservableEmitter<Object> e) {
                CameraCloudModel.this.playState = 1;
                CameraCloudModel.this.mCloudCamera.resumePlayCloudVideo(new OperationDelegateCallBack(){

                    public void onSuccess(int sessionId, int requestId, String data) {
                        CameraCloudModel.this.playState = 3;
                        CameraCloudModel.this.mHandler.sendEmptyMessageDelayed(2078, 1500L);
                    }

                    public void onFailure(int sessionId, int requestId, int errCode) {
                        CameraCloudModel.this.playState = -1;
                    }
                });
            }
        }).subscribeOn(Schedulers.newThread()).observeOn(Schedulers.newThread()).subscribe();
    }

    @Override
    public void pausePlayCloudVideo(final boolean isClick) {
        if (this.mCloudCamera == null) {
            return;
        }
        Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Object>(){

            public void subscribe(ObservableEmitter<Object> e) {
                CameraCloudModel.this.playState = 1;
                CameraCloudModel.this.mCloudCamera.pausePlayCloudVideo(new OperationDelegateCallBack(){

                    public void onSuccess(int sessionId, int requestId, String data) {
                        CameraCloudModel.this.mIsClick = isClick;
                        CameraCloudModel.this.playState = 4;
                        CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2077, (int)0, (Object)data));
                    }

                    public void onFailure(int sessionId, int requestId, int errCode) {
                        CameraCloudModel.this.playState = -1;
                    }
                });
            }
        }).subscribeOn(Schedulers.newThread()).observeOn(Schedulers.newThread()).subscribe();
    }

    @Override
    public void stopPlayCloudVideo() {
        if (this.mCloudCamera == null) {
            return;
        }
        Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Object>(){

            public void subscribe(ObservableEmitter<Object> e) {
                CameraCloudModel.this.playState = 1;
                CameraCloudModel.this.mCloudCamera.stopPlayCloudVideo(new OperationDelegateCallBack(){

                    public void onSuccess(int sessionId, int requestId, String data) {
                        CameraCloudModel.this.playState = 5;
                        CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2079, (int)0));
                    }

                    public void onFailure(int sessionId, int requestId, int errCode) {
                        CameraCloudModel.this.playState = 5;
                        CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2079, (int)1));
                    }
                });
            }
        }).subscribeOn(Schedulers.newThread()).observeOn(Schedulers.newThread()).subscribe();
    }

    @Override
    public void stopPlayCloudVideoWithoutCall() {
        if (this.mCloudCamera == null) {
            return;
        }
        Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Object>(){

            public void subscribe(ObservableEmitter<Object> e) {
                CameraCloudModel.this.playState = 1;
                CameraCloudModel.this.mCloudCamera.stopPlayCloudVideo(new OperationDelegateCallBack(){

                    public void onSuccess(int sessionId, int requestId, String data) {
                        CameraCloudModel.this.playState = 5;
                    }

                    public void onFailure(int sessionId, int requestId, int errCode) {
                        CameraCloudModel.this.playState = 5;
                    }
                });
            }
        }).subscribeOn(Schedulers.newThread()).observeOn(Schedulers.newThread()).subscribe();
    }

    @Override
    public String getEncryptKey() {
        return this.mEncryptKey;
    }

    @Override
    public boolean isDownloading() {
        return this.isDownloading;
    }

    @Override
    public void startCloudRecordLocalMP4() {
        if (this.mCloudCamera == null) {
            return;
        }
        this.mCloudCamera.startRecordLocalMp4(IPCCameraUtils.recordPath((String)this.getDevId()), String.valueOf(System.currentTimeMillis()), new OperationDelegateCallBack(){

            public void onSuccess(int sessionId, int requestId, String data) {
                CameraCloudModel.this.isRecording = true;
                CameraCloudModel.this.mHandler.sendEmptyMessage(2019);
            }

            public void onFailure(int sessionId, int requestId, int errCode) {
                CameraCloudModel.this.isRecording = false;
                CameraCloudModel.this.mHandler.sendEmptyMessage(2018);
            }
        });
    }

    @Override
    public void stopCloudRecordLocalMP4() {
        if (this.mCloudCamera == null) {
            return;
        }
        this.mCloudCamera.stopRecordLocalMp4(new OperationDelegateCallBack(){

            public void onSuccess(int sessionId, int requestId, String data) {
                CameraCloudModel.this.isRecording = false;
                CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2020, (int)0, (Object)data));
            }

            public void onFailure(int sessionId, int requestId, int errCode) {
                CameraCloudModel.this.isRecording = false;
                CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2020, (int)1));
            }
        });
    }

    @Override
    public int getPlayState() {
        return this.playState;
    }

    @Override
    public boolean isRecording() {
        return this.isRecording;
    }

    @Override
    public boolean isClickPause() {
        return this.mIsClick;
    }

    @Override
    public void onResume() {
        this.isFont = true;
        if (null != this.mCloudCamera) {
            this.mCloudCamera.registorOnP2PCameraListener((OnP2PCameraListener)this);
        }
    }

    @Override
    public void snapshot() {
        if (this.mCloudCamera == null) {
            return;
        }
        this.mCloudCamera.snapshot(IPCCameraUtils.recordSnapshotPath((String)this.getDevId()), new OperationDelegateCallBack(){

            public void onSuccess(int sessionId, int requestId, String data) {
                CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2017, (int)0, (Object)data));
            }

            public void onFailure(int sessionId, int requestId, int errCode) {
                CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2017, (int)1));
            }
        });
    }

    @Override
    public void setMuteValue() {
        if (this.mCloudCamera == null) {
            return;
        }
        int mute = this.muteValue == 1 ? 0 : 1;
        this.mCloudCamera.setCloudMute(mute, new OperationDelegateCallBack(){

            public void onSuccess(int sessionId, int requestId, String data) {
                CameraCloudModel.this.muteValue = Integer.parseInt(data);
                CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2024, (int)0, (Object)CameraCloudModel.this.muteValue));
            }

            public void onFailure(int sessionId, int requestId, int errCode) {
                CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2024, (int)1));
            }
        });
    }

    @Override
    public void setPauseMute() {
        if (null != this.mCloudCamera) {
            this.mCloudCamera.setCloudMute(1, null);
        }
    }

    @Override
    public void setResumeMute() {
        if (null != this.mCloudCamera) {
            this.mCloudCamera.setCloudMute(this.muteValue, null);
        }
    }

    @Override
    public void getMuteValue() {
        if (this.mCloudCamera == null) {
            return;
        }
        this.muteValue = this.mCloudCamera.getCloudMute();
        this.mHandler.sendMessage(MessageUtil.getMessage((int)2024, (int)0, (Object)this.muteValue));
    }

    @Override
    public void onPause() {
        this.isFont = false;
        if (null != this.mCloudCamera) {
            this.mCloudCamera.removeOnP2PCameraListener();
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.getCameraCloudService().unregisterCameraCloudServiceListener((CameraCloudServiceListener)this);
        this.playState = 0;
        if (null != this.mCloudCamera) {
            this.mCloudCamera.deinitCloudCamera();
        }
        if (null != this.mHBusiness) {
            this.mHBusiness.onDestroy();
        }
        this.clearCache();
        this.mCompositeDisposable.dispose();
    }

    private void clearCache() {
        this.mDayBeanList.clear();
        this.mTimePieceList.clear();
        this.mTimeRangeList.clear();
        this.mPrefixs.clear();
        this.mCurrentPlayTimestamp = 0L;
        this.isInitCamera = false;
    }

    @Override
    public void getCloudStorageUrl() {
        if (null == this.mHBusiness) {
            this.mHBusiness = new HBusiness();
        }
        this.mHBusiness.getCloudStorageUrl((Business.ResultListener)new Business.ResultListener<ArrayList<CloudUrlBean>>(){

            public void onFailure(BusinessResponse businessResponse, ArrayList<CloudUrlBean> cloudUrlBeans, String s) {
                CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2092, (int)1));
            }

            public void onSuccess(BusinessResponse businessResponse, ArrayList<CloudUrlBean> cloudUrlBeans, String s) {
                if (cloudUrlBeans == null) {
                    CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2092, (int)1));
                } else {
                    for (CloudUrlBean cloudUrlBean : cloudUrlBeans) {
                        if (!"ipc".equals(cloudUrlBean.getKey())) continue;
                        CameraCloudModel.this.mIpcUrl = "https://" + cloudUrlBean.getAppDomain();
                        String params = "?instanceId=" + CameraCloudModel.this.getUUID() + "&deviceId=" + CameraCloudModel.this.getUUID() + "&lang=" + Locale.getDefault().getLanguage() + "&serveType=cloud_storage&homeId=" + FamilyManagerUtils.getCurrentHomeId();
                        CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2092, (int)0, (Object)(CameraCloudModel.this.mIpcUrl + params)));
                        break;
                    }
                }
            }
        });
    }

    @Override
    public void onReceiveFrameYUVData(int sessionId, ByteBuffer y, ByteBuffer u, ByteBuffer v, int width, int height, int nFrameRate, int nIsKeyFrame, long timestamp, long nProgress, long nDuration, Object camera) {
        super.onReceiveFrameYUVData(sessionId, y, u, v, width, height, nFrameRate, nIsKeyFrame, timestamp, nProgress, nDuration, camera);
        this.mCurrentPlayTimestamp = timestamp;
    }

    public void onReceiveAudioBufferData(int nSampleRate, int nChannelNum, int nBitWidth, long nTimeStamp, long progress, long duration) {
    }

    public void onReceiveSpeakerEchoData(ByteBuffer pcm, int sampleRate) {
    }

    @Override
    public void setCurrentPlayTimestamp(long mCurrentPlayTimestamp) {
        this.mCurrentPlayTimestamp = mCurrentPlayTimestamp;
    }

    @Override
    public long getCurrentPlayTimestamp() {
        return this.mCurrentPlayTimestamp;
    }

    @Override
    public void startCloudDataDownload(long startTime, long stopTime) {
        if (this.mCloudCamera == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mAuthorityJson)) {
            return;
        }
        this.mCloudCamera.startCloudDataDownload(startTime, stopTime, this.mAuthorityJson, this.mEncryptKey, IPCCameraUtils.recordPath((String)this.getDevId()), "download_" + System.currentTimeMillis(), new OperationCallBack(){

            public void onSuccess(int sessionId, int requestId, String data, Object camera) {
                L.e((String)CameraCloudModel.TAG, (String)" startCloudDataDownload onSuccess");
                CameraCloudModel.this.isDownloading = true;
                CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2200, (int)0));
            }

            public void onFailure(int sessionId, int requestId, int errCode, Object camera) {
                L.e((String)CameraCloudModel.TAG, (String)(" startCloudDataDownload onFailure= " + errCode));
                CameraCloudModel.this.isDownloading = false;
                CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2200, (int)1, (Object)errCode));
            }
        }, new ProgressCallBack(){

            public void onProgress(int sessionId, int requestId, int pos, Object camera) {
                L.e((String)CameraCloudModel.TAG, (String)(" startCloudDataDownload onProgress= " + pos));
                CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2201, (int)0, (Object)pos));
            }
        }, new OperationCallBack(){

            public void onSuccess(int sessionId, int requestId, String data, Object camera) {
                L.e((String)CameraCloudModel.TAG, (String)" startCloudDataDownload Finished onSuccess");
                CameraCloudModel.this.isDownloading = false;
                CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2202, (int)0));
            }

            public void onFailure(int sessionId, int requestId, int errCode, Object camera) {
                L.e((String)CameraCloudModel.TAG, (String)(" startCloudDataDownload Finished onFailure= " + errCode));
                CameraCloudModel.this.isDownloading = false;
                CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2202, (int)1, (Object)errCode));
            }
        });
    }

    @Override
    public void stopCloudDataDownload() {
        if (this.mCloudCamera == null) {
            return;
        }
        this.mCloudCamera.stopCloudDataDownload(new OperationCallBack(){

            public void onSuccess(int sessionId, int requestId, String data, Object camera) {
                L.e((String)CameraCloudModel.TAG, (String)" stopCloudDataDownload Finished onSuccess");
                CameraCloudModel.this.isDownloading = false;
                CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2203, (int)0));
            }

            public void onFailure(int sessionId, int requestId, int errCode, Object camera) {
                L.e((String)CameraCloudModel.TAG, (String)(" stopCloudDataDownload Finished onFailure= " + errCode));
                CameraCloudModel.this.isDownloading = false;
                CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2203, (int)1));
            }
        });
    }

    @Override
    public void deleteSelectCloudData(long mSelectStartTime, long mSelectEndTime) {
        if (null != this.mCameraBusiness) {
            this.mCameraBusiness.deleteCloudDataByDay(this.getDevId(), mSelectStartTime, mSelectEndTime, TimeZoneUtils.getTimezoneGCMById((String)TimeZone.getDefault().getID())).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<JSONObject>(){

                public void accept(JSONObject o) {
                    CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2210, (int)0));
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) {
                    CameraCloudModel.this.mHandler.sendMessage(MessageUtil.getMessage((int)2210, (int)1, (Object)throwable.getMessage()));
                }
            });
        }
    }

    public void onGetTimeRange(int code, List<TimeRangeBean> data) {
    }

    public void onGetCloudStorageStateSuc(int state) {
        this.mHandler.sendMessage(MessageUtil.getMessage((int)2100, (int)0, (Object)state));
    }

    public void onGetCloudStorageStateFailed(int code, String errMsg) {
        this.mHandler.sendMessage(MessageUtil.getMessage((int)2100, (int)1, (Object)code));
    }

    @Override
    public boolean isRequestMotionDetect() {
        return this.isRequestMotionDetect;
    }

    @Override
    public void onSessionStatusChanged(Object camera, int sessionId, int sessionStatus) {
        super.onSessionStatusChanged(camera, sessionId, sessionStatus);
        if (this.isRecording) {
            this.stopCloudRecordLocalMP4();
        }
        if (this.isDownloading) {
            this.stopCloudDataDownload();
        }
    }
}

