/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.ipc.cloud.panel.model;

import android.content.Context;
import android.text.TextUtils;
import com.tuya.smart.android.common.utils.SafeHandler;
import com.tuya.smart.android.mvp.model.BaseModel;
import com.tuya.smart.camera.base.utils.MessageUtil;
import com.tuya.smart.camera.camerasdk.typlayer.callback.OnP2PCameraListener;
import com.tuya.smart.camera.ipccamerasdk.cloud.ITYCloudCamera;
import com.tuya.smart.camera.ipccamerasdk.cloud.TYCloudCamera;
import com.tuya.smart.camera.ipccamerasdk.utils.CameraConstant;
import com.tuya.smart.camera.utils.ActivityUtils;
import com.tuya.smart.home.sdk.TuyaHomeSdk;
import com.tuya.smart.ipc.cloud.panel.business.CameraCloudBusiness;
import com.tuya.smart.sdk.bean.DeviceBean;
import java.nio.ByteBuffer;
import java.util.Map;

public abstract class BaseCloudModel
extends BaseModel
implements OnP2PCameraListener {
    protected DeviceBean mDeviceBean;
    protected ITYCloudCamera mCloudCamera;
    protected boolean isFont;
    protected CameraCloudBusiness mCameraBusiness;
    protected int sdkProvider;
    private static final String EAPIL_UINAME = "singleHalfFisheyeCamera";
    private static final String EAPIL_CLOUD_PLAYER = "com.tuya.smart.ipc.fisheye.sdk.EapilCloudPlayer";

    public BaseCloudModel(Context ctx, String devId, SafeHandler handler) {
        super(ctx, handler);
        this.mDeviceBean = TuyaHomeSdk.getDataInstance().getDeviceBean(devId);
        if (this.mDeviceBean == null) {
            ActivityUtils.finishCamera();
            return;
        }
        this.sdkProvider = CameraConstant.getsdkProvider((Map)this.mDeviceBean.getSkills());
        if (this.sdkProvider == 2) {
            if (!TextUtils.isEmpty((CharSequence)this.mDeviceBean.getUiName()) && EAPIL_UINAME.equals(this.mDeviceBean.getUiName())) {
                this.sdkProvider = 4;
                try {
                    this.mCloudCamera = (ITYCloudCamera)Class.forName(EAPIL_CLOUD_PLAYER).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    this.mCloudCamera = new TYCloudCamera();
                }
            } else {
                this.mCloudCamera = new TYCloudCamera();
            }
        } else {
            this.mCloudCamera = new TYCloudCamera();
        }
        this.initBusiness();
    }

    public String getDevId() {
        if (this.mDeviceBean != null) {
            return this.mDeviceBean.getDevId();
        }
        return null;
    }

    public String getUUID() {
        if (this.mDeviceBean != null) {
            String uuid = null;
            if (this.isNvrSubDevice(this.mDeviceBean)) {
                String nvrDevId = this.mDeviceBean.getMeshId();
                uuid = TuyaHomeSdk.getDataInstance().getDeviceBean(nvrDevId).getUuid();
            } else {
                uuid = this.mDeviceBean.getUuid();
            }
            return uuid;
        }
        return null;
    }

    private void initBusiness() {
        this.mCameraBusiness = new CameraCloudBusiness();
    }

    private boolean isNvrSubDevice(DeviceBean deviceBean) {
        if (null == deviceBean.getMeshId()) {
            return false;
        }
        DeviceBean jzBean = TuyaHomeSdk.getDataInstance().getDeviceBean(deviceBean.getMeshId());
        if (null == jzBean) {
            return false;
        }
        String category = jzBean.getProductBean().getCategory();
        return category.equals("nvr") || category.equals("dvr");
    }

    public void onDestroy() {
        this.mDeviceBean = null;
        if (null != this.mCameraBusiness) {
            this.mCameraBusiness.onDestroy();
        }
    }

    public void receiveFrameDataForMediaCodec(int avChannel, byte[] buf, int length, int pFrmNo, byte[] pFrmInfoBuf, boolean isIframe, int codecId) {
    }

    public void onReceiveFrameYUVData(int sessionId, ByteBuffer y, ByteBuffer u, ByteBuffer v, int width, int height, int nFrameRate, int nIsKeyFrame, long timestamp, long nProgress, long nDuration, Object camera) {
        this.mHandler.sendMessage(MessageUtil.getMessage((int)2080, (int)0, (Object)timestamp));
    }

    public void onSessionStatusChanged(Object camera, int sessionId, int sessionStatus) {
    }
}

