/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.ipc.cloud.panel.business;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tuya.smart.android.base.ApiParams;
import com.tuya.smart.android.network.Business;
import com.tuya.smart.android.network.TuyaApiParams;
import com.tuya.smart.android.network.http.BusinessResponse;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.exceptions.UndeliverableException;
import io.reactivex.functions.Consumer;
import io.reactivex.plugins.RxJavaPlugins;
import java.io.IOException;
import java.util.ArrayList;

public class CameraCloudBusiness
extends Business {
    public static final String ERROR_QUERY = "100006";
    public static final String ERROR_NO_SERVES = "100001";
    private static final String API_CLOUD_STORAGE_SERVICED = "tuya.customer.user.instance.served.get";
    private static final String API_MEDIA_STORAGE_COUNT_INFO = "tuya.m.ipc.storage.info.day.count";
    private static final String API_MEDIA_SECRET_INFO = "tuya.m.ipc.storage.secret.get";
    private static final String API_GET_MEDIA_PREFIXS = "tuya.m.ipc.storage.prefixs.get";
    private static final String API_GET_STORAGE_TIMELINE = "tuya.m.ipc.storage.timeline.get";
    private static final String API_GET_STORAGE_TIMERANG = "tuya.m.ipc.storage.event.timerange.query";
    private static final String API_GET_STORAGE_AUTHORITY_GET = "tuya.m.ipc.storage.read.authority.get";
    private static final String API_CLOUD_DATA_DELETE = "tuya.m.storage.timerange.delete";
    private static final String API_CLOUD_DATA_DELETE_DAY = "tuya.m.storage.days.delete";

    public void initRxJavaHander() {
        RxJavaPlugins.setErrorHandler((Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                if (e instanceof UndeliverableException) {
                    e = e.getCause();
                }
                if (e instanceof IOException) {
                    return;
                }
                if (e instanceof InterruptedException) {
                    return;
                }
                if (e instanceof NullPointerException || e instanceof IllegalArgumentException) {
                    Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                    return;
                }
                if (e instanceof IllegalStateException) {
                    Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                    return;
                }
            }
        });
    }

    public Observable queryCloudStorageServiced(final String uuid, final String pid) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<JSONObject>(){

            public void subscribe(final ObservableEmitter<JSONObject> e) {
                ApiParams apiParams = new ApiParams(CameraCloudBusiness.API_CLOUD_STORAGE_SERVICED, "1.0");
                apiParams.setSessionRequire(true);
                apiParams.putPostData("clientId", (Object)pid);
                apiParams.putPostData("instanceId", (Object)uuid);
                CameraCloudBusiness.this.asyncRequest((TuyaApiParams)apiParams, JSONObject.class, (Business.ResultListener)new Business.ResultListener<JSONObject>(){

                    public void onFailure(BusinessResponse businessResponse, JSONObject jsonObject, String s) {
                        if (businessResponse.getErrorCode().equals("SERVED_NOT_EXISTED")) {
                            e.onError(new Throwable(CameraCloudBusiness.ERROR_NO_SERVES));
                        } else {
                            e.onError(new Throwable(CameraCloudBusiness.ERROR_QUERY));
                        }
                    }

                    public void onSuccess(BusinessResponse businessResponse, JSONObject jsonObject, String s) {
                        e.onNext((Object)jsonObject);
                        e.onComplete();
                    }
                });
            }
        });
    }

    public Observable queryCloudMediaCount(final String devId, final String timeZone) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<JSONArray>(){

            public void subscribe(final ObservableEmitter<JSONArray> e) {
                ApiParams apiParams = new ApiParams(CameraCloudBusiness.API_MEDIA_STORAGE_COUNT_INFO, "1.0");
                apiParams.putPostData("devId", (Object)devId);
                apiParams.putPostData("timeZone", (Object)timeZone);
                CameraCloudBusiness.this.asyncRequest((TuyaApiParams)apiParams, JSONArray.class, (Business.ResultListener)new Business.ResultListener<JSONArray>(){

                    public void onFailure(BusinessResponse businessResponse, JSONArray jsonArray, String s) {
                        e.onError(new Throwable(CameraCloudBusiness.ERROR_QUERY));
                    }

                    public void onSuccess(BusinessResponse businessResponse, JSONArray jsonArray, String s) {
                        e.onNext((Object)jsonArray);
                        e.onComplete();
                    }
                });
            }
        });
    }

    public Observable getCloudSecret(final String devId) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe(){

            public void subscribe(final ObservableEmitter e) {
                ApiParams apiParams = new ApiParams(CameraCloudBusiness.API_MEDIA_SECRET_INFO, "1.0");
                apiParams.putPostData("devId", (Object)devId);
                CameraCloudBusiness.this.asyncRequest((TuyaApiParams)apiParams, JSONObject.class, (Business.ResultListener)new Business.ResultListener<JSONObject>(){

                    public void onFailure(BusinessResponse businessResponse, JSONObject jsonObject, String s) {
                        e.onError(new Throwable(CameraCloudBusiness.ERROR_QUERY));
                    }

                    public void onSuccess(BusinessResponse businessResponse, JSONObject jsonObject, String s) {
                        e.onNext((Object)jsonObject);
                        e.onComplete();
                    }
                });
            }
        });
    }

    public Observable getMediaPrefixs(final String devId, final String prefixs) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

            public void subscribe(final ObservableEmitter<String> e) {
                ApiParams apiParams = new ApiParams(CameraCloudBusiness.API_GET_MEDIA_PREFIXS, "1.0");
                apiParams.putPostData("devId", (Object)devId);
                apiParams.putPostData("prefixs", (Object)prefixs);
                CameraCloudBusiness.this.asyncRequest((TuyaApiParams)apiParams, JSONObject.class, (Business.ResultListener)new Business.ResultListener<JSONObject>(){

                    public void onFailure(BusinessResponse businessResponse, JSONObject jsonObject, String s) {
                        e.onError(new Throwable(CameraCloudBusiness.ERROR_QUERY));
                    }

                    public void onSuccess(BusinessResponse businessResponse, JSONObject jsonObject, String s) {
                        e.onNext((Object)jsonObject.toJSONString());
                        e.onComplete();
                    }
                });
            }
        });
    }

    public Observable getCloudTimeLine(final String devId, final String timeGT, final String timeLT) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<JSONArray>(){

            public void subscribe(final ObservableEmitter<JSONArray> e) {
                ApiParams apiParams = new ApiParams(CameraCloudBusiness.API_GET_STORAGE_TIMELINE, "1.0");
                apiParams.putPostData("devId", (Object)devId);
                apiParams.putPostData("timeGT", (Object)timeGT);
                apiParams.putPostData("timeLT", (Object)timeLT);
                CameraCloudBusiness.this.asyncRequest((TuyaApiParams)apiParams, JSONArray.class, (Business.ResultListener)new Business.ResultListener<JSONArray>(){

                    public void onFailure(BusinessResponse businessResponse, JSONArray jsonObject, String s) {
                        e.onError(new Throwable(CameraCloudBusiness.ERROR_QUERY));
                    }

                    public void onSuccess(BusinessResponse businessResponse, JSONArray jsonObject, String s) {
                        e.onNext((Object)jsonObject);
                        e.onComplete();
                    }
                });
            }
        });
    }

    public Observable getTimeRange(final String devId, final String timeGT, final String timeLT, final int offset, final int limit) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<JSONObject>(){

            public void subscribe(final ObservableEmitter<JSONObject> e) {
                ApiParams apiParams = new ApiParams(CameraCloudBusiness.API_GET_STORAGE_TIMERANG, "2.0");
                apiParams.putPostData("devId", (Object)devId);
                apiParams.putPostData("timeGT", (Object)timeGT);
                apiParams.putPostData("timeLT", (Object)timeLT);
                apiParams.putPostData("offset", (Object)offset);
                apiParams.putPostData("limit", (Object)limit);
                CameraCloudBusiness.this.asyncRequest((TuyaApiParams)apiParams, JSONObject.class, (Business.ResultListener)new Business.ResultListener<JSONObject>(){

                    public void onFailure(BusinessResponse businessResponse, JSONObject jsonObject, String s) {
                        e.onError(new Throwable(CameraCloudBusiness.ERROR_QUERY));
                    }

                    public void onSuccess(BusinessResponse businessResponse, JSONObject jsonObject, String s) {
                        e.onNext((Object)jsonObject);
                        e.onComplete();
                    }
                });
            }
        });
    }

    public Observable getAuthorityGet(final String devId, final String buckets) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

            public void subscribe(final ObservableEmitter<String> e) {
                ApiParams apiParams = new ApiParams(CameraCloudBusiness.API_GET_STORAGE_AUTHORITY_GET, "2.0");
                apiParams.putPostData("devId", (Object)devId);
                apiParams.putPostData("buckets", (Object)buckets);
                CameraCloudBusiness.this.asyncArrayList((TuyaApiParams)apiParams, String.class, (Business.ResultListener)new Business.ResultListener<ArrayList<String>>(){

                    public void onFailure(BusinessResponse businessResponse, ArrayList<String> objects, String s) {
                        e.onError(new Throwable(CameraCloudBusiness.ERROR_QUERY));
                    }

                    public void onSuccess(BusinessResponse businessResponse, ArrayList<String> objects, String s) {
                        e.onNext((Object)objects.toString());
                        e.onComplete();
                    }
                });
            }
        });
    }

    public Observable deleteCloudData(final String devId, final long timeGT, final long timeLT, final String timeZone) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe(){

            public void subscribe(final ObservableEmitter e) {
                ApiParams apiParams = new ApiParams(CameraCloudBusiness.API_CLOUD_DATA_DELETE, "1.0");
                apiParams.putPostData("devId", (Object)devId);
                apiParams.putPostData("timeGT", (Object)timeGT);
                apiParams.putPostData("timeLT", (Object)timeLT);
                apiParams.putPostData("appTimeZone", (Object)timeZone);
                CameraCloudBusiness.this.asyncRequest((TuyaApiParams)apiParams, JSONObject.class, (Business.ResultListener)new Business.ResultListener<JSONObject>(){

                    public void onFailure(BusinessResponse businessResponse, JSONObject jsonObject, String s) {
                        e.onError(new Throwable(businessResponse.getErrorMsg()));
                    }

                    public void onSuccess(BusinessResponse businessResponse, JSONObject jsonObject, String s) {
                        e.onNext((Object)jsonObject);
                        e.onComplete();
                    }
                });
            }
        });
    }

    public Observable deleteCloudDataByDay(final String devId, final long timeGT, final long timeLT, final String timeZone) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe(){

            public void subscribe(final ObservableEmitter e) {
                ApiParams apiParams = new ApiParams(CameraCloudBusiness.API_CLOUD_DATA_DELETE_DAY, "1.0");
                apiParams.putPostData("devId", (Object)devId);
                apiParams.putPostData("timeGT", (Object)timeGT);
                apiParams.putPostData("timeLT", (Object)timeLT);
                apiParams.putPostData("appTimeZone", (Object)timeZone);
                CameraCloudBusiness.this.asyncRequest((TuyaApiParams)apiParams, JSONObject.class, (Business.ResultListener)new Business.ResultListener<JSONObject>(){

                    public void onFailure(BusinessResponse businessResponse, JSONObject jsonObject, String s) {
                        e.onError(new Throwable(businessResponse.getErrorMsg()));
                    }

                    public void onSuccess(BusinessResponse businessResponse, JSONObject jsonObject, String s) {
                        e.onNext((Object)jsonObject);
                        e.onComplete();
                    }
                });
            }
        });
    }
}

