/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.ipc.cloud.panel.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.tuya.drawee.view.DecryptImageView;
import com.tuya.smart.camera.base.bean.TimeRangeBean;
import com.tuya.smart.camera.utils.DateUtils;
import com.tuya.smart.camera.utils.TimeZoneUtils;
import com.tuya.smart.ipc.cloud.panel.R;
import java.util.ArrayList;
import java.util.List;

public class TimeRangeListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private OnItemClickListener mOnItemClickListener;
    private List<TimeRangeBean> mTimeRangeList;
    private LayoutInflater mInflater;
    private Context mContext;
    private String mEncryptKey;
    private String mDevId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeRangeListAdapter(Context context, String devId, OnItemClickListener l) {
        this.mContext = context;
        this.mTimeRangeList = new ArrayList<TimeRangeBean>();
        this.mInflater = LayoutInflater.from((Context)context);
        this.mDevId = devId;
        TimeRangeListAdapter timeRangeListAdapter = this;
        synchronized (timeRangeListAdapter) {
            this.mOnItemClickListener = l;
        }
    }

    public static void setBtStatus(ImageView mIvOval, TextView tv, TimeRangeBean.STATUS status) {
        switch (status) {
            case SELECT: {
                tv.setSelected(true);
                mIvOval.setSelected(true);
                break;
            }
            case UN_SELECT: {
                tv.setSelected(false);
                mIvOval.setSelected(false);
                break;
            }
        }
    }

    public void updateData(List<TimeRangeBean> dataList, String encryptKey) {
        if (dataList != null) {
            this.mTimeRangeList.clear();
            this.mTimeRangeList.addAll(dataList);
        }
        this.mEncryptKey = encryptKey;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(this.mInflater.inflate(R.layout.camera_newui_cloud_timerange_recycle_item, parent, false));
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        holder.update(this.mTimeRangeList.get(position), position, this.mContext);
    }

    public int getItemCount() {
        return this.mTimeRangeList.size();
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView mIvOval;
        private TextView mTvStartTime;
        private TextView mTvEventModel;
        private DecryptImageView mSnapshot;

        public ViewHolder(View itemView) {
            super(itemView);
            this.mIvOval = (ImageView)itemView.findViewById(R.id.rv_iv_oval);
            this.mTvStartTime = (TextView)itemView.findViewById(R.id.tv_time_range_start_time);
            this.mTvEventModel = (TextView)itemView.findViewById(R.id.tv_time_range_event_model);
            this.mSnapshot = (DecryptImageView)itemView.findViewById(R.id.iv_time_range_snapshot);
        }

        public void update(final TimeRangeBean timeRangeBean, final int position, Context context) {
            try {
                this.mTvStartTime.setText((CharSequence)TimeZoneUtils.timeHMSFormat((long)((long)timeRangeBean.getStartTime() * 1000L), (boolean)DateUtils.is24hoursModel((Context)context), (Context)context, (String)TimeRangeListAdapter.this.mDevId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.mTvEventModel.setText((CharSequence)timeRangeBean.getDescribe());
            if (timeRangeBean.getV() == 2 && !TextUtils.isEmpty((CharSequence)TimeRangeListAdapter.this.mEncryptKey)) {
                this.mSnapshot.setImageURI(timeRangeBean.getSnapshotUrl(), TimeRangeListAdapter.this.mEncryptKey.getBytes());
            } else {
                this.mSnapshot.setImageURI(timeRangeBean.getSnapshotUrl());
            }
            TimeRangeListAdapter.setBtStatus(this.mIvOval, this.mTvEventModel, timeRangeBean.getStatus());
            this.itemView.setTag((Object)timeRangeBean);
            this.itemView.setContentDescription((CharSequence)"tuya_ipc_cloud_list");
            this.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (null != TimeRangeListAdapter.this.mOnItemClickListener) {
                        TimeRangeListAdapter.this.mOnItemClickListener.onClick(timeRangeBean, position);
                    }
                }
            });
        }
    }

    public static interface OnItemClickListener {
        public void onClick(TimeRangeBean var1, int var2);
    }
}

