/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.ipc.cloud.panel.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.tuya.smart.camera.base.bean.CloudDayBean;
import com.tuya.smart.camera.uiview.utils.ThemeUtils;
import com.tuya.smart.ipc.cloud.panel.R;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CloudDayListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private OnItemClickListener mOnItemClickListener;
    private List<CloudDayBean> mCloudDays;
    private LayoutInflater mInflater;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloudDayListAdapter(Context context, OnItemClickListener l) {
        this.mInflater = LayoutInflater.from((Context)context);
        this.mCloudDays = new ArrayList<CloudDayBean>();
        CloudDayListAdapter cloudDayListAdapter = this;
        synchronized (cloudDayListAdapter) {
            this.mOnItemClickListener = l;
        }
    }

    public static void setBtStatus(TextView tv, CloudDayBean.STATUS status) {
        switch (status) {
            case SELECT: {
                tv.setSelected(true);
                tv.setTextSize(17.0f);
                tv.setTextColor(ThemeUtils.getTypedValueByAttribute((Context)tv.getContext(), (int)R.attr.camera_cloud_day_selected_text_color).data);
                tv.getPaint().setFakeBoldText(true);
                break;
            }
            case UN_SELECT: {
                tv.setSelected(false);
                tv.setTextSize(14.0f);
                tv.setTextColor(ThemeUtils.getTypedValueByAttribute((Context)tv.getContext(), (int)R.attr.camera_cloud_day_normal_text_color).data);
                tv.getPaint().setFakeBoldText(false);
                break;
            }
        }
    }

    public void updateData(List<CloudDayBean> dataList) {
        if (dataList != null) {
            this.mCloudDays.clear();
            this.mCloudDays.addAll(dataList);
        }
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(this.mInflater.inflate(R.layout.camera_newui_cloud_days_recycle_item, parent, false));
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        holder.update(this.mCloudDays.get(position));
    }

    public int getItemCount() {
        return this.mCloudDays != null ? this.mCloudDays.size() : 0;
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView mTv;

        ViewHolder(View itemView) {
            super(itemView);
            this.mTv = (TextView)itemView.findViewById(R.id.tv_day);
            this.mTv.setContentDescription((CharSequence)"tuya_ipc_cloud_date");
        }

        public void update(final CloudDayBean day) {
            this.mTv.setText((CharSequence)day.getMonthAndDay());
            CloudDayListAdapter.setBtStatus(this.mTv, day.getStatus());
            this.itemView.setTag((Object)day);
            this.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (CloudDayListAdapter.this.mOnItemClickListener != null) {
                        Iterator iterator = CloudDayListAdapter.this.mCloudDays.iterator();
                        while (iterator.hasNext()) {
                            CloudDayBean selectDay;
                            selectDay.setStatus(day == (selectDay = (CloudDayBean)iterator.next()) ? CloudDayBean.STATUS.SELECT : CloudDayBean.STATUS.UN_SELECT);
                        }
                        CloudDayListAdapter.this.mOnItemClickListener.onClick(day);
                    }
                }
            });
        }
    }

    public static interface OnItemClickListener {
        public void onClick(CloudDayBean var1);
    }
}

