/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.ipc.cloud.panel.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.tuya.smart.android.common.utils.NetworkUtil;
import com.tuya.smart.api.MicroContext;
import com.tuya.smart.camera.base.R;
import com.tuya.smart.camera.base.activity.BaseCameraActivity;
import com.tuya.smart.camera.base.bean.CloudDayBean;
import com.tuya.smart.camera.base.bean.TimeRangeBean;
import com.tuya.smart.camera.base.callback.RecordCallback;
import com.tuya.smart.camera.base.utils.CameraUIThemeUtils;
import com.tuya.smart.camera.base.utils.UrlRouterUtils;
import com.tuya.smart.camera.middleware.widget.TuyaCameraView;
import com.tuya.smart.camera.uiview.R;
import com.tuya.smart.camera.uiview.bean.TimePieceBean;
import com.tuya.smart.camera.uiview.loading.LoadingImageView;
import com.tuya.smart.camera.uiview.timerrulerview.CloudTimebarView;
import com.tuya.smart.camera.uiview.timerrulerview.TuyaTimelineUnitMode;
import com.tuya.smart.camera.uiview.utils.DensityUtil;
import com.tuya.smart.camera.uiview.utils.ThemeUtils;
import com.tuya.smart.camera.uiview.view.CameraCloudVideoController;
import com.tuya.smart.camera.uiview.view.CameraCloudVideoOpera;
import com.tuya.smart.camera.uiview.view.CameraFullScreenOperateLayout;
import com.tuya.smart.camera.uiview.view.CameraFullToolBar;
import com.tuya.smart.camera.uiview.view.ChronometerLayout;
import com.tuya.smart.camera.uiview.view.CloudProgressView;
import com.tuya.smart.camera.uiview.view.FlickerImageView;
import com.tuya.smart.camera.uiview.view.MobileNetworkTipLayout;
import com.tuya.smart.camera.uiview.view.PhotoLayout;
import com.tuya.smart.camera.uiview.view.ToastUtil;
import com.tuya.smart.camera.utils.RXClickUtils;
import com.tuya.smart.camera.utils.TimeZoneUtils;
import com.tuya.smart.ipc.cloud.panel.R;
import com.tuya.smart.ipc.cloud.panel.adapter.CloudDayListAdapter;
import com.tuya.smart.ipc.cloud.panel.adapter.TimeRangeListAdapter;
import com.tuya.smart.ipc.cloud.panel.presenter.CameraCloudPresenter;
import com.tuya.smart.ipc.cloud.panel.view.ICameraCloudView;
import com.tuya.smart.utils.WidgetUtils;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CameraCloudActivity
extends BaseCameraActivity
implements ICameraCloudView,
TuyaCameraView.CreateVideoViewCallback<Object>,
RXClickUtils.IRxCallback {
    private TextView mTitleView;
    private LoadingImageView mLoadingImageView;
    private RelativeLayout mVideoLayout;
    private ChronometerLayout mTimer;
    private TuyaCameraView mVideoView;
    private TextView cloudOverWarning;
    private RelativeLayout cameraVideoOperaRl;
    private ImageView mCloudMuteView;
    private ImageView mCloudFullScreenView;
    private FlickerImageView mIvCameraPhoto;
    private PhotoLayout mCameraPhotoLayout;
    private MobileNetworkTipLayout mobileNetworkTipLayout;
    private RecyclerView mDayListView;
    private CloudDayListAdapter cloudDayListAdapter;
    private FrameLayout mTimeBarViewFl;
    private CloudTimebarView mTimerBarView;
    private RecyclerView mTimeRangeListView;
    private TimeRangeListAdapter mTimeRangeAdapter;
    private TextView mNoMotionDetectionTv;
    private CameraCloudVideoController mCameraVideoController;
    private LinearLayout emptyContentLl;
    private TextView emptyTxt;
    private Button emptyBtn;
    private CameraFullToolBar cameraFullToolBar;
    private CameraFullScreenOperateLayout mCameraFullScreenOperateLayout;
    private ImageView mFullPlayBtn;
    private CameraCloudVideoOpera mCameraCloudVideoOpera;
    private CameraCloudPresenter mPresenter;
    private View.OnClickListener onBackClickListener;
    private boolean isDestroyed = false;
    private int timeRangeBeanStartTime;
    private long mSelectStartTime;
    private long mSelectEndTime;
    private CloudProgressView mProgressView;
    private CloudDayListAdapter.OnItemClickListener mOnItemClickListener = new CloudDayListAdapter.OnItemClickListener(){

        @Override
        public void onClick(final CloudDayBean dayBean) {
            if (null != CameraCloudActivity.this.mTimerBarView && CameraCloudActivity.this.mTimerBarView.isSelectTimeArea()) {
                return;
            }
            CameraCloudActivity.this.mPresenter.checkRecordingAction(new RecordCallback(){

                public void onStop() {
                    CameraCloudActivity.this.mPresenter.selectCloudDay(dayBean);
                }

                public void onContinue() {
                }
            });
        }
    };
    private TimeRangeListAdapter.OnItemClickListener mOnTimeRangeClickListener = new TimeRangeListAdapter.OnItemClickListener(){

        @Override
        public void onClick(final TimeRangeBean timeRangeBean, final int position) {
            if (null != CameraCloudActivity.this.mTimerBarView && CameraCloudActivity.this.mTimerBarView.isSelectTimeArea()) {
                return;
            }
            CameraCloudActivity.this.mPresenter.checkRecordingAction(new RecordCallback(){

                public void onStop() {
                    CameraCloudActivity.this.mPresenter.playByTimeRangeData(timeRangeBean);
                    List<TimeRangeBean> timeRangeList = CameraCloudActivity.this.mPresenter.getTimeRangeList();
                    for (int i = 0; i < timeRangeList.size(); ++i) {
                        if (i == position) {
                            timeRangeList.get(i).setStatus(TimeRangeBean.STATUS.SELECT);
                            continue;
                        }
                        timeRangeList.get(i).setStatus(TimeRangeBean.STATUS.UN_SELECT);
                    }
                    CameraCloudActivity.this.mTimeRangeAdapter.updateData(timeRangeList, CameraCloudActivity.this.mPresenter.getEncryptKey());
                    CameraCloudActivity.this.mTimeRangeAdapter.notifyDataSetChanged();
                }

                public void onContinue() {
                }
            });
        }
    };
    private CloudTimebarView.OnBarMoveListener mOnRulerMoveListener = new CloudTimebarView.OnBarMoveListener(){
        private Disposable restoreBtnState;

        public void onBarMove(long screenLeftTime, long screenRightTime, long currentTime) {
            if (this.restoreBtnState != null && !this.restoreBtnState.isDisposed()) {
                this.restoreBtnState.dispose();
            }
            if (CameraCloudActivity.this.mPresenter.isRecording()) {
                CameraCloudActivity.this.otherControllerBtnEableState(false);
            } else {
                CameraCloudActivity.this.allControllerBtnEnableState(false);
            }
        }

        @SuppressLint(value={"CheckResult"})
        public void onBarMoveFinish(final long startTime, final long endTime, final long currentTime) {
            if (-1L == startTime && -1L == endTime && -1L == currentTime) {
                this.restoreBtnState = Observable.timer((long)1L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                    public void accept(Long aLong) {
                        if (CameraCloudActivity.this.mPresenter.isRecording()) {
                            CameraCloudActivity.this.otherControllerBtnEableState(false);
                        } else if (CameraCloudActivity.this.mPresenter.getPlayState() == 4) {
                            CameraCloudActivity.this.allControllerBtnEnableState(true);
                            CameraCloudActivity.this.videoOnPause();
                        } else if (CameraCloudActivity.this.mPresenter.getPlayState() == 3) {
                            CameraCloudActivity.this.allControllerBtnEnableState(true);
                        } else {
                            CameraCloudActivity.this.allControllerBtnEnableState(false);
                        }
                        CameraCloudActivity.this.mTimerBarView.setCanQueryData();
                    }
                });
                return;
            }
            final boolean recording = CameraCloudActivity.this.mPresenter.isRecording();
            CameraCloudActivity.this.mPresenter.checkRecordingAction(new RecordCallback(){

                public void onStop() {
                    if (recording) {
                        CameraCloudActivity.this.otherControllerBtnEableState(true);
                    } else {
                        CameraCloudActivity.this.allControllerBtnEnableState(true);
                    }
                    TimePieceBean timePieceBean = new TimePieceBean();
                    timePieceBean.setStartTime((int)startTime);
                    timePieceBean.setPlayTime((int)currentTime);
                    timePieceBean.setEndTime((int)endTime);
                    CameraCloudActivity.this.mPresenter.playByTimePieceData(timePieceBean);
                    CameraCloudActivity.this.mTimerBarView.setCanQueryData();
                }

                public void onContinue() {
                    CameraCloudActivity.this.mTimerBarView.setCanQueryData();
                }
            });
        }

        public void onBarActionDown() {
        }
    };
    private boolean isShowNetTip;
    private boolean isAnimation = false;
    private boolean autoRotation = true;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.camera_activity_newui_camera_cloud);
        this.initPresenter();
        this.initToolbar();
        this.initView();
    }

    protected void initToolbar() {
        super.initToolbar();
        this.mTitleView = (TextView)this.findViewById(R.id.tb_title_view);
        this.mTitleView.setText((CharSequence)this.getPageName());
        this.onBackClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                CameraCloudActivity.this.mPresenter.onBackPressed();
                CameraCloudActivity.this.onBackPressed();
            }
        };
        this.setDisplayHomeAsUpEnabled(R.drawable.tysmart_back_white, this.onBackClickListener);
    }

    private void initPresenter() {
        this.mPresenter = new CameraCloudPresenter((Context)this, this.mDevId, this);
        this.timeRangeBeanStartTime = this.getIntent().getIntExtra("extra_position", -1);
        if (this.timeRangeBeanStartTime == 0) {
            this.timeRangeBeanStartTime = -1;
        }
        this.mPresenter.setTimeRangeBeanStartTime(this.timeRangeBeanStartTime);
    }

    private void initView() {
        this.cloudOverWarning = (TextView)this.findViewById(R.id.camera_cloud_over_warning);
        RXClickUtils.clickView((View)this.cloudOverWarning, (RXClickUtils.IRxCallback)this);
        this.mNoMotionDetectionTv = (TextView)this.findViewById(R.id.tv_camera_cloud_no_time_range);
        this.cameraVideoOperaRl = (RelativeLayout)this.findViewById(R.id.camera_cloud_opera_rl);
        this.mCloudMuteView = (ImageView)this.findViewById(R.id.iv_camera_cloud_mute);
        RXClickUtils.clickView((View)this.mCloudMuteView, (RXClickUtils.IRxCallback)this);
        this.mCloudFullScreenView = (ImageView)this.findViewById(R.id.iv_cloud_full_screen);
        RXClickUtils.clickView((View)this.mCloudFullScreenView, (RXClickUtils.IRxCallback)this);
        this.mDayListView = (RecyclerView)this.findViewById(R.id.rv_day_list);
        this.initDayRecyclerView();
        this.mTimeRangeListView = (RecyclerView)this.findViewById(R.id.rv_cloud_record_list);
        this.initTimeRangeRecyclerView();
        this.mTimeBarViewFl = (FrameLayout)this.findViewById(R.id.camera_cloud_time_fl);
        this.mTimerBarView = (CloudTimebarView)this.findViewById(R.id.camera_cloud_time_bar);
        this.initTimeBarView();
        this.mIvCameraPhoto = (FlickerImageView)this.findViewById(R.id.camera_iv_photo);
        this.mCameraPhotoLayout = (PhotoLayout)this.findViewById(R.id.camera_photo_layout);
        this.mobileNetworkTipLayout = (MobileNetworkTipLayout)this.findViewById(R.id.camera_network_layout);
        this.mLoadingImageView = (LoadingImageView)this.findViewById(R.id.camera_cloud_loading_img);
        this.mVideoLayout = (RelativeLayout)this.findViewById(R.id.cloud_video_layout);
        this.mTimer = (ChronometerLayout)this.findViewById(R.id.camera_record_ly);
        this.mVideoView = (TuyaCameraView)this.findViewById(R.id.camera_cloud_video_view);
        this.mVideoView.setCameraViewCallback((TuyaCameraView.CreateVideoViewCallback)this);
        this.mVideoView.createVideoView(this.mPresenter.getSdkProvider());
        this.mCameraVideoController = (CameraCloudVideoController)this.findViewById(R.id.camera_cloud_controller);
        this.mCameraCloudVideoOpera = (CameraCloudVideoOpera)this.findViewById(R.id.camera_cloud_opera);
        this.initController();
        this.cameraFullToolBar = (CameraFullToolBar)this.findViewById(R.id.camera_full_screen_tool_bar);
        this.initCameraFullToolBar();
        this.mCameraFullScreenOperateLayout = (CameraFullScreenOperateLayout)this.findViewById(R.id.camera_full_screen_ol);
        this.initCameraFullOperate();
        this.mFullPlayBtn = (ImageView)this.findViewById(R.id.iv_camera_full_play);
        RXClickUtils.clickView((View)this.mFullPlayBtn, (RXClickUtils.IRxCallback)this);
        this.initEmptyView();
        this.requestVideoLayout(true);
    }

    private void initCameraFullToolBar() {
        RXClickUtils.clickView((View)this.cameraFullToolBar.getChildView(R.id.camera_toolbar_back), (RXClickUtils.IRxCallback)this);
        this.cameraFullToolBar.getChildView(R.id.camera_full_mute).setVisibility(8);
        this.cameraFullToolBar.getChildView(R.id.camera_full_clarity).setVisibility(8);
    }

    private void initCameraFullOperate() {
        RXClickUtils.clickView((View)this.mCameraFullScreenOperateLayout.getChildView(R.id.camera_full_snapshot_btn), (RXClickUtils.IRxCallback)this);
        RXClickUtils.clickView((View)this.mCameraFullScreenOperateLayout.getChildView(R.id.camera_full_record_btn), (RXClickUtils.IRxCallback)this);
        ImageView mImageView = (ImageView)this.mCameraFullScreenOperateLayout.getChildView(R.id.camera_full_talk_btn);
        mImageView.setBackgroundResource(ThemeUtils.getTypedValueByAttribute((Context)this, (int)R.attr.camera_operate_bg).resourceId);
        mImageView.setImageResource(ThemeUtils.getTypedValueByAttribute((Context)this, (int)R.attr.camera_mute).resourceId);
        RXClickUtils.clickView((View)mImageView, (RXClickUtils.IRxCallback)this);
    }

    private void initTimeBarView() {
        this.mTimerBarView.initData();
        this.mTimerBarView.setUnitMode(TuyaTimelineUnitMode.Mode_600);
        this.mTimerBarView.setTimeZone(TimeZoneUtils.getTimeZone((Context)this, (String)this.mDevId));
        this.mTimerBarView.setOnBarMoveListener(this.mOnRulerMoveListener);
        this.mTimerBarView.setOnSelectedTimeListener(new CloudTimebarView.OnSelectedTimeListener(){

            public void onDragging(long selectStartTime, long selectEndTime) {
                CameraCloudActivity.this.mSelectStartTime = selectStartTime;
                CameraCloudActivity.this.mSelectEndTime = selectEndTime;
            }
        });
    }

    private void initDayRecyclerView() {
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager((Context)this);
        linearLayoutManager.setOrientation(0);
        this.mDayListView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.mDayListView.setContentDescription((CharSequence)"tuya_ipc_cloud_date");
        this.cloudDayListAdapter = new CloudDayListAdapter((Context)this, this.mOnItemClickListener);
        this.mDayListView.setAdapter((RecyclerView.Adapter)this.cloudDayListAdapter);
    }

    private void initTimeRangeRecyclerView() {
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager((Context)this);
        linearLayoutManager.setOrientation(1);
        this.mTimeRangeListView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.mTimeRangeAdapter = new TimeRangeListAdapter((Context)this, this.mDevId, this.mOnTimeRangeClickListener);
        this.mTimeRangeListView.setAdapter((RecyclerView.Adapter)this.mTimeRangeAdapter);
    }

    private void initEmptyView() {
        this.emptyContentLl = (LinearLayout)this.findViewById(R.id.empty_content_ll);
        this.emptyTxt = (TextView)this.findViewById(R.id.empty_content);
        this.emptyBtn = (Button)this.findViewById(R.id.storage_opera_btn);
        RXClickUtils.clickView((View)this.emptyBtn, (RXClickUtils.IRxCallback)this);
    }

    private void initController() {
        RXClickUtils.clickView((View)this.mCameraVideoController.getChildView(R.id.iv_cloud_play), (RXClickUtils.IRxCallback)this);
        RXClickUtils.clickView((View)this.mCameraVideoController.getChildView(R.id.iv_cloud_snapshot), (RXClickUtils.IRxCallback)this);
        RXClickUtils.clickView((View)this.mCameraVideoController.getChildView(R.id.iv_cloud_record), (RXClickUtils.IRxCallback)this);
        this.mCameraVideoController.getChildView(R.id.iv_cloud_snapshot).setContentDescription((CharSequence)"tuya_ipc_cloud_snap");
        this.mCameraVideoController.getChildView(R.id.iv_cloud_record).setContentDescription((CharSequence)"tuya_ipc_cloud_record");
        this.mCameraVideoController.getChildView(R.id.iv_cloud_play).setContentDescription((CharSequence)"tuya_ipc_cloud_play");
        RXClickUtils.clickView((View)this.mCameraVideoController.getChildView(R.id.iv_cloud_delete), (RXClickUtils.IRxCallback)this);
        RXClickUtils.clickView((View)this.mCameraVideoController.getChildView(R.id.iv_cloud_download), (RXClickUtils.IRxCallback)this);
        this.mCameraVideoController.showDeleteAndDownload();
        RXClickUtils.clickView((View)this.mCameraCloudVideoOpera.getChildView(R.id.ll_cloud_delete_today), (RXClickUtils.IRxCallback)this);
        RXClickUtils.clickView((View)this.mCameraCloudVideoOpera.getChildView(R.id.ll_cloud_download), (RXClickUtils.IRxCallback)this);
        RXClickUtils.clickView((View)this.mCameraCloudVideoOpera.getChildView(R.id.ll_cloud_delete_select), (RXClickUtils.IRxCallback)this);
    }

    private void requestVideoLayout(boolean isPortrait) {
        if (null == this.mVideoLayout) {
            return;
        }
        if (isPortrait) {
            int screenWidth = WidgetUtils.getScreenWidth((Activity)this);
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mVideoLayout.getLayoutParams();
            layoutParams.width = screenWidth;
            layoutParams.height = screenWidth * 9 / 16 + DensityUtil.dip2px((float)88.0f);
            layoutParams.topMargin = 0;
            this.mVideoLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mIvCameraPhoto.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mLoadingImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        } else {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
            layoutParams.topMargin = 0;
            this.mVideoLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mLoadingImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mIvCameraPhoto.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        this.mVideoLayout.requestLayout();
    }

    @Override
    public void showVideoLoading(int state, int stringId) {
        if (state == 3) {
            this.mLoadingImageView.setErrorState(this.getString(stringId), this.getString(R.string.ipc_panel_monitor_retry));
            this.mLoadingImageView.setBackgroundColor(this.getResources().getColor(R.color.black));
            RXClickUtils.clickView((View)this.mLoadingImageView.getChildView(R.id.tv_error), (RXClickUtils.IRxCallback)this);
        } else {
            this.mLoadingImageView.setState(state, this.getString(stringId));
            this.mLoadingImageView.setBackgroundColor(state == 4 ? this.getResources().getColor(R.color.black) : this.getResources().getColor(R.color.transparent));
        }
    }

    @Override
    public void showNoCloudDataView(int status) {
        switch (status) {
            case 0: 
            case 10002: {
                this.emptyContentLl.setVisibility(0);
                this.emptyTxt.setText(R.string.ipc_cloudstorage_noDataTips);
                this.emptyBtn.setVisibility(8);
                break;
            }
            case 10001: {
                this.emptyContentLl.setVisibility(0);
                this.emptyTxt.setText(R.string.ipc_cloudstorage_status_off);
                this.emptyBtn.setText(R.string.ipc_cloud_subscribe_now);
                this.emptyBtn.setVisibility(0);
                break;
            }
            case 10005: {
                this.emptyContentLl.setVisibility(0);
                this.emptyTxt.setText(R.string.ipc_live_page_cstorage_expired);
                this.emptyBtn.setText(R.string.ipc_cstorage_button_renew);
                this.emptyBtn.setVisibility(0);
                break;
            }
            case 10004: {
                this.emptyContentLl.setVisibility(8);
                this.cloudOverWarning.setVisibility(0);
                this.mPresenter.dismissDelayedExpiredCloudTip();
                break;
            }
            case 10006: {
                this.emptyContentLl.setVisibility(8);
                ToastUtil.showToast((Context)this, (int)R.string.network_error);
                break;
            }
            default: {
                this.emptyContentLl.setVisibility(8);
            }
        }
        if (this.emptyContentLl.getVisibility() == 0 && CameraUIThemeUtils.getCurrentThemeResId() == R.style.oldCameraTheme) {
            this.setDisplayHomeAsUpEnabled(R.drawable.tysmart_back, this.onBackClickListener);
            if (this.mToolBar != null) {
                this.mToolBar.setBackgroundColor(-1);
            }
            this.mTitleView.setTextColor(-16777216);
        } else {
            this.setDisplayHomeAsUpEnabled(R.drawable.tysmart_back_white, this.onBackClickListener);
            if (this.mToolBar != null) {
                this.mToolBar.setBackgroundColor(0);
            }
            this.mTitleView.setTextColor(-1);
        }
    }

    @Override
    public void updateDayListView() {
        this.cloudDayListAdapter.updateData(this.mPresenter.getCloudDays());
        this.cloudDayListAdapter.notifyDataSetChanged();
    }

    @Override
    public void setSelectDayView(int position) {
        if (null != this.mDayListView) {
            this.mDayListView.scrollToPosition(position);
        }
    }

    @Override
    public void initCloudTimerBar(CloudDayBean dayBean) {
        if (null != this.mTimerBarView) {
            this.mTimerBarView.setCurrentTimeConfig(dayBean.getCurrentStartDayTime() * 1000L);
        }
    }

    @Override
    public void updateTimeRangeListView(List<TimeRangeBean> timeRangeBeans, String mEncryptKey) {
        if (null == timeRangeBeans || timeRangeBeans.size() == 0) {
            this.showTimeRangNull();
            return;
        }
        this.mNoMotionDetectionTv.setVisibility(8);
        this.mTimeRangeListView.setVisibility(0);
        int position = 0;
        for (int i = 0; i < timeRangeBeans.size(); ++i) {
            if (timeRangeBeans.get(i).getStartTime() == this.timeRangeBeanStartTime) {
                timeRangeBeans.get(i).setStatus(TimeRangeBean.STATUS.SELECT);
                position = i;
                continue;
            }
            timeRangeBeans.get(i).setStatus(TimeRangeBean.STATUS.UN_SELECT);
        }
        this.mTimeRangeAdapter.updateData(timeRangeBeans, mEncryptKey);
        this.mTimeRangeAdapter.notifyDataSetChanged();
        this.mTimeRangeListView.scrollToPosition(position);
    }

    @Override
    public void showTimeRangNull() {
        this.mNoMotionDetectionTv.setVisibility(0);
        this.mNoMotionDetectionTv.setText(R.string.ipc_motion_detected_no_data);
        this.mTimeRangeListView.setVisibility(8);
    }

    @Override
    public void clearTimeViewPieceData() {
        this.mTimerBarView.setQueryNewVideoData(false);
    }

    @Override
    public void screenViewConfigurationChanged(boolean isPortrait) {
        if (isPortrait) {
            this.portraitScreen();
        } else {
            this.fullScreen();
        }
        this.mCameraPhotoLayout.setVisibility(8);
        this.mIvCameraPhoto.setVisibility(8);
    }

    private void fullScreen() {
        ((ViewGroup)this.findViewById(0x1020002)).getChildAt(0).setFitsSystemWindows(false);
        this.getWindow().addFlags(1024);
        this.findViewById(R.id.action_bar_layout).setVisibility(8);
        this.requestVideoLayout(false);
        this.cameraVideoOperaRl.setVisibility(8);
        this.mDayListView.setVisibility(8);
        this.mTimeRangeListView.setVisibility(8);
        this.mCameraVideoController.setVisibility(8);
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mTimeBarViewFl.getLayoutParams();
        layoutParams.addRule(12);
        layoutParams.addRule(3, 0);
        layoutParams.height = DensityUtil.dip2px((float)46.0f);
        this.mTimeBarViewFl.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mPresenter.showFullScreen();
    }

    public void portraitScreen() {
        this.getWindow().clearFlags(1024);
        this.findViewById(R.id.action_bar_layout).setVisibility(0);
        this.requestVideoLayout(true);
        this.cameraVideoOperaRl.setVisibility(0);
        this.mDayListView.setVisibility(0);
        this.mTimeRangeListView.setVisibility(0);
        this.mCameraVideoController.setVisibility(0);
        this.cameraFullToolBar.setVisibility(8);
        this.mCameraFullScreenOperateLayout.setVisibility(8);
        this.mFullPlayBtn.setVisibility(8);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, DensityUtil.dip2px((float)70.0f));
        layoutParams.addRule(12, 0);
        layoutParams.addRule(3, R.id.rv_day_list);
        this.mTimeBarViewFl.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    public boolean isScreenOperatorVisible() {
        return this.mCameraFullScreenOperateLayout.getVisibility() == 0;
    }

    @Override
    public void screenToolBarShow(boolean isShow) {
        if (isShow) {
            this.playAni((View)this.cameraFullToolBar, R.anim.camera_push_down_in, 0);
            this.playAni((View)this.mFullPlayBtn, R.anim.camera_push_left_in, 0);
            this.playAni((View)this.mCameraFullScreenOperateLayout, R.anim.camera_newui_push_up_in, 0);
            this.playAni((View)this.mTimerBarView, R.anim.camera_c_push_up_in, 0);
        } else {
            this.playAni((View)this.cameraFullToolBar, R.anim.camera_push_up_out, 8);
            this.playAni((View)this.mFullPlayBtn, R.anim.camera_push_left_out, 8);
            this.playAni((View)this.mCameraFullScreenOperateLayout, R.anim.camera_newui_push_down_out, 8);
            this.playAni((View)this.mTimerBarView, R.anim.camera_push_down_out, 8);
        }
    }

    @Override
    public void dismissPhoto() {
        this.mIvCameraPhoto.setVisibility(8);
    }

    @Override
    public void startSnapshot() {
        if (!this.mPresenter.isPortrait()) {
            this.mPresenter.dismissPhotoHandle();
            int screenWidth = WidgetUtils.getScreenWidth((Activity)this);
            int screenHeight = WidgetUtils.getScreenHeight((Activity)this);
            this.mIvCameraPhoto.setFlickerAnimation((int)(0.33f * (float)screenWidth - 75.0f), (int)(0.33f * (float)screenHeight));
        }
    }

    @Override
    public void startVideoSnapshot() {
        if (!this.mPresenter.isPortrait()) {
            this.mPresenter.dismissPhotoHandle();
            int screenWidth = WidgetUtils.getScreenWidth((Activity)this);
            int screenHeight = WidgetUtils.getScreenHeight((Activity)this);
            this.mIvCameraPhoto.setFlickerAnimation((int)(0.33f * (float)screenWidth - 75.0f), -((int)(0.33f * (float)screenHeight)));
        }
    }

    @Override
    public void updateSelectDayView(CloudDayBean dayBean) {
        this.initCloudTimerBar(dayBean);
        this.mTimeRangeListView.setVisibility(8);
    }

    private void playAni(final View view, int aniResId, final int visibility) {
        Animation showDownAni = AnimationUtils.loadAnimation((Context)this, (int)aniResId);
        showDownAni.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                CameraCloudActivity.this.isAnimation = true;
            }

            public void onAnimationEnd(Animation animation) {
                if (view.getId() == R.id.camera_cloud_time_bar && CameraCloudActivity.this.mPresenter.isPortrait()) {
                    view.setVisibility(0);
                } else {
                    view.setVisibility(visibility);
                }
                CameraCloudActivity.this.isAnimation = false;
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        if (!this.isAnimation && view != null) {
            view.startAnimation(showDownAni);
        }
    }

    @Override
    public void showProgress(String str) {
        if (null == this.mProgressView) {
            this.mProgressView = new CloudProgressView((Context)this);
        }
        this.mProgressView.isShowCancel(false);
        this.mProgressView.setProgressWithAnimation(100, str);
        this.mProgressView.showDialog();
    }

    @Override
    public void dismissProgress() {
        if (null != this.mProgressView) {
            this.mProgressView.onDestroy();
            this.mProgressView = null;
        }
    }

    @Override
    public void showTimeBarSelectView(boolean select) {
        this.showTimeBarSelectView(select, true);
    }

    @Override
    public void showTimeBarSelectView(boolean select, boolean resumeVideo) {
        if (select) {
            this.mPresenter.pauseVideo();
        } else {
            this.mCameraCloudVideoOpera.setVisibility(8);
            this.mSelectStartTime = 0L;
            this.mSelectEndTime = 0L;
            this.mTimerBarView.showSelectTimeArea(false);
            if (resumeVideo) {
                this.mPresenter.resumeVideo();
            }
        }
        this.mCloudFullScreenView.setEnabled(!select);
        this.mCloudFullScreenView.setAlpha(!select ? 1.0f : 0.5f);
    }

    @Override
    public void showDownloadStart() {
        if (null == this.mProgressView) {
            this.mProgressView = new CloudProgressView((Context)this);
        }
        this.mProgressView.isShowCancel(true);
        this.mProgressView.setOnCancelListener(new CloudProgressView.OnCancelListener(){

            public void onCancel() {
                CameraCloudActivity.this.mPresenter.cancelDownload();
                CameraCloudActivity.this.mProgressView.onDestroy();
            }
        });
        this.mProgressView.showDialog();
    }

    @Override
    public void showDownloadProgress(int progress) {
        if (null != this.mProgressView) {
            String progressTxt;
            try {
                progressTxt = progress < 100 ? String.format(this.getString(R.string.ipc_cloud_download_precent), progress) : this.getString(R.string.ipc_cloud_download_complete);
            }
            catch (Exception e) {
                progressTxt = progress + "%";
            }
            this.mProgressView.setProgressWithAnimation(progress, progressTxt);
        }
    }

    @Override
    public void errorCameraCloudLiveUI(int stringId) {
        this.showVideoLoading(4, stringId);
        ImageView imageView = (ImageView)this.mCameraVideoController.getChildView(R.id.iv_cloud_play);
        imageView.setImageResource(ThemeUtils.getTypedValueByAttribute((Context)this, (int)R.attr.camera_new_pause).resourceId);
        this.allControllerBtnEnableState(false);
    }

    @Override
    public void videoOnPause() {
        ImageView imageView = (ImageView)this.mCameraVideoController.getChildView(R.id.iv_cloud_play);
        imageView.setContentDescription((CharSequence)"tuya_ipc_cloud_pause");
        imageView.setImageResource(ThemeUtils.getTypedValueByAttribute((Context)this, (int)R.attr.camera_new_pause).resourceId);
        this.mCloudMuteView.setEnabled(false);
        this.mCloudMuteView.setAlpha(0.5f);
        this.mCameraVideoController.getChildView(R.id.iv_cloud_snapshot).setEnabled(false);
        this.mCameraVideoController.getChildView(R.id.iv_cloud_record).setEnabled(false);
        this.mCameraVideoController.getChildView(R.id.iv_cloud_snapshot).setAlpha(0.5f);
        this.mCameraVideoController.getChildView(R.id.iv_cloud_record).setAlpha(0.5f);
        this.mFullPlayBtn.setImageResource(R.drawable.camera_full_screen_new_pause);
        this.mCameraFullScreenOperateLayout.allControllerEnableByPlayState(false);
    }

    @Override
    public void videoOnResume() {
        ImageView imageView = (ImageView)this.mCameraVideoController.getChildView(R.id.iv_cloud_play);
        imageView.setContentDescription((CharSequence)"tuya_ipc_cloud_play");
        imageView.setImageResource(ThemeUtils.getTypedValueByAttribute((Context)this, (int)R.attr.camera_new_play).resourceId);
        this.mCloudMuteView.setEnabled(true);
        this.mCloudMuteView.setAlpha(1.0f);
        this.mCameraVideoController.getChildView(R.id.iv_cloud_snapshot).setEnabled(true);
        this.mCameraVideoController.getChildView(R.id.iv_cloud_record).setEnabled(true);
        this.mCameraVideoController.getChildView(R.id.iv_cloud_snapshot).setAlpha(1.0f);
        this.mCameraVideoController.getChildView(R.id.iv_cloud_record).setAlpha(1.0f);
        this.mTimerBarView.setQueryNewVideoData(false);
        this.mFullPlayBtn.setImageResource(R.drawable.camera_full_screen_new_play);
        this.mCameraFullScreenOperateLayout.allControllerEnableByPlayState(true);
        if (!this.isShowNetTip && "gprs".equals(NetworkUtil.getNetConnType((Context)MicroContext.getApplication()))) {
            this.mobileNetworkTipLayout.show();
            this.isShowNetTip = true;
        }
    }

    @Override
    public void disMissCloudTip() {
        this.cloudOverWarning.setVisibility(8);
    }

    protected void onResume() {
        super.onResume();
        this.mPresenter.generateMonitor(this.mVideoView.createdView());
        this.mPresenter.onResume();
    }

    protected void onPause() {
        super.onPause();
        this.mPresenter.onPause();
        if (this.isFinishing()) {
            this.destroy();
        } else {
            this.mPresenter.pauseVideo();
        }
    }

    protected void onDestroy() {
        this.destroy();
        super.onDestroy();
    }

    private void destroy() {
        if (this.isDestroyed) {
            return;
        }
        if (this.mPresenter != null) {
            this.mPresenter.onDestroy();
        }
        this.isDestroyed = true;
    }

    @Override
    public void muteView(int mute) {
        ImageView mImageView = (ImageView)this.mCameraFullScreenOperateLayout.getChildView(R.id.camera_full_talk_btn);
        if (mute == 0) {
            this.mCloudMuteView.setImageResource(R.drawable.camera_unmute);
            this.mCloudMuteView.setContentDescription((CharSequence)"tuya_ipc_cloud_speaker_on");
            mImageView.setImageResource(ThemeUtils.getTypedValueByAttribute((Context)this, (int)R.attr.camera_unmute).resourceId);
        } else {
            this.mCloudMuteView.setImageResource(R.drawable.camera_mute);
            this.mCloudMuteView.setContentDescription((CharSequence)"tuya_ipc_cloud_speaker_off");
            mImageView.setImageResource(ThemeUtils.getTypedValueByAttribute((Context)this, (int)R.attr.camera_mute).resourceId);
        }
    }

    @Override
    public void startRecordRefresh() {
        this.mCameraVideoController.recordState(true);
        this.mCameraVideoController.getChildView(R.id.iv_cloud_record).setContentDescription((CharSequence)"tuya_ipc_cloud_record_on");
        this.mTimer.startRecordRefresh((Context)this);
        this.mTimer.setVisibility(0);
        this.mCameraFullScreenOperateLayout.recordState(true);
    }

    @Override
    public void stopRecordRefresh() {
        this.mCameraVideoController.getChildView(R.id.iv_cloud_record).setContentDescription((CharSequence)"tuya_ipc_cloud_record_off");
        this.mTimer.stopRecordRefresh();
        this.mTimer.setVisibility(8);
        this.mCameraVideoController.recordState(false);
        this.mCameraFullScreenOperateLayout.recordState(false);
    }

    @Override
    public void showToast(int resId, int mode) {
        int drawableId = mode == 0 ? R.drawable.camera_success_tip : (mode == 1 ? R.drawable.camera_error_tip : R.drawable.camera_alert_tip);
        ToastUtil.showTipToast((Context)this, (int)resId, (int)drawableId, (int)0, (int)48, (int)0, (int)DensityUtil.dip2px((float)102.0f));
    }

    @Override
    public void otherControllerBtnEableState(boolean isEnable) {
        this.mCameraVideoController.getChildView(R.id.iv_cloud_play).setEnabled(isEnable);
        this.mCameraVideoController.getChildView(R.id.iv_cloud_snapshot).setEnabled(isEnable);
        this.mCameraVideoController.getChildView(R.id.iv_cloud_delete).setEnabled(isEnable);
        this.mCameraVideoController.getChildView(R.id.iv_cloud_download).setEnabled(isEnable);
        this.mCloudMuteView.setEnabled(isEnable);
        this.mFullPlayBtn.setEnabled(isEnable);
        if (isEnable) {
            this.mFullPlayBtn.setAlpha(1.0f);
            this.mCloudMuteView.setAlpha(1.0f);
            this.mCameraVideoController.getChildView(R.id.iv_cloud_play).setAlpha(1.0f);
            this.mCameraVideoController.getChildView(R.id.iv_cloud_snapshot).setAlpha(1.0f);
            this.mCameraVideoController.getChildView(R.id.iv_cloud_delete).setAlpha(1.0f);
            this.mCameraVideoController.getChildView(R.id.iv_cloud_download).setAlpha(1.0f);
        } else {
            this.mFullPlayBtn.setAlpha(0.5f);
            this.mCloudMuteView.setAlpha(0.5f);
            this.mCameraVideoController.getChildView(R.id.iv_cloud_play).setAlpha(0.5f);
            this.mCameraVideoController.getChildView(R.id.iv_cloud_snapshot).setAlpha(0.5f);
            this.mCameraVideoController.getChildView(R.id.iv_cloud_delete).setAlpha(0.5f);
            this.mCameraVideoController.getChildView(R.id.iv_cloud_download).setAlpha(0.5f);
        }
        this.mCameraFullScreenOperateLayout.otherControllerEnableByRecordState(isEnable);
    }

    @Override
    public void allControllerBtnEnableState(boolean isEnable) {
        this.mCloudMuteView.setEnabled(isEnable);
        if (isEnable) {
            this.mCloudMuteView.setAlpha(1.0f);
        } else {
            this.mCloudMuteView.setAlpha(0.5f);
        }
        this.mCameraVideoController.allViewenable(isEnable);
        this.mCameraFullScreenOperateLayout.allControllerEnableByPlayState(isEnable);
        this.mFullPlayBtn.setEnabled(isEnable);
        this.mFullPlayBtn.setAlpha(isEnable ? 1.0f : 0.5f);
        if (!isEnable) {
            this.mTimer.stopRecordRefresh();
        }
    }

    @Override
    public void updateTimerRuler(List<TimePieceBean> pieceBeans, long currentTimemillis) {
        this.mTimerBarView.setRecordDataExistTimeClipsList(pieceBeans);
        this.mTimerBarView.setCurrentTimeInMillisecond(currentTimemillis);
    }

    @Override
    public void updateTimerRulerCurrentTime(long timestamp) {
        this.mTimerBarView.setCurrentTimeInMillisecond(timestamp);
    }

    @Override
    public void showPhoto(String filePath, String tipStr) {
        if (this.mPresenter.isPortrait()) {
            this.mCameraPhotoLayout.loadImage(filePath, tipStr);
            RXClickUtils.clickView((View)this.mCameraPhotoLayout.getPhotoBtn(), (RXClickUtils.IRxCallback)this);
        } else {
            this.mIvCameraPhoto.loadImage(filePath);
            this.mPresenter.dismissPhotoDelay(3000);
            RXClickUtils.clickView((View)this.mIvCameraPhoto, (RXClickUtils.IRxCallback)this);
        }
    }

    public void onCreated(Object view) {
        this.mPresenter.generateMonitor(view);
        this.mVideoView.setEapilViewTemple(this.mDevId, 4);
        this.mVideoView.setEapilViewMode(0);
    }

    public void videoViewClick() {
        this.mVideoView.setAutoRotation(this.autoRotation);
        this.autoRotation = !this.autoRotation;
        this.mPresenter.videoViewClick();
    }

    @SuppressLint(value={"SourceLockedOrientationActivity"})
    public void rxOnClick(View view) {
        if (R.id.iv_camera_cloud_mute == view.getId() || R.id.camera_full_talk_btn == view.getId()) {
            this.mPresenter.setMuteValue();
        } else if (R.id.iv_cloud_full_screen == view.getId()) {
            this.setRequestedOrientation(0);
        } else if (R.id.camera_toolbar_back == view.getId()) {
            this.setRequestedOrientation(1);
        } else if (R.id.iv_cloud_snapshot == view.getId() || R.id.camera_full_snapshot_btn == view.getId()) {
            this.mPresenter.snapshotClick();
        } else if (R.id.iv_cloud_record == view.getId() || R.id.camera_full_record_btn == view.getId()) {
            this.mPresenter.handleRecordClick();
        } else if (R.id.iv_cloud_play == view.getId() || R.id.iv_camera_full_play == view.getId()) {
            this.mPresenter.pauseOrResumeVideo();
        } else if (R.id.tv_error == view.getId()) {
            this.mPresenter.playByTimePieceData(null);
        } else if (R.id.camera_tv_goto_photos == view.getId() || R.id.camera_iv_photo == view.getId()) {
            UrlRouterUtils.gotoLocalVideoPhoto((Context)this, (String)this.mDevId, (int)CameraUIThemeUtils.getCurrentThemeId());
        } else if (R.id.camera_cloud_over_warning == view.getId()) {
            this.mPresenter.gotoHybridCloudActivity();
        } else if (R.id.storage_opera_btn == view.getId()) {
            this.mPresenter.gotoHybridCloudActivity();
        } else if (R.id.iv_cloud_delete == view.getId()) {
            this.showTimeBarSelectView(true);
            this.mPresenter.deleteToday();
        } else if (R.id.iv_cloud_download == view.getId()) {
            this.mTimerBarView.showSelectTimeArea(true);
            this.mTimerBarView.setSelectTimeAreaRange(10L, 600L);
            this.mCameraCloudVideoOpera.setVisibility(0);
            this.mCameraCloudVideoOpera.showDownloadView();
            this.showTimeBarSelectView(true);
        } else if (R.id.ll_cloud_delete_today == view.getId()) {
            this.mPresenter.deleteToday();
        } else if (R.id.ll_cloud_delete_select == view.getId()) {
            this.mPresenter.deleteSelect(this.mSelectStartTime, this.mSelectEndTime);
        } else if (R.id.ll_cloud_download == view.getId()) {
            this.mPresenter.downloadSelect(this.mSelectStartTime, this.mSelectEndTime);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (null != this.mTimerBarView) {
            this.mTimerBarView.setChangeOrientation(true, newConfig.orientation);
        }
        this.mPresenter.onConfigurationChanged(newConfig);
    }

    public void startCameraMove(int cameraDirection) {
    }

    public void onActionUP() {
    }

    protected String getPageName() {
        return this.getString(R.string.ipc_cloudstorage_title);
    }

    public void onBackPressed() {
        if (null != this.mTimerBarView && this.mTimerBarView.isSelectTimeArea()) {
            this.showTimeBarSelectView(false);
        } else {
            super.onBackPressed();
        }
    }
}

