/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.ipc.cloud.panel;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import android.util.Log;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tuya.smart.android.common.utils.L;
import com.tuya.smart.camera.base.bean.CloudDayBean;
import com.tuya.smart.camera.base.bean.TimeRangeBean;
import com.tuya.smart.camera.base.utils.DeviceInfoUtils;
import com.tuya.smart.camera.utils.TimeZoneUtils;
import com.tuya.smart.home.sdk.TuyaHomeSdk;
import com.tuya.smart.ipc.cloud.panel.business.CameraCloudBusiness;
import com.tuya.smart.ipc.panel.api.AbsCameraCloudService;
import com.tuya.smart.ipc.panel.api.CameraCloudServiceListener;
import com.tuya.smart.sdk.bean.DeviceBean;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class CameraCloudServiceImp
extends AbsCameraCloudService {
    private static final String TAG = "CameraCloudServiceImp";
    private Map<String, String> mEncryptKeyMap = new HashMap<String, String>();
    private CameraCloudBusiness mCameraBusiness;
    private List<CameraCloudServiceListener> mListeners = new ArrayList<CameraCloudServiceListener>();

    private String parseCloudServiceStatus(Object o) {
        String servedStatus = "";
        L.d((String)TAG, (String)(" o " + o));
        if (o == null) {
            return servedStatus;
        }
        JSONObject jsonObject = (JSONObject)o;
        servedStatus = jsonObject.size() == 0 ? "unServed" : jsonObject.getString("servedStatus");
        return servedStatus;
    }

    private boolean isNvrSubDevice(DeviceBean deviceBean) {
        if (null == deviceBean.getMeshId()) {
            return false;
        }
        DeviceBean jzBean = TuyaHomeSdk.getDataInstance().getDeviceBean(deviceBean.getMeshId());
        if (null == jzBean) {
            return false;
        }
        String category = jzBean.getProductBean().getCategory();
        return category.equals("nvr") || category.equals("dvr");
    }

    public void queryCloudServiceStatus(String devId, final AbsCameraCloudService.CloudServiceCallback callback) {
        DeviceInfoUtils.getDeviceBean((String)devId, (DeviceInfoUtils.GetDeviceBeanCallback)new DeviceInfoUtils.GetDeviceBeanCallback(){

            public void success(DeviceBean bean) {
                CameraCloudServiceImp.this.getCloudStorageState(bean, new CloudServiceResultCallback<Integer>(){

                    @Override
                    public void onSuccess(Integer data) {
                        if (null != callback) {
                            callback.callback(String.valueOf(data), data == 10010);
                        }
                    }

                    @Override
                    public void onFailed(int code, String errMsg) {
                        if (null != callback) {
                            callback.callback("", false);
                        }
                    }
                });
            }

            public void failed(String msg, String code) {
                L.d((String)CameraCloudServiceImp.TAG, (String)("getDeviceBean failed, msg: " + msg + ", code: " + code));
            }
        });
    }

    private CameraCloudBusiness getCameraBusiness() {
        if (null == this.mCameraBusiness) {
            this.mCameraBusiness = new CameraCloudBusiness();
            this.mCameraBusiness.initRxJavaHander();
        }
        return this.mCameraBusiness;
    }

    public String getEncryptKeyFromCache(String devId) {
        String key = "";
        if (TextUtils.isEmpty((CharSequence)devId)) {
            Log.e((String)TAG, (String)"devId must not be empty");
        } else if (this.mEncryptKeyMap.containsKey(devId)) {
            key = this.mEncryptKeyMap.get(devId);
        }
        return key;
    }

    @SuppressLint(value={"CheckResult"})
    private void getEncryptKey(final String devId, final CloudServiceResultCallback<String> callback) {
        if (TextUtils.isEmpty((CharSequence)devId)) {
            callback.onFailed(10006, "devId must not be empty");
            return;
        }
        String encryptKeyFromCache = this.getEncryptKeyFromCache(devId);
        if (TextUtils.isEmpty((CharSequence)encryptKeyFromCache)) {
            this.getCameraBusiness().getCloudSecret(devId).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new Consumer(){

                public void accept(Object o) throws Exception {
                    if (o == null) {
                        callback.onFailed(10006, "empty result");
                    } else {
                        String encryptKey = ((JSONObject)o).getString("encryptKey");
                        if (TextUtils.isEmpty((CharSequence)encryptKey)) {
                            callback.onFailed(10006, "empty value");
                        } else {
                            CameraCloudServiceImp.this.mEncryptKeyMap.put(devId, encryptKey);
                            callback.onSuccess(encryptKey);
                        }
                    }
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) throws Exception {
                    callback.onFailed(CameraCloudServiceImp.this.getErrorCode(throwable), throwable.getMessage());
                }
            });
        } else {
            callback.onSuccess(this.mEncryptKeyMap.get(devId));
        }
    }

    public void queryCloudServiceStatus(DeviceBean mDeviceBean) {
        this.getCloudStorageState(mDeviceBean, new CloudServiceResultCallback<Integer>(){

            @Override
            public void onSuccess(Integer data) {
                for (CameraCloudServiceListener listener : CameraCloudServiceImp.this.mListeners) {
                    listener.onGetCloudStorageStateSuc(data.intValue());
                }
            }

            @Override
            public void onFailed(int code, String errMsg) {
                for (CameraCloudServiceListener listener : CameraCloudServiceImp.this.mListeners) {
                    listener.onGetCloudStorageStateFailed(code, errMsg);
                }
            }
        });
    }

    @SuppressLint(value={"CheckResult"})
    private void getCloudStorageState(DeviceBean mDeviceBean, final CloudServiceResultCallback<Integer> callback) {
        if (mDeviceBean == null) {
            callback.onFailed(10006, "DeviceBean not found");
            return;
        }
        String uuid = mDeviceBean.getUuid();
        String pid = mDeviceBean.getProductId();
        if (this.isNvrSubDevice(mDeviceBean)) {
            String nvrDevId = mDeviceBean.getMeshId();
            DeviceBean parentDeviceBean = TuyaHomeSdk.getDataInstance().getDeviceBean(nvrDevId);
            if (null != parentDeviceBean) {
                uuid = parentDeviceBean.getUuid();
                pid = parentDeviceBean.getProductId();
            }
        }
        this.getCameraBusiness().queryCloudStorageServiced(uuid, pid).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<JSONObject>(){

            public void accept(JSONObject jsonObject) throws Exception {
                int cloudStatus = 10001;
                if (jsonObject != null) {
                    String servedStatus = jsonObject.getString("servedStatus");
                    if ("running".equals(servedStatus)) {
                        cloudStatus = 10010;
                    } else if ("expire".equals(servedStatus)) {
                        cloudStatus = 10011;
                    }
                }
                callback.onSuccess(cloudStatus);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                callback.onFailed(CameraCloudServiceImp.this.getErrorCode(throwable), throwable.getMessage());
            }
        });
    }

    public void getLastDayTimeRange(final DeviceBean deviceBean, final int limit) {
        final int[] cloudState = new int[]{10011};
        Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Integer>(){

            public void subscribe(final ObservableEmitter<Integer> emitter) throws Exception {
                CameraCloudServiceImp.this.getCloudStorageState(deviceBean, new CloudServiceResultCallback<Integer>(){

                    @Override
                    public void onSuccess(Integer data) {
                        if (data == 10010 || data == 10011) {
                            cloudState[0] = data;
                            emitter.onNext((Object)data);
                            emitter.onComplete();
                        } else {
                            emitter.onError(new Throwable(String.valueOf(data)));
                        }
                    }

                    @Override
                    public void onFailed(int code, String errMsg) {
                        emitter.onError(new Throwable(String.valueOf(code)));
                    }
                });
            }
        }).concatMap((Function)new Function<Integer, ObservableSource<CloudDayBean>>(){

            public ObservableSource<CloudDayBean> apply(Integer o) throws Exception {
                final int cloudState = o;
                return CameraCloudServiceImp.this.getCameraBusiness().queryCloudMediaCount(deviceBean.getDevId(), TimeZoneUtils.getTimezoneGCMById((String)TimeZone.getDefault().getID())).subscribeOn(Schedulers.newThread()).concatMap((Function)new Function<Object, ObservableSource<CloudDayBean>>(){

                    public ObservableSource<CloudDayBean> apply(Object o) throws Exception {
                        List dayBeanList = JSONArray.parseArray((String)((JSONArray)o).toJSONString(), CloudDayBean.class);
                        if (dayBeanList.size() > 0) {
                            Collections.sort(dayBeanList);
                            return Observable.just(dayBeanList.get(dayBeanList.size() - 1));
                        }
                        int code = CameraCloudServiceImp.this.getCloudServiced(0, cloudState);
                        return Observable.error((Throwable)new Throwable(String.valueOf(code)));
                    }
                });
            }
        }).concatMap((Function)new Function<CloudDayBean, ObservableSource<List<TimeRangeBean>>>(){

            public ObservableSource<List<TimeRangeBean>> apply(CloudDayBean dayBean) throws Exception {
                return CameraCloudServiceImp.this.getCameraBusiness().getTimeRange(deviceBean.getDevId(), String.valueOf(dayBean.getCurrentStartDayTime()), String.valueOf(dayBean.getCurrentDayEndTime()), 0, limit).observeOn(Schedulers.io()).concatMap((Function)new Function<JSONObject, ObservableSource<List<TimeRangeBean>>>(){

                    public ObservableSource<List<TimeRangeBean>> apply(JSONObject o) throws Exception {
                        int totalCount = o.getInteger("totalCount");
                        if (totalCount > 0) {
                            JSONArray jsonArray = o.getJSONArray("datas");
                            List timeRangeBeans = JSONArray.parseArray((String)jsonArray.toJSONString(), TimeRangeBean.class);
                            return Observable.just((Object)timeRangeBeans);
                        }
                        int code = CameraCloudServiceImp.this.getCloudServiced(2, cloudState[0]);
                        return Observable.error((Throwable)new Throwable(String.valueOf(code)));
                    }
                });
            }
        }).concatMap((Function)new Function<List<TimeRangeBean>, ObservableSource<List<TimeRangeBean>>>(){

            public ObservableSource<List<TimeRangeBean>> apply(final List<TimeRangeBean> timeRangeBeans) throws Exception {
                return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<List<TimeRangeBean>>(){

                    public void subscribe(final ObservableEmitter<List<TimeRangeBean>> emitter) throws Exception {
                        CameraCloudServiceImp.this.mEncryptKeyMap.remove(deviceBean.getDevId());
                        CameraCloudServiceImp.this.getEncryptKey(deviceBean.getDevId(), new CloudServiceResultCallback<String>(){

                            @Override
                            public void onSuccess(String data) {
                                emitter.onNext((Object)timeRangeBeans);
                                emitter.onComplete();
                            }

                            @Override
                            public void onFailed(int code, String errMsg) {
                                emitter.onError(new Throwable(String.valueOf(code)));
                            }
                        });
                    }
                });
            }
        }).subscribe((Consumer)new Consumer<List<TimeRangeBean>>(){

            public void accept(List<TimeRangeBean> o) throws Exception {
                L.d((String)CameraCloudServiceImp.TAG, (String)"getLastDayTimeRange finish");
                int cloudServiceCode = CameraCloudServiceImp.this.getCloudServiced(1, cloudState[0]);
                for (CameraCloudServiceListener listener : CameraCloudServiceImp.this.mListeners) {
                    listener.onGetTimeRange(cloudServiceCode, o);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                L.d((String)CameraCloudServiceImp.TAG, (String)"getLastDayTimeRange error");
                int errorCode = CameraCloudServiceImp.this.getErrorCode(throwable);
                for (CameraCloudServiceListener listener : CameraCloudServiceImp.this.mListeners) {
                    listener.onGetTimeRange(errorCode, null);
                }
            }
        });
    }

    public void registerCameraCloudServiceListener(CameraCloudServiceListener listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void unregisterCameraCloudServiceListener(CameraCloudServiceListener listener) {
        this.mListeners.remove(listener);
    }

    private int getCloudServiced(int data, int servedStatus) {
        int code = 10010 == servedStatus ? (data == 1 ? 10003 : 10002) : (10011 == servedStatus ? (data == 1 ? 10004 : (data == 2 ? 10007 : 10005)) : 10001);
        return code;
    }

    private int getErrorCode(Throwable throwable) {
        int code = 10006;
        String msg = throwable.getMessage();
        if (msg != null) {
            switch (msg) {
                case "100001": 
                case "10001": {
                    code = 10001;
                    break;
                }
                case "10003": {
                    code = 10003;
                    break;
                }
                case "10002": {
                    code = 10002;
                    break;
                }
                case "10004": {
                    code = 10004;
                    break;
                }
                case "10005": {
                    code = 10005;
                    break;
                }
                case "10007": {
                    code = 10007;
                    break;
                }
            }
        }
        return code;
    }

    private static interface CloudServiceResultCallback<T> {
        public void onSuccess(T var1);

        public void onFailed(int var1, String var2);
    }
}

