/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.ipc.cloud.panel.cache;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tuya.smart.android.common.utils.L;
import com.tuya.smart.android.network.Business;
import com.tuya.smart.android.network.http.BusinessResponse;
import com.tuya.smart.camera.base.bean.CloudDayBean;
import com.tuya.smart.camera.base.bean.CloudUrlBean;
import com.tuya.smart.camera.base.bean.TimeRangeBean;
import com.tuya.smart.camera.base.business.HBusiness;
import com.tuya.smart.camera.utils.TimeZoneUtils;
import com.tuya.smart.home.sdk.TuyaHomeSdk;
import com.tuya.smart.ipc.cloud.panel.a;
import com.tuya.smart.sdk.bean.DeviceBean;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.exceptions.UndeliverableException;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Function3;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;

public class CameraCloudCacheManager {
    public static final String ERROR_QUERY = "100006";
    public static final String ERROR_NO_SERVES = "100001";
    private static final String TAG = "CameraCloudCacheManager";
    private static volatile CameraCloudCacheManager cacheManager;
    private static List<CloudDayBean> mDayBeanList;
    private static List<TimeRangeBean> mTimeRangeList;
    private int code;
    private String mEncryptKey = "";
    private String mAuthorityJson;
    private String servedStatus;
    private a mCameraBusiness = new a();
    private HBusiness mHBusiness;
    private String mIpcUrl;

    private CameraCloudCacheManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static CameraCloudCacheManager getInstance() {
        if (cacheManager == null) {
            Class<CameraCloudCacheManager> clazz = CameraCloudCacheManager.class;
            // MONITORENTER : com.tuya.smart.ipc.cloud.panel.cache.CameraCloudCacheManager.class
            if (cacheManager == null) {
                cacheManager = new CameraCloudCacheManager();
            }
            // MONITOREXIT : clazz
        }
        RxJavaPlugins.setErrorHandler((Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                if (e instanceof UndeliverableException) {
                    e = e.getCause();
                }
                if (e instanceof IOException) {
                    return;
                }
                if (e instanceof InterruptedException) {
                    return;
                }
                if (e instanceof NullPointerException || e instanceof IllegalArgumentException) {
                    Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                    return;
                }
                if (e instanceof IllegalStateException) {
                    Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                    return;
                }
            }
        });
        return cacheManager;
    }

    public CloudDayBean getLastCloudDay() {
        if (mDayBeanList.size() > 0) {
            return mDayBeanList.get(mDayBeanList.size() - 1);
        }
        return null;
    }

    private boolean isNvrSubDevice(DeviceBean deviceBean) {
        if (null == deviceBean.getMeshId()) {
            return false;
        }
        DeviceBean jzBean = TuyaHomeSdk.getDataInstance().getDeviceBean(deviceBean.getMeshId());
        if (null == jzBean) {
            return false;
        }
        String category = jzBean.getProductBean().getCategory();
        return category.equals("nvr") || category.equals("dvr");
    }

    @SuppressLint(value={"CheckResult"})
    public void initCameraCloud(DeviceBean deviceBean, final ICloudCacheManagerCallback callback) {
        if (deviceBean == null) {
            return;
        }
        String uuid = deviceBean.getUuid();
        if (this.isNvrSubDevice(deviceBean)) {
            String nvrDevId = deviceBean.getMeshId();
            uuid = TuyaHomeSdk.getDataInstance().getDeviceBean(nvrDevId).getUuid();
        }
        Observable observable1 = this.mCameraBusiness.a(uuid, deviceBean.getProductId());
        String timeZoneId = TimeZone.getDefault().getID();
        Observable observable2 = this.mCameraBusiness.b(deviceBean.getDevId(), TimeZoneUtils.getTimezoneGCMById((String)timeZoneId));
        Observable observable3 = this.mCameraBusiness.a(deviceBean.getDevId());
        Observable.zip((ObservableSource)observable1, (ObservableSource)observable2, (ObservableSource)observable3, (Function3)new Function3(){

            public Object apply(Object o, Object o2, Object o3) {
                L.d((String)CameraCloudCacheManager.TAG, (String)(" o " + o));
                if (o == null) {
                    CameraCloudCacheManager.this.code = 10001;
                    return null;
                }
                JSONObject jsonObject = (JSONObject)o;
                if (jsonObject.size() == 0) {
                    CameraCloudCacheManager.this.servedStatus = "unServed";
                    CameraCloudCacheManager.this.code = 10001;
                    return null;
                }
                CameraCloudCacheManager.this.servedStatus = jsonObject.getString("servedStatus");
                if (o2 == null) {
                    CameraCloudCacheManager.this.code = CameraCloudCacheManager.this.getCloudServiced(0);
                    return null;
                }
                mDayBeanList.clear();
                mDayBeanList = JSONArray.parseArray((String)((JSONArray)o2).toJSONString(), CloudDayBean.class);
                if (mDayBeanList == null || mDayBeanList.size() <= 0) {
                    CameraCloudCacheManager.this.code = CameraCloudCacheManager.this.getCloudServiced(0);
                    return null;
                }
                Collections.sort(mDayBeanList);
                if (o3 == null) {
                    CameraCloudCacheManager.this.code = 10006;
                    return null;
                }
                CameraCloudCacheManager.this.mEncryptKey = ((JSONObject)o3).getString("encryptKey");
                if (TextUtils.isEmpty((CharSequence)CameraCloudCacheManager.this.mEncryptKey)) {
                    CameraCloudCacheManager.this.code = 10006;
                    return null;
                }
                return "";
            }
        }).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new Consumer(){

            public void accept(Object o) {
                L.d((String)CameraCloudCacheManager.TAG, (String)(" o " + o));
                CameraCloudCacheManager.this.code = CameraCloudCacheManager.this.getCloudServiced(1);
                callback.onSuccess(CameraCloudCacheManager.this.code);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                L.d((String)CameraCloudCacheManager.TAG, (String)(" o " + throwable.getMessage()));
                if (CameraCloudCacheManager.ERROR_QUERY.equals(throwable.getMessage())) {
                    CameraCloudCacheManager.this.code = 10006;
                } else if (CameraCloudCacheManager.ERROR_NO_SERVES.equals(throwable.getMessage())) {
                    CameraCloudCacheManager.this.code = 10001;
                }
                callback.onError(CameraCloudCacheManager.this.code);
            }
        });
    }

    @SuppressLint(value={"CheckResult"})
    public void queryAuthTokenByTags(String devId, String tags, final ICloudCacheManagerCallback callback) {
        this.mCameraBusiness.d(devId, tags).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<String>(){

            public void accept(String o) {
                L.d((String)CameraCloudCacheManager.TAG, (String)(" o " + o));
                if (o == null) {
                    CameraCloudCacheManager.this.code = 10006;
                    callback.onError(CameraCloudCacheManager.this.code);
                } else {
                    CameraCloudCacheManager.this.mAuthorityJson = o;
                    callback.getAuthorityGet(CameraCloudCacheManager.this.mAuthorityJson);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                L.d((String)CameraCloudCacheManager.TAG, (String)(" o " + throwable.getMessage()));
                if (CameraCloudCacheManager.ERROR_QUERY.equals(throwable.getMessage())) {
                    CameraCloudCacheManager.this.code = 10006;
                } else if (CameraCloudCacheManager.ERROR_NO_SERVES.equals(throwable.getMessage())) {
                    CameraCloudCacheManager.this.code = 10001;
                }
                callback.onError(CameraCloudCacheManager.this.code);
            }
        });
    }

    public String getServedStatus() {
        return this.servedStatus;
    }

    @SuppressLint(value={"CheckResult"})
    public void queryCloudMediaCount(final String devId, String timeZone, final ICloudCacheManagerCallback callback) {
        this.mCameraBusiness.b(devId, TimeZoneUtils.getTimezoneGCMById((String)timeZone)).subscribeOn(Schedulers.newThread()).concatMap(new Function(){

            public Object apply(Object o) {
                mDayBeanList.clear();
                mDayBeanList = JSONArray.parseArray((String)((JSONArray)o).toJSONString(), CloudDayBean.class);
                if (mDayBeanList != null && mDayBeanList.size() > 0) {
                    Collections.sort(mDayBeanList);
                    callback.getCloudDayList(mDayBeanList);
                    return CameraCloudCacheManager.this.mCameraBusiness.a(devId);
                }
                CameraCloudCacheManager.this.code = CameraCloudCacheManager.this.getCloudServiced(0);
                return Observable.empty();
            }
        }).concatMap(new Function(){

            public Object apply(Object o) {
                L.d((String)CameraCloudCacheManager.TAG, (String)("o  flatMap +++++" + o));
                CameraCloudCacheManager.this.mEncryptKey = ((JSONObject)o).getString("encryptKey");
                if (TextUtils.isEmpty((CharSequence)CameraCloudCacheManager.this.mEncryptKey)) {
                    CameraCloudCacheManager.this.code = 10006;
                    return null;
                }
                callback.getCloudSecret(CameraCloudCacheManager.this.mEncryptKey);
                return Observable.empty();
            }
        }).onErrorReturn(new Function(){

            public Object apply(Object o) {
                L.d((String)CameraCloudCacheManager.TAG, (String)("o  onErrorReturn +++++" + o));
                return "Error Return";
            }
        }).subscribe((Consumer)new Consumer<JSONObject>(){

            public void accept(JSONObject o) {
                L.d((String)CameraCloudCacheManager.TAG, (String)("o  +++++" + o));
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                L.d((String)CameraCloudCacheManager.TAG, (String)("  Throwable   ++ ++++" + throwable));
                callback.onError(CameraCloudCacheManager.this.code);
            }
        }, new Action(){

            public void run() throws Exception {
                callback.onSuccess(CameraCloudCacheManager.this.code);
            }
        });
    }

    @SuppressLint(value={"CheckResult"})
    public void getTimeRange(CloudDayBean dayBean, String devId, int offset, int limit, final ICloudCacheManagerCallback callback) {
        this.mCameraBusiness.a(devId, String.valueOf(dayBean.getCurrentStartDayTime()), String.valueOf(dayBean.getCurrentDayEndTime()), offset, limit).observeOn(Schedulers.io()).subscribe((Consumer)new Consumer<JSONObject>(){

            public void accept(JSONObject o) {
                L.d((String)CameraCloudCacheManager.TAG, (String)("o  getTimeRange +++++ " + o));
                int totalCount = o.getInteger("totalCount");
                if (totalCount > 0) {
                    mTimeRangeList.clear();
                    JSONArray jsonArray = o.getJSONArray("datas");
                    mTimeRangeList = JSONArray.parseArray((String)jsonArray.toJSONString(), TimeRangeBean.class);
                    callback.getTimeRange(mTimeRangeList);
                } else {
                    callback.getTimeRange(mTimeRangeList);
                }
            }
        });
    }

    public List<TimeRangeBean> getmTimeRangeList() {
        return mTimeRangeList;
    }

    public void onDestroy() {
        this.mCameraBusiness.onDestroy();
        mDayBeanList.clear();
        mTimeRangeList.clear();
        cacheManager = null;
        this.servedStatus = "";
    }

    public String getEncryptKey() {
        return this.mEncryptKey;
    }

    public String getAuthorityJson() {
        return this.mAuthorityJson;
    }

    public List<CloudDayBean> getDayBeanList() {
        return mDayBeanList;
    }

    private int getCloudServiced(int data) {
        int code = "running".equals(this.servedStatus) ? (data == 1 ? 10003 : 10002) : ("expire".equals(this.servedStatus) ? (data == 1 ? 10004 : 10005) : 10001);
        return code;
    }

    public void getCloudStorageUrl(final ICloudStorageUrlCallback callback) {
        if (!TextUtils.isEmpty((CharSequence)this.mIpcUrl)) {
            callback.onSuccess(this.mIpcUrl);
            return;
        }
        if (null == this.mHBusiness) {
            this.mHBusiness = new HBusiness();
        }
        this.mHBusiness.getCloudStorageUrl((Business.ResultListener)new Business.ResultListener<ArrayList<CloudUrlBean>>(){

            public void onFailure(BusinessResponse businessResponse, ArrayList<CloudUrlBean> cloudUrlBeans, String s) {
                callback.onFailure(s);
            }

            public void onSuccess(BusinessResponse businessResponse, ArrayList<CloudUrlBean> cloudUrlBeans, String s) {
                if (cloudUrlBeans == null) {
                    callback.onFailure(s);
                } else {
                    for (CloudUrlBean cloudUrlBean : cloudUrlBeans) {
                        if (!"ipc".equals(cloudUrlBean.getKey())) continue;
                        CameraCloudCacheManager.this.mIpcUrl = "https://" + cloudUrlBean.getAppDomain();
                        callback.onSuccess(CameraCloudCacheManager.this.mIpcUrl);
                    }
                }
            }
        });
    }

    static {
        mDayBeanList = new ArrayList<CloudDayBean>();
        mTimeRangeList = new ArrayList<TimeRangeBean>();
    }

    public static interface ICloudStorageUrlCallback {
        public void onFailure(String var1);

        public void onSuccess(String var1);
    }

    public static interface ICloudCacheManagerCallback {
        public void getCloudDayList(List<CloudDayBean> var1);

        public void getCloudSecret(String var1);

        public void getAuthorityGet(String var1);

        public void getTimeRange(List<TimeRangeBean> var1);

        public void getCloudServiced(String var1);

        public void onError(int var1);

        public void onSuccess(int var1);
    }
}

