/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.camera;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import com.tuya.smart.android.panel.TuyaPanelSDK;
import com.tuya.smart.android.panel.api.ITuyaPanelLoadCallback;
import com.tuya.smart.api.router.UrlBuilder;
import com.tuya.smart.api.router.UrlRouter;
import com.tuya.smart.camera.AlbumPanelListener;
import com.tuya.smart.camera.CloudStoragePanelListener;
import com.tuya.smart.camera.DeviceInfoListener;
import com.tuya.smart.camera.FeedbackListener;
import com.tuya.smart.camera.MessagePanelListener;
import com.tuya.smart.camera.PlaybackPanelListener;
import com.tuya.smart.camera.SettingListener;
import com.tuya.smart.camera.base.GlobalParamsManagement;
import com.tuya.smart.camera.base.utils.FrescoManager;
import com.tuya.smart.camera.base.utils.UrlRouterUtils;
import com.tuya.smart.sdk.bean.DeviceBean;

public class CameraButt {
    private static final String TAG = "CameraButt";
    private SettingListener settingListener;
    private FeedbackListener feedbackListener;
    private DeviceInfoListener deviceInfoListener;
    private PlaybackPanelListener onPlaybackPanelListener;
    private MessagePanelListener onMessagePanelListener;
    private AlbumPanelListener onAlbumPanelListener;
    private CloudStoragePanelListener cloudStoragePanelListener;

    public void setCustomSettingListener(SettingListener settingListener) {
        this.settingListener = settingListener;
    }

    public void setCustomDeviceInfoListener(DeviceInfoListener deviceInfoListener) {
        this.deviceInfoListener = deviceInfoListener;
    }

    public void setCustomFeedbackListener(FeedbackListener feedbackListener) {
        this.feedbackListener = feedbackListener;
    }

    private CameraButt() {
    }

    public void setCustomPlaybackPanelListener(PlaybackPanelListener listener) {
        this.onPlaybackPanelListener = listener;
    }

    public void setCustomMessagePanelListener(MessagePanelListener listener) {
        this.onMessagePanelListener = listener;
    }

    public void setCustomAlbumPanelListener(AlbumPanelListener listener) {
        this.onAlbumPanelListener = listener;
    }

    public void setCustomCloudStoragePanelListener(CloudStoragePanelListener listener) {
        this.cloudStoragePanelListener = listener;
    }

    public static CameraButt getInstance() {
        return CameraButtHolder.INSTANCE;
    }

    public void init(Application application) {
        GlobalParamsManagement.getInstance().setApplication(application);
        FrescoManager.initFresco((Context)application);
    }

    public void gotoCameraPanel(Context context, long homeId, DeviceBean devBean) {
        if (null == devBean || null == devBean.getProductBean()) {
            return;
        }
        if ("RN".equals(devBean.getProductBean().getUiInfo().getType())) {
            if (context instanceof Activity) {
                this.gotoRNCameraPanel((Activity)context, homeId, devBean.getDevId());
            }
        } else if ("NA".equals(devBean.getProductBean().getUiInfo().getType()) && context instanceof Activity) {
            this.gotoNativeCameraPanel(context, homeId, devBean.getDevId());
        }
    }

    public void gotoCameraPanel(Context context, long homeId, DeviceBean devBean, SettingListener mSettingListeners) {
        if (null == devBean || null == devBean.getProductBean()) {
            return;
        }
        this.settingListener = mSettingListeners;
        if ("RN".equals(devBean.getProductBean().getUiInfo().getType())) {
            if (context instanceof Activity) {
                this.gotoRNCameraPanel((Activity)context, homeId, devBean.getDevId());
            }
        } else if ("NA".equals(devBean.getProductBean().getUiInfo().getType()) && context instanceof Activity) {
            this.gotoNativeCameraPanel(context, homeId, devBean.getDevId());
        }
    }

    public void gotoNativeCameraPanel(Context context, long homeId, String deviceId) {
        GlobalParamsManagement.getInstance().setCurrentHomeId(homeId);
        UrlRouterUtils.gotoCameraPanelActivity((Context)context, (String)deviceId);
    }

    public void gotoRNCameraPanel(Activity context, long homeId, String deviceId) {
        this.gotoRNCameraPanel(context, homeId, deviceId, null);
    }

    public void gotoRNCameraPanel(Activity context, long homeId, String deviceId, ITuyaPanelLoadCallback loadCallback) {
        GlobalParamsManagement.getInstance().setCurrentHomeId(homeId);
        if (null == loadCallback) {
            loadCallback = new ITuyaPanelLoadCallback(){

                public void onStart(String s) {
                }

                public void onError(String s, int i, String s1) {
                }

                public void onSuccess(String s) {
                }

                public void onProgress(String s, int i) {
                }
            };
        }
        TuyaPanelSDK.getPanelInstance().gotoPanelViewControllerWithDevice(context, homeId, deviceId, loadCallback);
    }

    public void gotoDoorbellCallingPanel(Context context, long homeId, String deviceId) {
        GlobalParamsManagement.getInstance().setCurrentHomeId(homeId);
        Bundle bundle = new Bundle();
        bundle.putString("devId", deviceId);
        UrlBuilder urlBuilder = new UrlBuilder(context, "camera_door_bell").putExtras(bundle);
        UrlRouter.execute((UrlBuilder)urlBuilder);
    }

    public void gotoAcDoorbellCallingPanel(Context context, long homeId, String deviceId, long startTime) {
        GlobalParamsManagement.getInstance().setCurrentHomeId(homeId);
        Bundle bundle = new Bundle();
        bundle.putString("extra_camera_uuid", deviceId);
        bundle.putLong("doorbell_start_time", startTime);
        UrlBuilder urlBuilder = new UrlBuilder(context, "camera_action_doorbell").putExtras(bundle);
        UrlRouter.execute((UrlBuilder)urlBuilder);
    }

    public boolean supportCustomSetting() {
        return null != this.settingListener;
    }

    public void onPanelSettingClick(String deviceId) {
        if (null != this.settingListener) {
            this.settingListener.onSettingClick(deviceId);
        }
    }

    public boolean supportCustomFeedback() {
        return null != this.feedbackListener;
    }

    public void onFeedbackClick(String deviceId) {
        if (null != this.feedbackListener) {
            this.feedbackListener.onFeedbackClick(deviceId);
        }
    }

    public boolean supportCustomDeviceInfo() {
        return null != this.deviceInfoListener;
    }

    public void onDeviceInfoClick(String deviceId) {
        if (null != this.deviceInfoListener) {
            this.deviceInfoListener.onDeviceInfoClick(deviceId);
        }
    }

    public boolean supportCustomPlaybackPanel() {
        return null != this.onPlaybackPanelListener;
    }

    public void onPlaybackPanelClick(String deviceId) {
        if (null != this.onPlaybackPanelListener) {
            this.onPlaybackPanelListener.onPlaybackPanelClick(deviceId);
        }
    }

    public boolean supportCustomMessagePanel() {
        return null != this.onMessagePanelListener;
    }

    public void onMessagePanelClick(String deviceId) {
        if (null != this.onMessagePanelListener) {
            this.onMessagePanelListener.onMessagePanelClick(deviceId);
        }
    }

    public boolean supportCustomAlbumPanel() {
        return null != this.onAlbumPanelListener;
    }

    public void onAlbumPanelClick(String deviceId) {
        if (null != this.onAlbumPanelListener) {
            this.onAlbumPanelListener.onAlbumPanelClick(deviceId);
        }
    }

    public boolean supportCustomCloudStoragePanel() {
        return null != this.cloudStoragePanelListener;
    }

    public void onCloudStoragePanelClick(String deviceId) {
        if (null != this.cloudStoragePanelListener) {
            this.cloudStoragePanelListener.onCloudStoragePanelClick(deviceId);
        }
    }

    private static class CameraButtHolder {
        private static CameraButt INSTANCE = new CameraButt();

        private CameraButtHolder() {
        }
    }
}

