/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.android.blemesh.bean;

import android.os.Parcel;
import android.os.Parcelable;
import com.tuya.sdk.sigmesh.model.SigModel;
import com.tuya.sdk.sigmesh.model.VendorModel;
import com.tuya.sdk.sigmesh.transport.MeshModel;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Element
implements Parcelable {
    public static final Parcelable.Creator<Element> CREATOR = new Parcelable.Creator<Element>(){

        public Element createFromParcel(Parcel parcel) {
            return new Element(parcel);
        }

        public Element[] newArray(int n) {
            return new Element[n];
        }
    };
    public final int locationDescriptor;
    public final Map<Integer, MeshModel> meshModels;
    public byte[] elementAddress;

    public Element(byte[] byArray, int n, Map<Integer, MeshModel> map) {
        this.elementAddress = byArray;
        this.locationDescriptor = n;
        this.meshModels = map;
    }

    public Element(int n, Map<Integer, MeshModel> map) {
        this.locationDescriptor = n;
        this.meshModels = map;
    }

    public Element(Parcel parcel) {
        Element element = this;
        this.elementAddress = parcel.createByteArray();
        element.locationDescriptor = parcel.readInt();
        element.meshModels = new LinkedHashMap<Integer, MeshModel>();
        this.sortModels(parcel.readHashMap(MeshModel.class.getClassLoader()));
    }

    private void sortModels(HashMap<Integer, MeshModel> hashMap) {
        Object object = hashMap.keySet();
        ArrayList<Integer> arrayList = new ArrayList<Integer>((Collection<Integer>)object);
        Collections.sort(arrayList);
        object = arrayList.iterator();
        while (object.hasNext()) {
            int n;
            int n2 = n = ((Integer)object.next()).intValue();
            Integer n3 = n2;
            this.meshModels.put(n3, hashMap.get(n2));
        }
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeByteArray(this.elementAddress);
        parcel.writeInt(this.locationDescriptor);
        parcel.writeMap(this.meshModels);
    }

    public int describeContents() {
        return 0;
    }

    public byte[] getElementAddress() {
        return this.elementAddress;
    }

    public int getLocationDescriptor() {
        return this.locationDescriptor;
    }

    public int getSigModelCount() {
        int n = 0;
        Iterator<Map.Entry<Integer, MeshModel>> iterator = this.meshModels.entrySet().iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next().getValue() instanceof SigModel)) continue;
            ++n;
        }
        return n;
    }

    public int getVendorModelCount() {
        int n = 0;
        Iterator<Map.Entry<Integer, MeshModel>> iterator = this.meshModels.entrySet().iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next().getValue() instanceof VendorModel)) continue;
            ++n;
        }
        return n;
    }

    public Map<Integer, MeshModel> getMeshModels() {
        return Collections.unmodifiableMap(this.meshModels);
    }

    public int getElementAddressInt() {
        return ByteBuffer.wrap(this.elementAddress).order(ByteOrder.BIG_ENDIAN).getShort();
    }
}

