/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.sigmesh.util;

import android.os.Parcel;
import android.os.Parcelable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class PublicationSettings
implements Parcelable {
    public static final int DEFAULT_PUBLISH_TTL = 127;
    public static final int DEFAULT_PUBLICATION_STEPS = 0;
    public static final int DEFAULT_PUBLICATION_RESOLUTION = 0;
    public static final int DEFAULT_PUBLICATION_RETRANSMIT_COUNT = 0;
    public static final int DEFAULT_PUBLICATION_RETRANSMIT_INTERVAL_STEPS = 0;
    public static final Parcelable.Creator<PublicationSettings> CREATOR = new Parcelable.Creator<PublicationSettings>(){

        public PublicationSettings createFromParcel(Parcel parcel) {
            return new PublicationSettings(parcel, null);
        }

        public PublicationSettings[] newArray(int n) {
            return new PublicationSettings[n];
        }
    };
    public byte[] publishAddress;
    public int appKeyIndex;
    public boolean credentialFlag;
    public int publishTtl = 127;
    public int publicationSteps = 0;
    public int publicationResolution = 0;
    public int publishRetransmitCount = 0;
    public int publishRetransmitIntervalSteps = 0;

    public PublicationSettings() {
    }

    public PublicationSettings(byte[] byArray, int n, boolean bl, int n2, int n3) {
        this(byArray, n, bl, 127, 0, 0, 0, 0);
    }

    public PublicationSettings(byte[] byArray, int n, boolean bl, int n2, int n3, int n4, int n5, int n6) {
        this.publishAddress = byArray;
        this.appKeyIndex = n;
        this.credentialFlag = bl;
        this.publishTtl = n2;
        this.publicationSteps = n3;
        this.publicationResolution = n4;
        this.publishRetransmitCount = n5;
        this.publishRetransmitIntervalSteps = n6;
    }

    public PublicationSettings(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, int n5, int n6) {
        this.publishAddress = byArray;
        this.appKeyIndex = ByteBuffer.wrap(byArray2).order(ByteOrder.BIG_ENDIAN).getShort();
        boolean bl = n == 1;
        PublicationSettings publicationSettings = this;
        publicationSettings.credentialFlag = bl;
        publicationSettings.publishTtl = n2;
        publicationSettings.publicationSteps = n3;
        publicationSettings.publicationResolution = n4;
        publicationSettings.publishRetransmitCount = n5;
        publicationSettings.publishRetransmitIntervalSteps = n6;
    }

    public PublicationSettings(Parcel parcel) {
        this.publishAddress = parcel.createByteArray();
        this.appKeyIndex = parcel.readInt();
        boolean bl = parcel.readInt() == 1;
        this.credentialFlag = bl;
        this.publishTtl = parcel.readInt();
        this.publicationSteps = parcel.readInt();
        this.publicationResolution = parcel.readInt();
        this.publishRetransmitCount = parcel.readInt();
        this.publishRetransmitIntervalSteps = parcel.readInt();
    }

    public /* synthetic */ PublicationSettings(Parcel parcel, OooO00o oooO00o) {
        this(parcel);
    }

    public byte[] getPublishAddress() {
        return this.publishAddress;
    }

    public void setPublishAddress(byte[] byArray) {
        this.publishAddress = byArray;
    }

    public int getAppKeyIndex() {
        return this.appKeyIndex;
    }

    public void setAppKeyIndex(int n) {
        this.appKeyIndex = n;
    }

    public boolean getCredentialFlag() {
        return this.credentialFlag;
    }

    public void setCredentialFlag(boolean bl) {
        this.credentialFlag = bl;
    }

    public int getPublishTtl() {
        return this.publishTtl & 0xFF;
    }

    public void setPublishTtl(int n) {
        this.publishTtl = n;
    }

    public int getPublishRetransmitCount() {
        return this.publishRetransmitCount;
    }

    public void setPublishRetransmitCount(int n) {
        this.publishRetransmitCount = n;
    }

    public int getPublishRetransmitIntervalSteps() {
        return this.publishRetransmitIntervalSteps;
    }

    public void setPublishRetransmitIntervalSteps(int n) {
        this.publishRetransmitIntervalSteps = n;
    }

    public int getPublicationSteps() {
        return this.publicationSteps;
    }

    public void setPublicationSteps(int n) {
        this.publicationSteps = n;
    }

    public int getPublicationResolution() {
        return this.publicationResolution;
    }

    public void setPublicationResolution(int n) {
        this.publicationResolution = n;
    }

    public int calculatePublicationPeriod() {
        return this.publicationSteps << 6 | this.publicationResolution;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeByteArray(this.publishAddress);
        parcel.writeInt(this.appKeyIndex);
        parcel.writeInt(this.credentialFlag ? 1 : 0);
        parcel.writeInt(this.publishTtl);
        parcel.writeInt(this.publicationSteps);
        parcel.writeInt(this.publicationResolution);
        parcel.writeInt(this.publishRetransmitCount);
        parcel.writeInt(this.publishRetransmitIntervalSteps);
    }
}

