/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.sigmesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import com.tuya.sdk.bluetooth.o00oo0OO;
import com.tuya.sdk.sigmesh.transport.ApplicationKey;
import com.tuya.sdk.sigmesh.util.PublicationSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class MeshModel
implements Parcelable {
    public final List<Integer> mBoundAppKeyIndexes;
    public final Map<Integer, String> mBoundAppKeys;
    public final Map<Integer, ApplicationKey> mBoundApplicationKeys;
    public final List<byte[]> mSubscriptionAddress;
    public int mModelId;
    public PublicationSettings mPublicationSettings;

    public MeshModel(int n) {
        ArrayList arrayList;
        LinkedHashMap linkedHashMap;
        LinkedHashMap linkedHashMap2;
        ArrayList arrayList2;
        Object object = arrayList2;
        arrayList2 = new ArrayList();
        v1.mBoundAppKeyIndexes = object;
        object = linkedHashMap2;
        linkedHashMap2 = new LinkedHashMap();
        v1.mBoundAppKeys = object;
        object = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        v1.mBoundApplicationKeys = object;
        object = arrayList;
        arrayList = new ArrayList();
        v1.mSubscriptionAddress = object;
        v1.mModelId = n;
    }

    public MeshModel() {
        ArrayList arrayList;
        LinkedHashMap linkedHashMap;
        LinkedHashMap linkedHashMap2;
        ArrayList arrayList2;
        Object object = arrayList2;
        arrayList2 = new ArrayList();
        v1.mBoundAppKeyIndexes = object;
        object = linkedHashMap2;
        linkedHashMap2 = new LinkedHashMap();
        v1.mBoundAppKeys = object;
        object = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        v1.mBoundApplicationKeys = object;
        object = arrayList;
        arrayList = new ArrayList();
        v1.mSubscriptionAddress = object;
    }

    public MeshModel(Parcel parcel) {
        ArrayList<byte[]> arrayList;
        LinkedHashMap linkedHashMap;
        LinkedHashMap linkedHashMap2;
        ArrayList<Integer> arrayList2;
        ArrayList<byte[]> arrayList3 = arrayList2;
        arrayList2 = new ArrayList<Integer>();
        this.mBoundAppKeyIndexes = arrayList3;
        arrayList3 = linkedHashMap2;
        linkedHashMap2 = new LinkedHashMap();
        this.mBoundAppKeys = arrayList3;
        arrayList3 = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        this.mBoundApplicationKeys = arrayList3;
        arrayList3 = arrayList;
        arrayList = new ArrayList<byte[]>();
        this.mSubscriptionAddress = arrayList3;
        int n = parcel.readInt();
        this.mModelId = n >= Short.MIN_VALUE && n <= Short.MAX_VALUE ? (int)((short)n) : n;
        Parcel parcel2 = parcel;
        parcel2.readList(this.mBoundAppKeyIndexes, Integer.class.getClassLoader());
        this.sortAppKeys(parcel2.readHashMap(ApplicationKey.class.getClassLoader()));
        try {
            this.mPublicationSettings = (PublicationSettings)parcel.readValue(PublicationSettings.class.getClassLoader());
            parcel.readList(this.mSubscriptionAddress, byte[].class.getClassLoader());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void sortAppKeys(HashMap<Integer, ApplicationKey> hashMap) {
        Object object = hashMap.keySet();
        ArrayList<Integer> arrayList = new ArrayList<Integer>((Collection<Integer>)object);
        Collections.sort(arrayList);
        object = arrayList.iterator();
        while (object.hasNext()) {
            int n;
            int n2 = n = ((Integer)object.next()).intValue();
            Integer n3 = n2;
            this.mBoundApplicationKeys.put(n3, hashMap.get(n2));
        }
    }

    private boolean checkIfAlreadySubscribed(byte[] byArray) {
        Iterator<byte[]> iterator = ((MeshModel)((Object)iterator)).mSubscriptionAddress.iterator();
        while (iterator.hasNext()) {
            if (!Arrays.equals((byte[])iterator.next(), byArray)) continue;
            return true;
        }
        return false;
    }

    private int getIndex(byte[] byArray) {
        int n = 0;
        Iterator<byte[]> iterator = this.mSubscriptionAddress.iterator();
        while (iterator.hasNext()) {
            if (Arrays.equals(iterator.next(), byArray)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public final void parcelMeshModel(Parcel parcel, int n) {
        parcel.writeInt(this.mModelId);
        parcel.writeList(this.mBoundAppKeyIndexes);
        parcel.writeMap(this.mBoundApplicationKeys);
        parcel.writeValue((Object)this.mPublicationSettings);
        parcel.writeList(this.mSubscriptionAddress);
    }

    public abstract int getModelId();

    public abstract String getModelName();

    public List<Integer> getBoundAppKeyIndexes() {
        return Collections.unmodifiableList(this.mBoundAppKeyIndexes);
    }

    public void setBoundAppKey(int n, ApplicationKey applicationKey) {
        if (!this.mBoundAppKeyIndexes.contains(n)) {
            this.mBoundAppKeyIndexes.add(n);
        }
        this.mBoundApplicationKeys.put(n, applicationKey);
    }

    public void removeBoundAppKey(int n) {
        if (this.mBoundAppKeyIndexes.contains(n)) {
            MeshModel meshModel = this;
            int n2 = meshModel.mBoundAppKeyIndexes.indexOf(n);
            meshModel.mBoundAppKeyIndexes.remove(n2);
        }
        this.mBoundApplicationKeys.remove(n);
    }

    @Deprecated
    public Map<Integer, String> getBoundAppkeys() {
        return Collections.unmodifiableMap(this.mBoundAppKeys);
    }

    public Map<Integer, ApplicationKey> getBoundApplicationKeys() {
        return this.mBoundApplicationKeys;
    }

    public ApplicationKey getBoundAppKey(int n) {
        return this.mBoundApplicationKeys.get(n);
    }

    public List<byte[]> getSubscriptionAddresses() {
        return Collections.unmodifiableList(this.mSubscriptionAddress);
    }

    public boolean hasGroupAddresses() {
        Iterator<byte[]> iterator = ((MeshModel)((Object)iterator)).mSubscriptionAddress.iterator();
        while (iterator.hasNext()) {
            if (!o00oo0OO.OooOo0O((byte[])iterator.next())) continue;
            return true;
        }
        return false;
    }

    public List<byte[]> getGroupAddresses() {
        ArrayList arrayList;
        MeshModel meshModel = arrayList2;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        for (byte[] byArray : meshModel.mSubscriptionAddress) {
            if (!o00oo0OO.OooOo0O(byArray)) continue;
            arrayList2.add(byArray);
        }
        return arrayList2;
    }

    public List<byte[]> getNonGroupAddresses() {
        ArrayList arrayList;
        MeshModel meshModel = arrayList2;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        for (byte[] byArray : meshModel.mSubscriptionAddress) {
            if (o00oo0OO.OooOo0O(byArray)) continue;
            arrayList2.add(byArray);
        }
        return arrayList2;
    }

    public PublicationSettings getPublicationSettings() {
        return this.mPublicationSettings;
    }

    public void addSubscriptionAddress(byte[] byArray) {
        if (byArray != null && !this.checkIfAlreadySubscribed(byArray)) {
            this.mSubscriptionAddress.add(byArray);
        }
    }

    public void removeSubscriptionAddress(byte[] byArray) {
        int n;
        if (byArray != null && (n = this.getIndex(byArray)) > -1) {
            this.mSubscriptionAddress.remove(n);
        }
    }
}

