/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.sigmesh.provisioner;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.tuya.sdk.bluetooth.o00oO0O0;
import com.tuya.sdk.bluetooth.o00oo0OO;
import com.tuya.sdk.bluetooth.o0O00000;
import com.tuya.sdk.sigmesh.bean.AccessMessage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class LightLightnessStatus
extends o00oO0O0
implements Parcelable {
    public static final String TAG = LightLightnessStatus.class.getSimpleName();
    public static final int LIGHT_LIGHTNESS_STATUS_MANDATORY_LENGTH = 2;
    public static final int OP_CODE = 33358;
    public static final Parcelable.Creator<LightLightnessStatus> CREATOR = new Parcelable.Creator<LightLightnessStatus>(){

        public LightLightnessStatus createFromParcel(Parcel parcel) {
            AccessMessage accessMessage = (AccessMessage)parcel.readValue(AccessMessage.class.getClassLoader());
            return new LightLightnessStatus(accessMessage);
        }

        public LightLightnessStatus[] newArray(int n) {
            return new LightLightnessStatus[n];
        }
    };
    public int mPresentLightness;
    public Integer mTargetLightness;
    public int mTransitionSteps;
    public int mTransitionResolution;

    public LightLightnessStatus(@NonNull AccessMessage accessMessage) {
        super(accessMessage);
        this.mMessage = accessMessage;
        this.mParameters = accessMessage.getParameters();
        this.parseStatusParameters();
    }

    @Override
    public void parseStatusParameters() {
        o0O00000.OooO0Oo(TAG, "Received light lightness status from: " + o00oo0OO.OooO00o(this.mMessage.getSrc(), true));
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.mParameters).order(ByteOrder.LITTLE_ENDIAN);
        this.mPresentLightness = byteBuffer.getShort() & 0xFFFF;
        o0O00000.OooO0Oo(TAG, "Present level: " + this.mPresentLightness);
        if (byteBuffer.limit() > 2) {
            this.mTargetLightness = byteBuffer.getShort() & 0xFFFF;
            int n = byteBuffer.get() & 0xFF;
            this.mTransitionSteps = n & 0x3F;
            this.mTransitionResolution = n >> 6;
            o0O00000.OooO0Oo(TAG, "Target level: " + this.mTargetLightness);
            o0O00000.OooO0Oo(TAG, "Remaining time, transition number of steps: " + this.mTransitionSteps);
            o0O00000.OooO0Oo(TAG, "Remaining time, transition number of step resolution: " + this.mTransitionResolution);
            o0O00000.OooO0Oo(TAG, "Remaining time: " + o00oo0OO.OooO0O0(n));
        }
    }

    @Override
    public int getOpCode() {
        return 33358;
    }

    public final int getPresentLightness() {
        return this.mPresentLightness;
    }

    public final Integer getTargetLightness() {
        return this.mTargetLightness;
    }

    public int getTransitionSteps() {
        return this.mTransitionSteps;
    }

    public int getTransitionResolution() {
        return this.mTransitionResolution;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeValue((Object)this.mMessage);
    }
}

