/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.sigmesh.provisioner;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import com.tuya.sdk.bluetooth.o00oO0O0;
import com.tuya.sdk.bluetooth.o00oo0OO;
import com.tuya.sdk.bluetooth.o0O00000;
import com.tuya.sdk.sigmesh.bean.AccessMessage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class LightHslStatus
extends o00oO0O0
implements Parcelable {
    public static final String TAG = LightHslStatus.class.getSimpleName();
    public static final int LIGHT_CTL_STATUS_MANDATORY_LENGTH = 6;
    public static final int OP_CODE = 33400;
    public static final Parcelable.Creator<LightHslStatus> CREATOR = new Parcelable.Creator<LightHslStatus>(){

        public LightHslStatus createFromParcel(Parcel parcel) {
            AccessMessage accessMessage = (AccessMessage)parcel.readValue(AccessMessage.class.getClassLoader());
            return new LightHslStatus(accessMessage);
        }

        public LightHslStatus[] newArray(int n) {
            return new LightHslStatus[n];
        }
    };
    public int mPresentHslLightness;
    public int mPresentHslHue;
    public int mPresentHslSaturation;
    public int mTransitionSteps;
    public int mTransitionResolution;

    public LightHslStatus(@NonNull AccessMessage accessMessage) {
        super(accessMessage);
        this.mMessage = accessMessage;
        this.mParameters = accessMessage.getParameters();
        this.parseStatusParameters();
    }

    @Override
    public void parseStatusParameters() {
        o0O00000.OooO0Oo(TAG, "Received light hsl status from: " + o00oo0OO.OooO00o(this.mMessage.getSrc(), true));
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.mParameters).order(ByteOrder.LITTLE_ENDIAN);
        this.mPresentHslLightness = byteBuffer.getShort() & 0xFFFF;
        this.mPresentHslHue = byteBuffer.getShort() & 0xFFFF;
        this.mPresentHslSaturation = byteBuffer.getShort() & 0xFFFF;
        o0O00000.OooO0Oo(TAG, "Present lightness: " + this.mPresentHslLightness + " Present hue: " + this.mPresentHslHue);
        o0O00000.OooO0Oo(TAG, "Present saturation: " + this.mPresentHslSaturation);
        if (byteBuffer.limit() > 6) {
            int n = byteBuffer.get() & 0xFF;
            this.mTransitionSteps = n & 0x3F;
            this.mTransitionResolution = n >> 6;
            Log.v((String)TAG, (String)("Remaining time, transition number of steps: " + this.mTransitionSteps));
            Log.v((String)TAG, (String)("Remaining time, transition number of step resolution: " + this.mTransitionResolution));
            Log.v((String)TAG, (String)("Remaining time: " + o00oo0OO.OooO0O0(n)));
        }
    }

    @Override
    public int getOpCode() {
        return 33400;
    }

    public final int getPresentLightness() {
        return this.mPresentHslLightness;
    }

    public final int getPresentSaturation() {
        return this.mPresentHslSaturation;
    }

    public final int getPresentHue() {
        return this.mPresentHslHue;
    }

    public int getTransitionSteps() {
        return this.mTransitionSteps;
    }

    public int getTransitionResolution() {
        return this.mTransitionResolution;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeValue((Object)this.mMessage);
    }
}

