/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.sigmesh.provisioner;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.tuya.sdk.bluetooth.o00oO0O0;
import com.tuya.sdk.bluetooth.o00oo0OO;
import com.tuya.sdk.bluetooth.o0O00000;
import com.tuya.sdk.sigmesh.bean.AccessMessage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class LightCtlTemperatureStatus
extends o00oO0O0
implements Parcelable {
    public static final String TAG = "LightCtlTemperatureStatus";
    public static final int LIGHT_CTL_STATUS_MANDATORY_LENGTH = 4;
    public static final int OP_CODE = 33382;
    public static final Parcelable.Creator<LightCtlTemperatureStatus> CREATOR = new Parcelable.Creator<LightCtlTemperatureStatus>(){

        public LightCtlTemperatureStatus createFromParcel(Parcel parcel) {
            AccessMessage accessMessage = (AccessMessage)parcel.readValue(AccessMessage.class.getClassLoader());
            return new LightCtlTemperatureStatus(accessMessage);
        }

        public LightCtlTemperatureStatus[] newArray(int n) {
            return new LightCtlTemperatureStatus[n];
        }
    };
    public int mPresentCtlTemperature;
    public int mPresentDeltaUv;
    public Integer mTargetCtlTemperature;
    public Integer mTargetDeltaUv;
    public int mTransitionSteps;
    public int mTransitionResolution;

    public LightCtlTemperatureStatus(@NonNull AccessMessage accessMessage) {
        super(accessMessage);
        this.mMessage = accessMessage;
        this.mParameters = accessMessage.getParameters();
        this.parseStatusParameters();
    }

    @Override
    public void parseStatusParameters() {
        o0O00000.OooO0Oo(TAG, "Received light ctl status from: " + o00oo0OO.OooO00o(this.mMessage.getSrc(), true));
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.mParameters).order(ByteOrder.LITTLE_ENDIAN);
        this.mPresentCtlTemperature = byteBuffer.getShort() & 0xFFFF;
        this.mPresentDeltaUv = byteBuffer.getShort() & 0xFFFF;
        o0O00000.OooO0Oo(TAG, "Present deltaUv: " + this.mPresentDeltaUv);
        o0O00000.OooO0Oo(TAG, "Present temperature: " + this.mPresentCtlTemperature);
        if (byteBuffer.limit() > 4) {
            this.mTargetCtlTemperature = byteBuffer.getShort() & 0xFFFF;
            this.mTargetDeltaUv = byteBuffer.getShort() & 0xFFFF;
            int n = byteBuffer.get() & 0xFF;
            this.mTransitionSteps = n & 0x3F;
            this.mTransitionResolution = n >> 6;
            o0O00000.OooO0Oo(TAG, "Target temperature: " + this.mTargetCtlTemperature);
            o0O00000.OooO0Oo(TAG, "Target deltaUv: " + this.mTargetDeltaUv);
        }
    }

    @Override
    public int getOpCode() {
        return 33382;
    }

    public final int getPresentTemperature() {
        return this.mPresentCtlTemperature;
    }

    public final Integer getTargetTemperature() {
        return this.mTargetCtlTemperature;
    }

    public int getTransitionSteps() {
        return this.mTransitionSteps;
    }

    public int getTransitionResolution() {
        return this.mTransitionResolution;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeValue((Object)this.mMessage);
    }
}

