/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.sigmesh.provisioner;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.tuya.sdk.bluetooth.o00oO0O0;
import com.tuya.sdk.bluetooth.o00oo0OO;
import com.tuya.sdk.bluetooth.o00oooo0;
import com.tuya.sdk.bluetooth.o0O00000;
import com.tuya.sdk.sigmesh.bean.AccessMessage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class GenericOnOffStatus
extends o00oO0O0
implements Parcelable {
    public static final String TAG = GenericOnOffStatus.class.getSimpleName();
    public static final int OP_CODE = 33284;
    public static final int GENERIC_ON_OFF_STATE_ON = 1;
    public static final Parcelable.Creator<GenericOnOffStatus> CREATOR = new Parcelable.Creator<GenericOnOffStatus>(){

        public GenericOnOffStatus createFromParcel(Parcel parcel) {
            AccessMessage accessMessage = (AccessMessage)parcel.readValue(AccessMessage.class.getClassLoader());
            return new GenericOnOffStatus(accessMessage);
        }

        public GenericOnOffStatus[] newArray(int n) {
            return new GenericOnOffStatus[n];
        }
    };
    public boolean mPresentOn;
    public Boolean mTargetOn;
    public int mRemainingTime;
    public int mTransitionSteps;
    public int mTransitionResolution;

    public GenericOnOffStatus(@NonNull AccessMessage accessMessage) {
        super(accessMessage);
        this.mParameters = accessMessage.getParameters();
        this.parseStatusParameters();
    }

    @Override
    public void parseStatusParameters() {
        o0O00000.OooO0Oo(TAG, "Received generic on off status from: " + o00oo0OO.OooO00o(this.mMessage.getSrc(), true) + "  parameter: " + o00oooo0.OooO00o(this.mMessage.getParameters(), ","));
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.mParameters).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.position(0);
        boolean bl = byteBuffer.get() == 1;
        this.mPresentOn = bl;
        o0O00000.OooO0Oo(TAG, "Present on: " + this.mPresentOn);
        if (byteBuffer.limit() > 1) {
            int n;
            Boolean bl2;
            this.mTargetOn = bl2 = Boolean.valueOf(byteBuffer.get() == 1);
            this.mRemainingTime = n = byteBuffer.get() & 0xFF;
            this.mTransitionSteps = n & 0x3F;
            this.mTransitionResolution = n >> 6;
            o0O00000.OooO0Oo(TAG, "Target on: " + this.mTargetOn);
            o0O00000.OooO0Oo(TAG, "Remaining time, transition number of steps: " + this.mTransitionSteps);
            o0O00000.OooO0Oo(TAG, "Remaining time, transition number of step resolution: " + this.mTransitionResolution);
            o0O00000.OooO0Oo(TAG, "Remaining time: " + o00oo0OO.OooO0O0(this.mRemainingTime));
        }
    }

    @Override
    public int getOpCode() {
        return 33284;
    }

    public final boolean getPresentState() {
        return this.mPresentOn;
    }

    public final Boolean getTargetState() {
        return this.mTargetOn;
    }

    public int getTransitionSteps() {
        return this.mTransitionSteps;
    }

    public int getTransitionResolution() {
        return this.mTransitionResolution;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeValue((Object)this.mMessage);
    }
}

