/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.sigmesh.provisioner;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.tuya.sdk.bluetooth.o00oo0OO;
import com.tuya.sdk.bluetooth.o0O00000;
import com.tuya.sdk.sigmesh.bean.AccessMessage;
import com.tuya.sdk.sigmesh.transport.ConfigStatusMessage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ConfigModelPublicationStatus
extends ConfigStatusMessage
implements Parcelable {
    public static final String TAG = ConfigModelPublicationStatus.class.getSimpleName();
    public static final int OP_CODE = 32830;
    public static final int CONFIG_MODEL_PUBLICATION_STATUS_SIG_MODEL_PDU_LENGTH = 12;
    public static final int CONFIG_MODEL_APP_BIND_STATUS_VENDOR_MODEL_PDU_LENGTH = 14;
    public static final Parcelable.Creator<ConfigModelPublicationStatus> CREATOR = new Parcelable.Creator<ConfigModelPublicationStatus>(){

        public ConfigModelPublicationStatus createFromParcel(Parcel parcel) {
            AccessMessage accessMessage = (AccessMessage)parcel.readValue(AccessMessage.class.getClassLoader());
            return new ConfigModelPublicationStatus(accessMessage);
        }

        public ConfigModelPublicationStatus[] newArray(int n) {
            return new ConfigModelPublicationStatus[n];
        }
    };
    public int mElementAddress;
    public byte[] publishAddress;
    public int mAppKeyIndex;
    public boolean credentialFlag;
    public int publishTtl;
    public int publicationSteps;
    public int publicationResolution;
    public int publishRetransmitCount;
    public int publishRetransmitIntervalSteps;
    public int mModelIdentifier;

    public ConfigModelPublicationStatus(@NonNull AccessMessage accessMessage) {
        super(accessMessage);
        this.mParameters = accessMessage.getParameters();
        this.parseStatusParameters();
    }

    @Override
    public void parseStatusParameters() {
        byte[] byArray;
        int n;
        ConfigModelPublicationStatus configModelPublicationStatus = this;
        ByteBuffer.wrap(((AccessMessage)configModelPublicationStatus.mMessage).getParameters()).order(ByteOrder.LITTLE_ENDIAN);
        configModelPublicationStatus.mStatusCode = n = configModelPublicationStatus.mParameters[0];
        configModelPublicationStatus.mStatusCodeName = configModelPublicationStatus.getStatusCodeName(n);
        byte[] byArray2 = new byte[2];
        byte[] byArray3 = byArray2;
        byArray3[0] = this.mParameters[2];
        byArray2[1] = this.mParameters[1];
        configModelPublicationStatus.mElementAddress = ByteBuffer.wrap(byArray2).order(ByteOrder.BIG_ENDIAN).getShort();
        byte[] byArray4 = new byte[2];
        byte[] byArray5 = byArray4;
        byte[] byArray6 = this.mParameters;
        byArray5[0] = byArray6[4];
        byArray4[1] = this.mParameters[3];
        configModelPublicationStatus.publishAddress = byArray4;
        byte[] byArray7 = new byte[2];
        byArray5 = byArray7;
        byArray5[0] = (byte)(byArray6[6] & 0xF);
        byArray7[1] = byArray6[5];
        configModelPublicationStatus.mAppKeyIndex = ByteBuffer.wrap(byArray7).order(ByteOrder.BIG_ENDIAN).getShort();
        boolean bl = (configModelPublicationStatus.mParameters[6] & 0xF0) >> 4 == 1;
        ConfigModelPublicationStatus configModelPublicationStatus2 = this;
        configModelPublicationStatus2.credentialFlag = bl;
        byte[] byArray8 = configModelPublicationStatus2.mParameters;
        this.publishTtl = byArray8[7];
        byte by = byArray8[8];
        this.publicationSteps = by >> 6;
        this.publicationResolution = by & 3;
        this.publishRetransmitCount = byArray8[9] >> 5;
        configModelPublicationStatus2.publishRetransmitIntervalSteps = configModelPublicationStatus2.mParameters[9] & 0x1F;
        if (byArray8.length == 12) {
            byte[] byArray9 = new byte[2];
            byArray = byArray9;
            byArray[0] = byArray8[11];
            byArray9[1] = byArray8[10];
            this.mModelIdentifier = ByteBuffer.wrap(byArray9).order(ByteOrder.BIG_ENDIAN).getShort();
        } else {
            byte[] byArray10 = new byte[4];
            byArray = byArray10;
            byArray[0] = byArray8[11];
            byArray[1] = byArray8[10];
            byArray[2] = byArray8[13];
            byArray10[3] = byArray8[12];
            this.mModelIdentifier = ByteBuffer.wrap(byArray10).order(ByteOrder.BIG_ENDIAN).getInt();
        }
        o0O00000.OooO0Oo(TAG, "Status code: " + this.mStatusCode);
        o0O00000.OooO0Oo(TAG, "Status message: " + this.mStatusCodeName);
        o0O00000.OooO0Oo(TAG, "Element address: " + o00oo0OO.OooO00o(byArray3, false));
        o0O00000.OooO0Oo(TAG, "Publish Address: " + o00oo0OO.OooO00o(this.publishAddress, false));
        o0O00000.OooO0Oo(TAG, "App key index: " + o00oo0OO.OooO00o(byArray5, false));
        o0O00000.OooO0Oo(TAG, "Credential Flag: " + this.credentialFlag);
        o0O00000.OooO0Oo(TAG, "Publish TTL: " + this.publishTtl);
        o0O00000.OooO0Oo(TAG, "Publish Period: " + by);
        o0O00000.OooO0Oo(TAG, "Publish Retransmit Count: " + this.publishRetransmitCount);
        o0O00000.OooO0Oo(TAG, "Publish Publish Interval Steps: " + this.publishRetransmitIntervalSteps);
        o0O00000.OooO0Oo(TAG, "Model Identifier: " + o00oo0OO.OooO00o(byArray, false));
    }

    @Override
    public int getOpCode() {
        return 32830;
    }

    public int getElementAddress() {
        return this.mElementAddress;
    }

    public final int getAppKeyIndex() {
        return this.mAppKeyIndex;
    }

    public boolean isSuccessful() {
        return this.mStatusCode == 0;
    }

    public byte[] getPublishAddress() {
        return this.publishAddress;
    }

    public boolean getCredentialFlag() {
        return this.credentialFlag;
    }

    public int getPublishTtl() {
        return this.publishTtl;
    }

    public int getPublicationSteps() {
        return this.publicationSteps;
    }

    public int getPublicationResolution() {
        return this.publicationResolution;
    }

    public int getPublishRetransmitCount() {
        return this.publishRetransmitCount;
    }

    public int getPublishRetransmitIntervalSteps() {
        return this.publishRetransmitIntervalSteps;
    }

    public int getModelIdentifier() {
        return this.mModelIdentifier;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeValue((Object)this.mMessage);
    }
}

