/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blescan;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.tuya.sdk.blelib.search.SearchRequest;
import com.tuya.sdk.blescan.BleScanner;
import com.tuya.sdk.blescan.FilterTypeEnum;
import com.tuya.sdk.blescan.ITuyaBleScanner;
import com.tuya.sdk.blescan.LeScanResponse;
import com.tuya.sdk.blescan.ScanCache;
import com.tuya.sdk.blescan.ScanLeBean;
import com.tuya.sdk.blescan.ScanRequest;
import com.tuya.sdk.blescan.utils.SafeHandler;
import com.tuya.sdk.blescan.utils.ScanLog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;

public class TuyaBleScanner
implements Handler.Callback,
LeScanResponse,
ITuyaBleScanner {
    public static final String TAG = "TuyaBleScanner";
    public static final int TIME_OUT_SCAN = -1;
    public static final long WAIT_TIME = 2000L;
    public static volatile TuyaBleScanner mTuyaBleScanner;
    public final CopyOnWriteArrayList<ScanRequest> requestList;
    public SafeHandler mHandler;
    public BleScanner iBleScanner;
    public long lastStopTime = 0L;

    public TuyaBleScanner(Context context) {
        this.iBleScanner = new BleScanner(context);
        this.requestList = new CopyOnWriteArrayList();
        this.mHandler = new SafeHandler(Looper.getMainLooper(), (Handler.Callback)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ITuyaBleScanner newInstance(Context context) {
        if (mTuyaBleScanner != null) return mTuyaBleScanner;
        Class<TuyaBleScanner> clazz = TuyaBleScanner.class;
        synchronized (TuyaBleScanner.class) {
            block6: {
                if (mTuyaBleScanner != null) return mTuyaBleScanner;
                if (!(context instanceof Activity)) break block6;
                context = context.getApplicationContext();
            }
            mTuyaBleScanner = new TuyaBleScanner(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mTuyaBleScanner;
        }
    }

    private void startRequest(ScanRequest scanRequest) {
        TuyaBleScanner tuyaBleScanner = this;
        tuyaBleScanner.start(scanRequest);
        ScanLog.i(TAG, "addScanRequest: request = " + scanRequest + ", time = " + scanRequest.getDuration() + ",size = " + this.requestList.size());
        tuyaBleScanner.iBleScanner.startLeScan(this.getDefaultSearchRequest(), this);
    }

    private void start(ScanRequest scanRequest) {
        Message message;
        TuyaBleScanner tuyaBleScanner = tuyaBleScanner2;
        tuyaBleScanner2.requestList.add(scanRequest);
        scanRequest.getResponse().onScanStart();
        TuyaBleScanner tuyaBleScanner2 = message;
        tuyaBleScanner2();
        message.obj = scanRequest;
        message.what = 0;
        tuyaBleScanner.mHandler.sendMessageDelayed((Message)tuyaBleScanner2, scanRequest.getDuration());
    }

    private void restart(ScanRequest scanRequest) {
        Message message;
        TuyaBleScanner tuyaBleScanner = tuyaBleScanner2;
        tuyaBleScanner.mHandler.removeMessages(0, scanRequest);
        TuyaBleScanner tuyaBleScanner2 = message;
        tuyaBleScanner2();
        message.obj = scanRequest;
        message.what = 0;
        tuyaBleScanner.mHandler.sendMessageDelayed((Message)tuyaBleScanner2, scanRequest.getDuration());
    }

    private synchronized void removeOneRequest(ScanRequest scanRequest, boolean bl) {
        if (bl) {
            scanRequest.getResponse().onScanStop();
        } else {
            scanRequest.getResponse().onScanCancel();
        }
        TuyaBleScanner tuyaBleScanner = this;
        tuyaBleScanner.requestList.remove(scanRequest);
        if (tuyaBleScanner.requestList.size() == 0) {
            ScanLog.i(TAG, "removeOneRequest requestList isEmpty");
            this.stopScan();
        }
    }

    private synchronized void clearAllRequest() {
        ArrayList<ScanRequest> arrayList;
        this.mHandler.removeCallbacksAndMessages(null);
        ArrayList<ScanRequest> arrayList2 = arrayList;
        Iterator iterator = new ArrayList<ScanRequest>(this.requestList).iterator();
        while (iterator.hasNext()) {
            ((ScanRequest)iterator.next()).getResponse().onScanCancel();
        }
        this.requestList.clear();
        arrayList2.clear();
    }

    private SearchRequest getDefaultSearchRequest() {
        return new SearchRequest.Builder().searchBluetoothLeDevice(-1).build();
    }

    private void notifyDeviceResponse(ScanLeBean scanLeBean) {
        for (ScanRequest scanRequest : this.requestList) {
            if (!this.filterRequestTask(scanRequest, scanLeBean)) continue;
            TuyaBleScanner tuyaBleScanner = this;
            tuyaBleScanner.requestList.remove(scanRequest);
            tuyaBleScanner.mHandler.removeMessages(0, scanRequest);
            if (tuyaBleScanner.requestList.size() != 0) continue;
            this.stopScan();
        }
    }

    private boolean filterRequestTask(ScanRequest scanRequest, ScanLeBean scanLeBean) {
        if (scanRequest.getScanFilter() != null) {
            if (scanRequest.getScanFilter().filter(scanLeBean)) {
                ScanCache.INSTANCE.add(scanLeBean);
                boolean bl = scanRequest.getScanFilter().filterOnly(scanLeBean);
                scanRequest.getResponse().onDeviceFounded(scanLeBean);
                if (bl) {
                    scanRequest.getResponse().onScanStop();
                    return true;
                }
            }
        } else {
            scanRequest.getResponse().onDeviceFounded(scanLeBean);
        }
        return false;
    }

    private boolean cacheFilter(ScanRequest scanRequest) {
        boolean bl = false;
        Iterator<ScanLeBean> iterator = ScanCache.INSTANCE.getCacheBeanList().iterator();
        while (iterator.hasNext() && !(bl = this.filterRequestTask(scanRequest, iterator.next()))) {
        }
        return bl;
    }

    @Override
    public synchronized void addScanRequest(final ScanRequest scanRequest) {
        if (scanRequest == null) {
            return;
        }
        if (this.requestList.contains(scanRequest)) {
            this.restart(scanRequest);
            ScanLog.d(TAG, "addScanRequest: already have the task , request = " + scanRequest);
            return;
        }
        if (scanRequest.getType() == FilterTypeEnum.CLEAR) {
            this.clearAllRequest();
        } else if (scanRequest.getType() == FilterTypeEnum.CACHE && this.cacheFilter(scanRequest)) {
            return;
        }
        long l = System.currentTimeMillis() - this.lastStopTime;
        ScanLog.d(TAG, "startLeScan:  delta = " + l);
        if (l < 2000L) {
            TimerTask timerTask;
            TimerTask timerTask2 = timerTask;
            timerTask = new TimerTask(){

                @Override
                public void run() {
                    TuyaBleScanner.this.startRequest(scanRequest);
                }
            };
            long l2 = 2000L - l;
            new Timer().schedule(timerTask2, l2);
        } else {
            this.startRequest(scanRequest);
        }
    }

    @Override
    public synchronized void removeScanRequest(ScanRequest scanRequest) {
        ScanLog.d(TAG, "remove request " + scanRequest);
        if (scanRequest == null) {
            return;
        }
        if (this.requestList.contains(scanRequest)) {
            this.mHandler.removeMessages(0, scanRequest);
            this.removeOneRequest(scanRequest, false);
        }
    }

    public boolean handleMessage(Message message) {
        ScanLog.d(TAG, "handleMessage: msg.what = " + message.what + ", msg.obj = " + message.obj + ",size = " + this.requestList.size());
        this.removeOneRequest((ScanRequest)message.obj, true);
        ScanLog.d(TAG, "handleMessage2: msg.what = " + message.what + ", msg.obj = " + message.obj + ",remain size = " + this.requestList.size());
        return false;
    }

    @Override
    public void stopScan() {
        ScanLog.i(TAG, "stopScan");
        this.lastStopTime = System.currentTimeMillis();
        this.iBleScanner.stopLeScan();
    }

    @Override
    public void onScanStart() {
        ScanLog.d(TAG, "master onScanStart() called");
    }

    @Override
    public void onScanCancel() {
        ScanLog.d(TAG, "master onScanCancel() called");
        this.lastStopTime = System.currentTimeMillis();
        this.clearAllRequest();
    }

    @Override
    public void onScanStop() {
        ScanLog.d(TAG, "master onScanStop() called");
        this.lastStopTime = System.currentTimeMillis();
        this.clearAllRequest();
    }

    @Override
    public void clearCache() {
        ScanCache.INSTANCE.removeAll();
    }

    @Override
    public void onDeviceFounded(ScanLeBean scanLeBean) {
        this.notifyDeviceResponse(scanLeBean);
    }
}

