/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blescan;

import android.content.Context;
import com.tuya.sdk.blelib.BluetoothClient;
import com.tuya.sdk.blelib.search.SearchRequest;
import com.tuya.sdk.blelib.search.SearchResult;
import com.tuya.sdk.blelib.search.response.SearchResponse;
import com.tuya.sdk.blescan.LeScanResponse;
import com.tuya.sdk.blescan.ScanLeBean;
import com.tuya.sdk.blescan.utils.ScanLog;
import java.util.concurrent.atomic.AtomicBoolean;

public class BleScanner {
    public static final String TAG = "BleScanner";
    public BluetoothClient client;
    public LeScanResponse leScanResponse;
    public AtomicBoolean isScanning;

    public BleScanner(Context context) {
        BluetoothClient bluetoothClient;
        AtomicBoolean atomicBoolean;
        Object object = atomicBoolean;
        atomicBoolean = new AtomicBoolean(false);
        v1.isScanning = object;
        object = bluetoothClient;
        bluetoothClient = new BluetoothClient(context);
        v1.client = object;
    }

    private void startLeScan(SearchRequest object) {
        SearchResponse searchResponse;
        ScanLog.i(TAG, "startLeScan:  startLeScan  isScanning = " + this.isScanning.get());
        SearchRequest searchRequest = object;
        object = searchResponse;
        searchResponse = new SearchResponse(){

            @Override
            public void onSearchStarted() {
                1 v0 = this;
                v0.BleScanner.this.isScanning.set(true);
                v0.BleScanner.this.leScanResponse.onScanStart();
            }

            @Override
            public void onDeviceFounded(SearchResult searchResult) {
                BleScanner.this.leScanResponse.onDeviceFounded(BleScanner.this.convertBean(searchResult));
            }

            @Override
            public void onSearchStopped() {
                1 v0 = this;
                v0.BleScanner.this.isScanning.set(false);
                v0.BleScanner.this.leScanResponse.onScanStop();
            }

            @Override
            public void onSearchCanceled() {
                1 v0 = this;
                v0.BleScanner.this.isScanning.set(false);
                v0.BleScanner.this.leScanResponse.onScanCancel();
            }
        };
        this.client.search(searchRequest, (SearchResponse)object);
    }

    private ScanLeBean convertBean(SearchResult searchResult) {
        ScanLeBean scanLeBean;
        ScanLeBean scanLeBean2 = scanLeBean;
        scanLeBean2();
        scanLeBean2.rssi = searchResult.rssi;
        scanLeBean2.address = searchResult.getAddress();
        scanLeBean2.device = searchResult.device;
        scanLeBean2.name = searchResult.getName();
        scanLeBean.scanRecord = searchResult.scanRecord;
        return scanLeBean;
    }

    public void startLeScan(SearchRequest searchRequest, LeScanResponse leScanResponse) {
        if (this.isScanning.getAndSet(true)) {
            ScanLog.e(TAG, "startLeScan: already scanning");
            return;
        }
        this.leScanResponse = leScanResponse;
        this.startLeScan(searchRequest);
    }

    public void stopLeScan() {
        BleScanner bleScanner = this;
        bleScanner.isScanning.set(false);
        bleScanner.client.stopSearch();
    }
}

