/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.utils.proxy;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.tuya.sdk.blelib.utils.BluetoothLog;
import com.tuya.sdk.blelib.utils.proxy.ProxyBulk;
import com.tuya.sdk.blelib.utils.proxy.ProxyInterceptor;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class ProxyInvocationHandler
implements InvocationHandler,
ProxyInterceptor,
Handler.Callback {
    public Object subject;
    public ProxyInterceptor interceptor;
    public boolean weakRef;
    public boolean postUI;
    public Handler handler;

    public ProxyInvocationHandler(Object object) {
        this(object, null);
    }

    public ProxyInvocationHandler(Object object, ProxyInterceptor proxyInterceptor) {
        this(object, proxyInterceptor, false);
    }

    public ProxyInvocationHandler(Object object, ProxyInterceptor proxyInterceptor, boolean bl) {
        this(object, proxyInterceptor, bl, false);
    }

    public ProxyInvocationHandler(Object object, ProxyInterceptor proxyInterceptor, boolean bl, boolean bl2) {
        this.weakRef = bl;
        this.interceptor = proxyInterceptor;
        this.postUI = bl2;
        this.subject = this.getObject(object);
        this.handler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    }

    private Object getObject(Object object) {
        Object object2;
        if (((ProxyInvocationHandler)object2).weakRef) {
            WeakReference<Object> weakReference;
            object2 = weakReference;
            weakReference = new WeakReference<Object>(object);
        } else {
            object2 = object;
        }
        return object2;
    }

    private Object getObject() {
        if (this.weakRef) {
            return ((WeakReference)this.subject).get();
        }
        return this.subject;
    }

    private Object postSafeInvoke(ProxyBulk proxyBulk) {
        this.handler.obtainMessage(0, (Object)proxyBulk).sendToTarget();
        return null;
    }

    private Object safeInvoke(ProxyBulk proxyBulk) {
        try {
            return proxyBulk.safeInvoke();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        ProxyInvocationHandler proxyInvocationHandler = this;
        object = proxyInvocationHandler.getObject();
        if (!proxyInvocationHandler.onIntercept(object, method, objectArray)) {
            ProxyBulk proxyBulk;
            ProxyBulk proxyBulk2 = proxyBulk;
            proxyBulk = new ProxyBulk(object, method, objectArray);
            return this.postUI ? this.postSafeInvoke(proxyBulk2) : this.safeInvoke(proxyBulk2);
        }
        return null;
    }

    @Override
    public boolean onIntercept(Object object, Method method, Object[] objectArray) {
        ProxyInterceptor proxyInterceptor = ((ProxyInvocationHandler)proxyInterceptor).interceptor;
        if (proxyInterceptor != null) {
            try {
                return proxyInterceptor.onIntercept(object, method, objectArray);
            }
            catch (Exception exception) {
                BluetoothLog.e(exception);
            }
        }
        return false;
    }

    public boolean handleMessage(Message message) {
        ProxyBulk.safeInvoke(message.obj);
        return true;
    }
}

