/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.utils.hook.utils;

import com.tuya.sdk.blelib.utils.hook.utils.MemberUtils;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class MethodUtils {
    public static Method getAccessibleMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            return MethodUtils.getAccessibleMethod(clazz.getMethod(string, classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method object) {
        Class<?>[] classArray;
        if (!MemberUtils.isAccessible((Member)object)) {
            return null;
        }
        Class<?> clazz = ((Method)object).getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return object;
        }
        Method method = object;
        object = method.getName();
        Method method2 = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, (String)object, classArray = method.getParameterTypes());
        if (method2 == null) {
            method2 = MethodUtils.getAccessibleMethodFromSuperclass(clazz, (String)object, classArray);
        }
        return method2;
    }

    public static Method getAccessibleMethodFromSuperclass(Class<?> clazz, String string, Class<?> ... classArray) {
        for (clazz = clazz.getSuperclass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (!Modifier.isPublic(clazz.getModifiers())) continue;
            try {
                return clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        return null;
    }

    public static Method getAccessibleMethodFromInterfaceNest(Class<?> clazz, String string, Class<?> ... classArray) {
        while (clazz != null) {
            Class<?>[] classArray2 = clazz.getInterfaces();
            for (int i = 0; i < classArray2.length; ++i) {
                if (!Modifier.isPublic(classArray2[i].getModifiers())) continue;
                try {
                    return classArray2[i].getDeclaredMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Method method = MethodUtils.getAccessibleMethodFromInterfaceNest(classArray2[i], string, classArray);
                    if (method == null) continue;
                    return method;
                }
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }
}

