/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.utils;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.tuya.sdk.blelib.ContextAgent;
import com.tuya.sdk.blelib.utils.BluetoothLog;
import com.tuya.sdk.blelib.utils.WtUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BluetoothUtils {
    public static BluetoothManager mBluetoothManager;
    public static BluetoothAdapter mBluetoothAdapter;
    public static Handler mHandler;

    public static Context getContext() {
        return ContextAgent.getInstance().getContext();
    }

    public static Handler getHandler() {
        if (mHandler == null) {
            mHandler = new Handler(Looper.getMainLooper());
        }
        return mHandler;
    }

    public static void post(Runnable runnable) {
        BluetoothUtils.getHandler().post(runnable);
    }

    public static void registerReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter) {
        BluetoothUtils.registerGlobalReceiver(broadcastReceiver, intentFilter);
    }

    public static void registerGlobalReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter) {
        BluetoothUtils.getContext().registerReceiver(broadcastReceiver, intentFilter);
    }

    public static void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        BluetoothUtils.unregisterGlobalReceiver(broadcastReceiver);
    }

    public static void unregisterGlobalReceiver(BroadcastReceiver broadcastReceiver) {
        BluetoothUtils.getContext().unregisterReceiver(broadcastReceiver);
    }

    public static void sendBroadcast(Intent intent) {
        BluetoothUtils.sendGlobalBroadcast(intent);
    }

    public static void sendBroadcast(String string) {
        BluetoothUtils.sendGlobalBroadcast(new Intent(string));
    }

    public static void sendGlobalBroadcast(Intent intent) {
        BluetoothUtils.getContext().sendBroadcast(intent);
    }

    public static boolean isBleSupported() {
        return Build.VERSION.SDK_INT >= 18 && BluetoothUtils.getContext() != null && BluetoothUtils.getContext().getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
    }

    public static boolean isBluetoothEnabled() {
        return BluetoothUtils.getBluetoothState() == 12;
    }

    public static int getBluetoothState() {
        BluetoothAdapter bluetoothAdapter = BluetoothUtils.getBluetoothAdapter();
        return bluetoothAdapter != null ? bluetoothAdapter.getState() : 0;
    }

    public static boolean openBluetooth() {
        BluetoothAdapter bluetoothAdapter = BluetoothUtils.getBluetoothAdapter();
        if (bluetoothAdapter != null) {
            return bluetoothAdapter.enable();
        }
        return false;
    }

    public static boolean closeBluetooth() {
        BluetoothAdapter bluetoothAdapter = BluetoothUtils.getBluetoothAdapter();
        if (bluetoothAdapter != null) {
            return bluetoothAdapter.disable();
        }
        return false;
    }

    public static BluetoothManager getBluetoothManager() {
        if (BluetoothUtils.isBleSupported()) {
            if (mBluetoothManager == null) {
                mBluetoothManager = (BluetoothManager)BluetoothUtils.getContext().getSystemService("bluetooth");
            }
            return mBluetoothManager;
        }
        return null;
    }

    public static BluetoothAdapter getBluetoothAdapter() {
        if (mBluetoothAdapter == null) {
            mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        }
        return mBluetoothAdapter;
    }

    public static BluetoothDevice getRemoteDevice(String string) {
        BluetoothAdapter bluetoothAdapter;
        if (!TextUtils.isEmpty((CharSequence)string) && (bluetoothAdapter = BluetoothUtils.getBluetoothAdapter()) != null) {
            return bluetoothAdapter.getRemoteDevice(string);
        }
        return null;
    }

    public static List<BluetoothDevice> getConnectedBluetoothLeDevices() {
        ArrayList<BluetoothDevice> arrayList;
        ArrayList<BluetoothDevice> arrayList2 = arrayList;
        arrayList = new ArrayList<BluetoothDevice>();
        BluetoothManager bluetoothManager = BluetoothUtils.getBluetoothManager();
        if (bluetoothManager != null) {
            arrayList2.addAll(bluetoothManager.getConnectedDevices(7));
        }
        return arrayList2;
    }

    public static int getConnectStatus(String string) {
        BluetoothManager bluetoothManager = BluetoothUtils.getBluetoothManager();
        if (bluetoothManager != null) {
            try {
                return bluetoothManager.getConnectionState(BluetoothUtils.getRemoteDevice(string), 7);
            }
            catch (Throwable throwable) {
                BluetoothLog.e(throwable);
            }
        }
        return -1;
    }

    public static int getBondState(String string) {
        if (BluetoothUtils.getBluetoothManager() != null) {
            try {
                return BluetoothUtils.getRemoteDevice(string).getBondState();
            }
            catch (Throwable throwable) {
                BluetoothLog.e(throwable);
            }
        }
        return 10;
    }

    public static List<BluetoothDevice> getBondedBluetoothClassicDevices() {
        ArrayList<BluetoothDevice> arrayList;
        Object object = BluetoothUtils.getBluetoothAdapter();
        ArrayList<BluetoothDevice> arrayList2 = arrayList;
        arrayList = new ArrayList<BluetoothDevice>();
        if (object != null && (object = object.getBondedDevices()) != null) {
            arrayList2.addAll((Collection<BluetoothDevice>)object);
        }
        return arrayList2;
    }

    public static boolean isDeviceConnected(String string) {
        if (!TextUtils.isEmpty((CharSequence)string) && BluetoothUtils.isBleSupported()) {
            return BluetoothUtils.getBluetoothManager().getConnectionState(BluetoothUtils.getBluetoothAdapter().getRemoteDevice(string), 7) == 2;
        }
        return false;
    }

    public static boolean checkMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static boolean refreshGattCache(BluetoothGatt objectArray) {
        boolean bl;
        block5: {
            bl = false;
            if (objectArray != null) {
                Class<BluetoothGatt> clazz = BluetoothGatt.class;
                Method method = clazz.getMethod("refresh", new Class[0]);
                if (method == null) break block5;
                try {
                    method.setAccessible(true);
                    bl = (Boolean)method.invoke((Object)objectArray, new Object[0]);
                }
                catch (Exception exception) {
                    BluetoothLog.e(exception);
                }
            }
        }
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = bl;
        BluetoothLog.v(WtUtil.format("refreshDeviceCache return %b", objectArray));
        return bl;
    }
}

