/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.search.le;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.os.Build;
import androidx.annotation.RequiresApi;
import com.tuya.sdk.blelib.search.BluetoothSearcher;
import com.tuya.sdk.blelib.search.SearchResult;
import com.tuya.sdk.blelib.search.response.BluetoothSearchResponse;
import com.tuya.sdk.blelib.utils.BluetoothLog;
import com.tuya.sdk.blelib.utils.BluetoothUtils;
import java.util.List;

public class BluetoothLESearcher
extends BluetoothSearcher {
    public final BluetoothAdapter.LeScanCallback mLeScanCallback = new BluetoothAdapter.LeScanCallback(){

        public void onLeScan(BluetoothDevice bluetoothDevice, int n, byte[] byArray) {
            BluetoothLESearcher.this.notifyDeviceFounded(new SearchResult(bluetoothDevice, n, byArray));
        }
    };
    public final Object mLock = new Object();
    public ScanCallback mScanCallback;

    public BluetoothLESearcher() {
        this.mBluetoothAdapter = BluetoothUtils.getBluetoothAdapter();
    }

    public static BluetoothLESearcher getInstance() {
        return BluetoothLESearcherHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=21)
    private void createNewScanCallback() {
        block4: {
            if (this.mScanCallback != null) break block4;
            BluetoothLESearcher bluetoothLESearcher = this;
            Object object = bluetoothLESearcher.mLock;
            synchronized (object) {
                if (bluetoothLESearcher.mScanCallback != null) break block4;
                this.mScanCallback = new ScanCallback(){

                    public void onScanResult(int n, ScanResult scanResult) {
                        super.onScanResult(n, scanResult);
                        byte[] byArray = scanResult.getScanRecord() == null ? null : scanResult.getScanRecord().getBytes();
                        ScanResult scanResult2 = scanResult;
                        2 this_ = scanResult2.getDevice();
                        this_.BluetoothLESearcher.this.notifyDeviceFounded(new SearchResult((BluetoothDevice)this_, scanResult2.getRssi(), byArray));
                    }
                };
            }
        }
    }

    public /* synthetic */ BluetoothLESearcher(1 var1_1) {
        this();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startScanBluetooth(BluetoothSearchResponse bluetoothSearchResponse) {
        super.startScanBluetooth(bluetoothSearchResponse);
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                BluetoothLESearcher bluetoothLESearcher = bluetoothLESearcher3;
                bluetoothLESearcher.createNewScanCallback();
                bluetoothSearchResponse = new ScanSettings.Builder().setScanMode(2).build();
                BluetoothLESearcher bluetoothLESearcher2 = bluetoothLESearcher3;
                BluetoothLESearcher bluetoothLESearcher3 = null;
                ScanCallback scanCallback = bluetoothLESearcher2.mScanCallback;
                bluetoothLESearcher.mBluetoothAdapter.getBluetoothLeScanner().startScan((List)((Object)bluetoothLESearcher3), (ScanSettings)bluetoothSearchResponse, scanCallback);
                return;
            }
            bluetoothLESearcher3.mBluetoothAdapter.startLeScan(bluetoothLESearcher3.mLeScanCallback);
            return;
        }
        catch (Exception exception) {
            BluetoothLog.e(exception);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void stopScanBluetooth() {
        block4: {
            try {
                if (Build.VERSION.SDK_INT >= 21) {
                    if (this.mScanCallback != null && this.mBluetoothAdapter.getBluetoothLeScanner() != null) {
                        this.mBluetoothAdapter.getBluetoothLeScanner().stopScan(this.mScanCallback);
                    }
                    break block4;
                }
                this.mBluetoothAdapter.stopLeScan(this.mLeScanCallback);
            }
            catch (Exception exception) {
                BluetoothLog.e(exception);
            }
        }
        super.stopScanBluetooth();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void cancelScanBluetooth() {
        block4: {
            try {
                if (Build.VERSION.SDK_INT >= 21) {
                    if (this.mScanCallback != null && this.mBluetoothAdapter.getBluetoothLeScanner() != null) {
                        this.mBluetoothAdapter.getBluetoothLeScanner().stopScan(this.mScanCallback);
                    }
                    break block4;
                }
                this.mBluetoothAdapter.stopLeScan(this.mLeScanCallback);
            }
            catch (Exception exception) {
                BluetoothLog.e(exception);
            }
        }
        super.cancelScanBluetooth();
    }

    public static class BluetoothLESearcherHolder {
        public static BluetoothLESearcher instance = new BluetoothLESearcher(null);
    }
}

