/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.search;

import android.bluetooth.BluetoothDevice;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

public class SearchResult
implements Parcelable {
    public static final Parcelable.Creator<SearchResult> CREATOR = new Parcelable.Creator<SearchResult>(){

        public SearchResult createFromParcel(Parcel parcel) {
            return new SearchResult(parcel);
        }

        public SearchResult[] newArray(int n) {
            return new SearchResult[n];
        }
    };
    public BluetoothDevice device;
    public int rssi;
    public byte[] scanRecord;

    public SearchResult(BluetoothDevice bluetoothDevice) {
        this(bluetoothDevice, 0, null);
    }

    public SearchResult(BluetoothDevice bluetoothDevice, int n, byte[] byArray) {
        this.device = bluetoothDevice;
        this.rssi = n;
        this.scanRecord = byArray;
    }

    public SearchResult(Parcel parcel) {
        this.device = (BluetoothDevice)parcel.readParcelable(BluetoothDevice.class.getClassLoader());
        this.rssi = parcel.readInt();
        this.scanRecord = parcel.createByteArray();
    }

    public String getName() {
        Object object = ((SearchResult)object).device.getName();
        if (TextUtils.isEmpty((CharSequence)object)) {
            object = "NULL";
        }
        return object;
    }

    public String getAddress() {
        SearchResult searchResult = searchResult.device;
        return searchResult != null ? searchResult.getAddress() : "";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(", mac = " + this.device.getAddress());
        return stringBuilder.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeParcelable((Parcelable)this.device, 0);
        parcel.writeInt(this.rssi);
        parcel.writeByteArray(this.scanRecord);
    }

    public boolean equals(Object object) {
        if (searchResult2 == object) {
            return true;
        }
        if (object != null && SearchResult.class == object.getClass()) {
            SearchResult searchResult = searchResult2;
            SearchResult searchResult2 = (SearchResult)object;
            return searchResult.device.equals((Object)searchResult2.device);
        }
        return false;
    }

    public int hashCode() {
        return this.device.hashCode();
    }
}

