/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.search;

import android.bluetooth.BluetoothAdapter;
import com.tuya.sdk.blelib.search.SearchResult;
import com.tuya.sdk.blelib.search.classic.BluetoothClassicSearcher;
import com.tuya.sdk.blelib.search.le.BluetoothLESearcher;
import com.tuya.sdk.blelib.search.response.BluetoothSearchResponse;
import com.tuya.sdk.blelib.utils.WtUtil;

public class BluetoothSearcher {
    public BluetoothAdapter mBluetoothAdapter;
    public BluetoothSearchResponse mSearchResponse;

    public static BluetoothSearcher newInstance(int n) {
        if (n != 1) {
            if (n == 2) {
                return BluetoothLESearcher.getInstance();
            }
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = n;
            throw new IllegalStateException(WtUtil.format("unknown search type %d", objectArray2));
        }
        return BluetoothClassicSearcher.getInstance();
    }

    private void notifySearchStarted() {
        BluetoothSearchResponse bluetoothSearchResponse = ((BluetoothSearcher)((Object)bluetoothSearchResponse)).mSearchResponse;
        if (bluetoothSearchResponse != null) {
            bluetoothSearchResponse.onSearchStarted();
        }
    }

    private void notifySearchStopped() {
        BluetoothSearchResponse bluetoothSearchResponse = ((BluetoothSearcher)((Object)bluetoothSearchResponse)).mSearchResponse;
        if (bluetoothSearchResponse != null) {
            bluetoothSearchResponse.onSearchStopped();
        }
    }

    private void notifySearchCanceled() {
        BluetoothSearchResponse bluetoothSearchResponse = ((BluetoothSearcher)((Object)bluetoothSearchResponse)).mSearchResponse;
        if (bluetoothSearchResponse != null) {
            bluetoothSearchResponse.onSearchCanceled();
        }
    }

    public void startScanBluetooth(BluetoothSearchResponse bluetoothSearchResponse) {
        this.mSearchResponse = bluetoothSearchResponse;
        this.notifySearchStarted();
    }

    public void stopScanBluetooth() {
        this.notifySearchStopped();
        this.mSearchResponse = null;
    }

    public void cancelScanBluetooth() {
        this.notifySearchCanceled();
        this.mSearchResponse = null;
    }

    public void notifyDeviceFounded(SearchResult searchResult) {
        BluetoothSearchResponse bluetoothSearchResponse = ((BluetoothSearcher)((Object)bluetoothSearchResponse)).mSearchResponse;
        if (bluetoothSearchResponse != null) {
            bluetoothSearchResponse.onDeviceFounded(searchResult);
        }
    }
}

