/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.search;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.tuya.sdk.blelib.search.BluetoothSearcher;
import com.tuya.sdk.blelib.search.SearchTask;
import com.tuya.sdk.blelib.search.response.BluetoothSearchResponse;
import com.tuya.sdk.blelib.utils.WtUtil;

public class BluetoothSearchTask
implements Handler.Callback {
    public static final int MSG_SEARCH_TIMEOUT = 34;
    public int searchType;
    public int searchDuration;
    public BluetoothSearcher mBluetoothSearcher;
    public Handler mHandler;

    public BluetoothSearchTask(SearchTask searchTask) {
        this.setSearchType(searchTask.getSearchType());
        this.setSearchDuration(searchTask.getSearchDuration());
        this.mHandler = new Handler(Looper.myLooper(), (Handler.Callback)this);
    }

    private BluetoothSearcher getBluetoothSearcher() {
        if (this.mBluetoothSearcher == null) {
            this.mBluetoothSearcher = BluetoothSearcher.newInstance(this.searchType);
        }
        return this.mBluetoothSearcher;
    }

    public void setSearchType(int n) {
        this.searchType = n;
    }

    public void setSearchDuration(int n) {
        this.searchDuration = n;
    }

    public boolean isBluetoothLeSearch() {
        return this.searchType == 2;
    }

    public boolean isBluetoothClassicSearch() {
        return this.searchType == 1;
    }

    public void start(BluetoothSearchResponse bluetoothSearchResponse) {
        BluetoothSearchTask bluetoothSearchTask = this;
        bluetoothSearchTask.getBluetoothSearcher().startScanBluetooth(bluetoothSearchResponse);
        int n = bluetoothSearchTask.searchDuration;
        if (n != -1) {
            long l = n;
            this.mHandler.sendEmptyMessageDelayed(34, l);
        }
    }

    public void cancel() {
        BluetoothSearchTask bluetoothSearchTask = this;
        bluetoothSearchTask.mHandler.removeCallbacksAndMessages(null);
        bluetoothSearchTask.getBluetoothSearcher().cancelScanBluetooth();
    }

    public String toString() {
        String string = this.isBluetoothLeSearch() ? "Ble" : (this.isBluetoothClassicSearch() ? "classic" : "unknown");
        int n = this.searchDuration;
        if (n >= 1000) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = string;
            objectArray[1] = n / 1000;
            return WtUtil.format("%s search (%ds)", objectArray2);
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray3 = objectArray;
        objectArray3[0] = string;
        objectArray[1] = (double)n * 1.0 / 1000.0;
        return WtUtil.format("%s search (%.1fs)", objectArray3);
    }

    public boolean handleMessage(Message message) {
        if (message.what == 34) {
            this.getBluetoothSearcher().stopScanBluetooth();
        }
        return true;
    }
}

