/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.search;

import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.tuya.sdk.blelib.search.BluetoothSearchTask;
import com.tuya.sdk.blelib.search.SearchRequest;
import com.tuya.sdk.blelib.search.SearchResult;
import com.tuya.sdk.blelib.search.SearchTask;
import com.tuya.sdk.blelib.search.response.BluetoothSearchResponse;
import com.tuya.sdk.blelib.utils.BluetoothLog;
import com.tuya.sdk.blelib.utils.BluetoothUtils;
import com.tuya.sdk.blelib.utils.WtUtil;
import java.util.ArrayList;
import java.util.List;

public class BluetoothSearchRequest
implements Handler.Callback {
    public static final int SCAN_INTERVAL = 100;
    public static final int MSG_START_SEARCH = 17;
    public static final int MSG_DEVICE_FOUND = 18;
    public List<BluetoothSearchTask> mSearchTaskList = new ArrayList<BluetoothSearchTask>();
    public BluetoothSearchResponse mSearchResponse;
    public BluetoothSearchTask mCurrentTask;
    public Handler mHandler;

    public BluetoothSearchRequest(SearchRequest object) {
        for (SearchTask searchTask : ((SearchRequest)object).getTasks()) {
            this.mSearchTaskList.add(new BluetoothSearchTask(searchTask));
        }
        this.mHandler = new Handler(Looper.myLooper(), (Handler.Callback)this);
    }

    private void scheduleNewSearchTask() {
        if (((BluetoothSearchRequest)((Object)bluetoothSearchResponse)).mSearchTaskList.size() > 0) {
            BluetoothSearchTask bluetoothSearchTask;
            ((BluetoothSearchRequest)((Object)bluetoothSearchResponse)).mCurrentTask = bluetoothSearchTask = ((BluetoothSearchRequest)((Object)bluetoothSearchResponse)).mSearchTaskList.remove(0);
            bluetoothSearchTask.start((BluetoothSearchRequest)((Object)bluetoothSearchResponse).new BluetoothSearchTaskResponse(bluetoothSearchTask));
        } else {
            ((BluetoothSearchRequest)((Object)bluetoothSearchResponse)).mCurrentTask = null;
            BluetoothSearchResponse bluetoothSearchResponse = ((BluetoothSearchRequest)((Object)bluetoothSearchResponse)).mSearchResponse;
            if (bluetoothSearchResponse != null) {
                bluetoothSearchResponse.onSearchStopped();
            }
        }
    }

    private void notifyConnectedBluetoothDevices() {
        boolean bl = false;
        boolean bl2 = false;
        for (BluetoothSearchTask bluetoothSearchTask : this.mSearchTaskList) {
            if (bluetoothSearchTask.isBluetoothLeSearch()) {
                bl = true;
                continue;
            }
            if (bluetoothSearchTask.isBluetoothClassicSearch()) {
                bl2 = true;
                continue;
            }
            throw new IllegalArgumentException("unknown search task type!");
        }
        if (bl) {
            this.notifyConnectedBluetoothLeDevices();
        }
        if (bl2) {
            this.notifyBondedBluetoothClassicDevices();
        }
    }

    private void notifyConnectedBluetoothLeDevices() {
        for (BluetoothDevice bluetoothDevice : BluetoothUtils.getConnectedBluetoothLeDevices()) {
            this.notifyDeviceFounded(new SearchResult(bluetoothDevice));
        }
    }

    private void notifyBondedBluetoothClassicDevices() {
        for (BluetoothDevice bluetoothDevice : BluetoothUtils.getBondedBluetoothClassicDevices()) {
            this.notifyDeviceFounded(new SearchResult(bluetoothDevice));
        }
    }

    private void notifyDeviceFounded(SearchResult searchResult) {
        this.mHandler.obtainMessage(18, (Object)searchResult).sendToTarget();
    }

    public void setSearchResponse(BluetoothSearchResponse bluetoothSearchResponse) {
        this.mSearchResponse = bluetoothSearchResponse;
    }

    public void start() {
        BluetoothSearchResponse bluetoothSearchResponse = this.mSearchResponse;
        if (bluetoothSearchResponse != null) {
            bluetoothSearchResponse.onSearchStarted();
        }
        BluetoothSearchRequest bluetoothSearchRequest = this;
        bluetoothSearchRequest.notifyConnectedBluetoothDevices();
        bluetoothSearchRequest.mHandler.sendEmptyMessageDelayed(17, 100L);
    }

    public boolean handleMessage(Message object) {
        int n = ((Message)object).what;
        if (n != 17) {
            if (n == 18) {
                BluetoothSearchRequest bluetoothSearchRequest = searchResult;
                SearchResult searchResult = (SearchResult)((Message)object).obj;
                object = bluetoothSearchRequest.mSearchResponse;
                if (object != null) {
                    object.onDeviceFounded(searchResult);
                }
            }
        } else {
            ((BluetoothSearchRequest)((Object)searchResult)).scheduleNewSearchTask();
        }
        return true;
    }

    public void cancel() {
        Object object = this.mCurrentTask;
        if (object != null) {
            ((BluetoothSearchTask)object).cancel();
            this.mCurrentTask = null;
        }
        BluetoothSearchRequest bluetoothSearchRequest = this;
        bluetoothSearchRequest.mSearchTaskList.clear();
        object = bluetoothSearchRequest.mSearchResponse;
        if (object != null) {
            object.onSearchCanceled();
        }
        this.mSearchResponse = null;
    }

    public String toString() {
        StringBuilder stringBuilder;
        BluetoothSearchRequest bluetoothSearchRequest = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (BluetoothSearchTask bluetoothSearchTask : bluetoothSearchRequest.mSearchTaskList) {
            stringBuilder2.append(bluetoothSearchTask.toString() + ", ");
        }
        return stringBuilder2.toString();
    }

    public class BluetoothSearchTaskResponse
    implements BluetoothSearchResponse {
        public BluetoothSearchTask task;

        public BluetoothSearchTaskResponse(BluetoothSearchTask bluetoothSearchTask) {
            this.task = bluetoothSearchTask;
        }

        @Override
        public void onSearchStarted() {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.task;
            BluetoothLog.v(WtUtil.format("%s onSearchStarted", objectArray2));
        }

        @Override
        public void onDeviceFounded(SearchResult searchResult) {
            BluetoothSearchRequest.this.notifyDeviceFounded(searchResult);
        }

        @Override
        public void onSearchStopped() {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.task;
            BluetoothLog.v(WtUtil.format("%s onSearchStopped", objectArray2));
            BluetoothSearchRequest.this.mHandler.sendEmptyMessageDelayed(17, 100L);
        }

        @Override
        public void onSearchCanceled() {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.task;
            BluetoothLog.v(WtUtil.format("%s onSearchCanceled", objectArray2));
        }
    }
}

