/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.search;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.tuya.sdk.blelib.search.BluetoothSearchRequest;
import com.tuya.sdk.blelib.search.IBluetoothSearchHelper;
import com.tuya.sdk.blelib.search.SearchResult;
import com.tuya.sdk.blelib.search.response.BluetoothSearchResponse;
import com.tuya.sdk.blelib.utils.BluetoothUtils;
import com.tuya.sdk.blelib.utils.proxy.ProxyBulk;
import com.tuya.sdk.blelib.utils.proxy.ProxyInterceptor;
import com.tuya.sdk.blelib.utils.proxy.ProxyUtils;
import java.lang.reflect.Method;

public class BluetoothSearchHelper
implements IBluetoothSearchHelper,
ProxyInterceptor,
Handler.Callback {
    public static volatile IBluetoothSearchHelper sInstance;
    public BluetoothSearchRequest mCurrentRequest;
    public Handler mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IBluetoothSearchHelper getInstance() {
        if (sInstance != null) return sInstance;
        Class<BluetoothSearchHelper> clazz = BluetoothSearchHelper.class;
        synchronized (BluetoothSearchHelper.class) {
            BluetoothSearchHelper bluetoothSearchHelper;
            if (sInstance != null) return sInstance;
            BluetoothSearchHelper bluetoothSearchHelper2 = bluetoothSearchHelper;
            sInstance = (IBluetoothSearchHelper)ProxyUtils.getProxy(new BluetoothSearchHelper(), IBluetoothSearchHelper.class, bluetoothSearchHelper2);
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public static /* synthetic */ BluetoothSearchRequest access$002(BluetoothSearchHelper bluetoothSearchHelper, BluetoothSearchRequest bluetoothSearchRequest) {
        bluetoothSearchHelper.mCurrentRequest = bluetoothSearchRequest;
        return bluetoothSearchRequest;
    }

    @Override
    public void startSearch(BluetoothSearchRequest bluetoothSearchRequest, BluetoothSearchResponse bluetoothSearchResponse) {
        bluetoothSearchRequest.setSearchResponse(new BluetoothSearchResponseImpl(bluetoothSearchResponse));
        if (!BluetoothUtils.isBluetoothEnabled()) {
            bluetoothSearchRequest.cancel();
        } else {
            BluetoothSearchHelper bluetoothSearchHelper = this;
            bluetoothSearchHelper.stopSearch();
            if (bluetoothSearchHelper.mCurrentRequest == null) {
                this.mCurrentRequest = bluetoothSearchRequest;
                bluetoothSearchRequest.start();
            }
        }
    }

    @Override
    public void stopSearch() {
        BluetoothSearchRequest bluetoothSearchRequest = this.mCurrentRequest;
        if (bluetoothSearchRequest != null) {
            bluetoothSearchRequest.cancel();
            this.mCurrentRequest = null;
        }
    }

    @Override
    public boolean onIntercept(Object object, Method method, Object[] objectArray) {
        ProxyBulk proxyBulk;
        ProxyBulk proxyBulk2 = proxyBulk;
        proxyBulk = new ProxyBulk(object, method, objectArray);
        ((BluetoothSearchHelper)((Object)proxyBulk2)).mHandler.obtainMessage(0, (Object)proxyBulk2).sendToTarget();
        return true;
    }

    public boolean handleMessage(Message message) {
        ProxyBulk.safeInvoke(message.obj);
        return true;
    }

    public class BluetoothSearchResponseImpl
    implements BluetoothSearchResponse {
        public BluetoothSearchResponse response;

        public BluetoothSearchResponseImpl(BluetoothSearchResponse bluetoothSearchResponse) {
            this.response = bluetoothSearchResponse;
        }

        @Override
        public void onSearchStarted() {
            this.response.onSearchStarted();
        }

        @Override
        public void onDeviceFounded(SearchResult searchResult) {
            this.response.onDeviceFounded(searchResult);
        }

        @Override
        public void onSearchStopped() {
            BluetoothSearchResponseImpl bluetoothSearchResponseImpl = this;
            bluetoothSearchResponseImpl.response.onSearchStopped();
            BluetoothSearchHelper.access$002(bluetoothSearchResponseImpl.BluetoothSearchHelper.this, null);
        }

        @Override
        public void onSearchCanceled() {
            BluetoothSearchResponseImpl bluetoothSearchResponseImpl = this;
            bluetoothSearchResponseImpl.response.onSearchCanceled();
            BluetoothSearchHelper.access$002(bluetoothSearchResponseImpl.BluetoothSearchHelper.this, null);
        }
    }
}

