/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.receiver;

import android.content.Context;
import android.content.Intent;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.tuya.sdk.blelib.receiver.AbsBluetoothReceiver;
import com.tuya.sdk.blelib.receiver.IReceiverDispatcher;
import com.tuya.sdk.blelib.receiver.listener.BluetoothReceiverListener;
import com.tuya.sdk.blelib.receiver.listener.BluetoothStateChangeListener;
import com.tuya.sdk.blelib.utils.BluetoothLog;
import com.tuya.sdk.blelib.utils.WtUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class BluetoothStateReceiver
extends AbsBluetoothReceiver {
    public static final String[] ACTIONS = new String[]{"android.bluetooth.adapter.action.STATE_CHANGED"};
    public static final String BLUETOOTH_STATE_CHANGE = "com.tuya.smart.bluetooth.received";
    public LocalBroadcastManager localBroadcastManager;

    public BluetoothStateReceiver(IReceiverDispatcher iReceiverDispatcher) {
        super(iReceiverDispatcher);
    }

    public static BluetoothStateReceiver newInstance(IReceiverDispatcher iReceiverDispatcher) {
        return new BluetoothStateReceiver(iReceiverDispatcher);
    }

    private void onBluetoothStateChanged(int n, int n2) {
        Iterator<BluetoothReceiverListener> iterator = ((AbsBluetoothReceiver)((Object)iterator)).getListeners(BluetoothStateChangeListener.class).iterator();
        while (iterator.hasNext()) {
            ((BluetoothReceiverListener)iterator.next()).invoke(n, n2);
        }
    }

    private String getStateString(int n) {
        switch (n) {
            default: {
                return "unknown";
            }
            case 13: {
                return "state_turning_off";
            }
            case 12: {
                return "state_on";
            }
            case 11: {
                return "state_turning_on";
            }
            case 10: 
        }
        return "state_off";
    }

    @Override
    public List<String> getActions() {
        return Arrays.asList(ACTIONS);
    }

    @Override
    public boolean onReceive(Context context, Intent intent) {
        BluetoothStateReceiver bluetoothStateReceiver;
        Intent intent2;
        Intent intent3 = intent;
        int n = intent3.getIntExtra("android.bluetooth.adapter.extra.STATE", 0);
        int n2 = intent3.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", 0);
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = bluetoothStateReceiver2.getStateString(n2);
        objectArray[1] = bluetoothStateReceiver2.getStateString(n);
        BluetoothLog.v(WtUtil.format("state changed: %s -> %s", objectArray2));
        bluetoothStateReceiver2.onBluetoothStateChanged(n2, n);
        bluetoothStateReceiver2.localBroadcastManager = LocalBroadcastManager.getInstance((Context)context);
        BluetoothStateReceiver bluetoothStateReceiver2 = intent2;
        new Intent().setAction(BLUETOOTH_STATE_CHANGE);
        bluetoothStateReceiver2.putExtra("state", n);
        bluetoothStateReceiver.localBroadcastManager.sendBroadcast((Intent)bluetoothStateReceiver2);
        return true;
    }
}

