/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.tuya.sdk.blelib.receiver.AbsBluetoothReceiver;
import com.tuya.sdk.blelib.receiver.BleCharacterChangeReceiver;
import com.tuya.sdk.blelib.receiver.BleConnectStatusChangeReceiver;
import com.tuya.sdk.blelib.receiver.BluetoothBondReceiver;
import com.tuya.sdk.blelib.receiver.BluetoothStateReceiver;
import com.tuya.sdk.blelib.receiver.IBluetoothReceiver;
import com.tuya.sdk.blelib.receiver.IReceiverDispatcher;
import com.tuya.sdk.blelib.receiver.listener.BluetoothReceiverListener;
import com.tuya.sdk.blelib.utils.BluetoothLog;
import com.tuya.sdk.blelib.utils.BluetoothUtils;
import com.tuya.sdk.blelib.utils.WtUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BluetoothReceiver
extends BroadcastReceiver
implements IBluetoothReceiver,
Handler.Callback {
    public static final int MSG_REGISTER = 1;
    public static volatile IBluetoothReceiver mReceiver;
    public Map<String, List<BluetoothReceiverListener>> mListeners;
    public Handler mHandler;
    public IReceiverDispatcher mDispatcher;
    public AbsBluetoothReceiver[] RECEIVERS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IBluetoothReceiver getInstance() {
        if (mReceiver != null) return mReceiver;
        Class<BluetoothReceiver> clazz = BluetoothReceiver.class;
        synchronized (BluetoothReceiver.class) {
            if (mReceiver != null) return mReceiver;
            mReceiver = new BluetoothReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mReceiver;
        }
    }

    public BluetoothReceiver() {
        IReceiverDispatcher iReceiverDispatcher;
        BluetoothReceiver bluetoothReceiver = this;
        IReceiverDispatcher iReceiverDispatcher2 = iReceiverDispatcher;
        bluetoothReceiver.mDispatcher = new IReceiverDispatcher(){

            @Override
            public List<BluetoothReceiverListener> getListeners(Class<?> clazz) {
                return (List)BluetoothReceiver.this.mListeners.get(clazz.getSimpleName());
            }
        };
        AbsBluetoothReceiver[] absBluetoothReceiverArray = new AbsBluetoothReceiver[4];
        AbsBluetoothReceiver[] absBluetoothReceiverArray2 = absBluetoothReceiverArray;
        absBluetoothReceiverArray2[0] = BluetoothStateReceiver.newInstance(iReceiverDispatcher2);
        absBluetoothReceiverArray2[1] = BluetoothBondReceiver.newInstance(this.mDispatcher);
        absBluetoothReceiverArray2[2] = BleConnectStatusChangeReceiver.newInstance(this.mDispatcher);
        absBluetoothReceiverArray[3] = BleCharacterChangeReceiver.newInstance(this.mDispatcher);
        bluetoothReceiver.RECEIVERS = absBluetoothReceiverArray;
        bluetoothReceiver.mListeners = new HashMap<String, List<BluetoothReceiverListener>>();
        bluetoothReceiver.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        BluetoothUtils.registerReceiver(bluetoothReceiver, bluetoothReceiver.getIntentFilter());
    }

    private IntentFilter getIntentFilter() {
        IntentFilter intentFilter;
        BluetoothReceiver bluetoothReceiver = bluetoothReceiver2;
        BluetoothReceiver bluetoothReceiver2 = intentFilter;
        intentFilter = new IntentFilter();
        AbsBluetoothReceiver[] absBluetoothReceiverArray = bluetoothReceiver.RECEIVERS;
        int n = bluetoothReceiver.RECEIVERS.length;
        for (int i = 0; i < n; ++i) {
            Iterator<String> iterator = absBluetoothReceiverArray[i].getActions().iterator();
            while (iterator.hasNext()) {
                bluetoothReceiver2.addAction(iterator.next());
            }
        }
        return bluetoothReceiver2;
    }

    private void registerInner(BluetoothReceiverListener bluetoothReceiverListener) {
        if (bluetoothReceiverListener != null) {
            LinkedList<BluetoothReceiverListener> linkedList = this.mListeners.get(bluetoothReceiverListener.getName());
            if (linkedList == null) {
                LinkedList<BluetoothReceiverListener> linkedList2;
                linkedList = linkedList2;
                linkedList2 = new LinkedList<BluetoothReceiverListener>();
                this.mListeners.put(bluetoothReceiverListener.getName(), linkedList);
            }
            linkedList.add(bluetoothReceiverListener);
        }
    }

    public void onReceive(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        String string = intent.getAction();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = string;
        BluetoothLog.v(WtUtil.format("BluetoothReceiver onReceive: %s", objectArray3));
        objectArray3 = objectArray.RECEIVERS;
        int n = objectArray.RECEIVERS.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray3[i];
            if (!((AbsBluetoothReceiver)object).containsAction(string) || !((AbsBluetoothReceiver)object).onReceive(context, intent)) continue;
            return;
        }
    }

    @Override
    public void register(BluetoothReceiverListener bluetoothReceiverListener) {
        this.mHandler.obtainMessage(1, (Object)bluetoothReceiverListener).sendToTarget();
    }

    public boolean handleMessage(Message message) {
        if (message.what == 1) {
            this.registerInner((BluetoothReceiverListener)message.obj);
        }
        return true;
    }
}

