/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.receiver;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.Intent;
import com.tuya.sdk.blelib.receiver.AbsBluetoothReceiver;
import com.tuya.sdk.blelib.receiver.IReceiverDispatcher;
import com.tuya.sdk.blelib.receiver.listener.BluetoothBondStateChangeListener;
import com.tuya.sdk.blelib.receiver.listener.BluetoothReceiverListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class BluetoothBondReceiver
extends AbsBluetoothReceiver {
    public static final String[] ACTIONS = new String[]{"android.bluetooth.device.action.BOND_STATE_CHANGED"};

    public BluetoothBondReceiver(IReceiverDispatcher iReceiverDispatcher) {
        super(iReceiverDispatcher);
    }

    public static BluetoothBondReceiver newInstance(IReceiverDispatcher iReceiverDispatcher) {
        return new BluetoothBondReceiver(iReceiverDispatcher);
    }

    private void onBondStateChanged(String string, int n) {
        Iterator<BluetoothReceiverListener> iterator = ((AbsBluetoothReceiver)((Object)iterator)).getListeners(BluetoothBondStateChangeListener.class).iterator();
        while (iterator.hasNext()) {
            ((BluetoothReceiverListener)iterator.next()).invoke(string, n);
        }
    }

    @Override
    public List<String> getActions() {
        return Arrays.asList(ACTIONS);
    }

    @Override
    public boolean onReceive(Context context, Intent intent) {
        context = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
        int n = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", -1);
        if (context != null) {
            this.onBondStateChanged(context.getAddress(), n);
        }
        return true;
    }
}

