/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.receiver;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.tuya.sdk.blelib.receiver.IReceiverDispatcher;
import com.tuya.sdk.blelib.receiver.listener.BluetoothReceiverListener;
import com.tuya.sdk.blelib.utils.BluetoothUtils;
import com.tuya.sdk.blelib.utils.ListUtils;
import java.util.Collections;
import java.util.List;

public abstract class AbsBluetoothReceiver {
    public Context mContext;
    public Handler mHandler;
    public IReceiverDispatcher mDispatcher;

    public AbsBluetoothReceiver(IReceiverDispatcher iReceiverDispatcher) {
        AbsBluetoothReceiver absBluetoothReceiver = this;
        absBluetoothReceiver.mDispatcher = iReceiverDispatcher;
        absBluetoothReceiver.mContext = BluetoothUtils.getContext();
        absBluetoothReceiver.mHandler = new Handler(Looper.getMainLooper());
    }

    public boolean containsAction(String string) {
        if (!ListUtils.isEmpty(this = ((AbsBluetoothReceiver)this).getActions()) && !TextUtils.isEmpty((CharSequence)string)) {
            return this.contains(string);
        }
        return false;
    }

    public List<BluetoothReceiverListener> getListeners(Class<?> clazz) {
        List<BluetoothReceiverListener> list = ((AbsBluetoothReceiver)((Object)list)).mDispatcher.getListeners(clazz);
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    public abstract List<String> getActions();

    public abstract boolean onReceive(Context var1, Intent var2);
}

