/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.model;

import android.bluetooth.BluetoothGattCharacteristic;
import android.os.Parcel;
import android.os.Parcelable;
import com.tuya.sdk.blelib.model.BleGattCharacter;
import com.tuya.sdk.blelib.model.BleGattService;
import com.tuya.sdk.blelib.utils.ListUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class BleGattProfile
implements Parcelable {
    public static final Parcelable.Creator<BleGattProfile> CREATOR = new Parcelable.Creator<BleGattProfile>(){

        public BleGattProfile createFromParcel(Parcel parcel) {
            return new BleGattProfile(parcel);
        }

        public BleGattProfile[] newArray(int n) {
            return new BleGattProfile[n];
        }
    };
    public List<BleGattService> services;

    public BleGattProfile(Map<UUID, Map<UUID, BluetoothGattCharacteristic>> object) {
        ArrayList<BleGattService> arrayList;
        object = object.entrySet().iterator();
        ArrayList<BleGattService> arrayList2 = arrayList;
        arrayList = new ArrayList<BleGattService>();
        while (object.hasNext()) {
            BleGattService bleGattService;
            Map.Entry entry = (Map.Entry)object.next();
            UUID uUID = (UUID)entry.getKey();
            Map map = (Map)entry.getValue();
            BleGattService bleGattService2 = bleGattService;
            if (arrayList2.contains(new BleGattService(uUID, map))) continue;
            arrayList2.add(bleGattService2);
        }
        this.addServices(arrayList2);
    }

    public BleGattProfile(Parcel parcel) {
        BleGattProfile bleGattProfile = this;
        parcel.readTypedList(bleGattProfile.getServices(), BleGattService.CREATOR);
    }

    public void addServices(List<BleGattService> list) {
        Collections.sort(list);
        this.getServices().addAll(list);
    }

    public List<BleGattService> getServices() {
        if (this.services == null) {
            ArrayList<BleGattService> arrayList;
            ArrayList<BleGattService> arrayList2 = arrayList;
            arrayList = new ArrayList<BleGattService>();
            this.services = arrayList2;
        }
        return this.services;
    }

    public BleGattService getService(UUID uUID) {
        if (uUID == null) {
            return null;
        }
        for (BleGattService bleGattService : ((BleGattProfile)this).getServices()) {
            if (!bleGattService.getUUID().equals(uUID)) continue;
            return bleGattService;
        }
        return null;
    }

    public boolean containsCharacter(UUID uUID, UUID uUID2) {
        if (uUID != null && uUID2 != null) {
            if ((object = ((BleGattProfile)object).getService(uUID)) != null && !ListUtils.isEmpty(object = ((BleGattService)object).getCharacters())) {
                Object object = object.iterator();
                while (object.hasNext()) {
                    if (!uUID2.equals(((BleGattCharacter)object.next()).getUuid())) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeTypedList(this.getServices());
    }

    public int describeContents() {
        return 0;
    }

    public String toString() {
        StringBuilder stringBuilder;
        BleGattProfile bleGattProfile = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        Iterator<BleGattService> iterator = bleGattProfile.services.iterator();
        while (iterator.hasNext()) {
            stringBuilder2.append(iterator.next()).append("\n");
        }
        return stringBuilder2.toString();
    }
}

