/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.model;

import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import com.tuya.sdk.blelib.model.BleGattDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class BleGattCharacter
implements Parcelable {
    public static final Parcelable.Creator<BleGattCharacter> CREATOR = new Parcelable.Creator<BleGattCharacter>(){

        public BleGattCharacter createFromParcel(Parcel parcel) {
            return new BleGattCharacter(parcel);
        }

        public BleGattCharacter[] newArray(int n) {
            return new BleGattCharacter[n];
        }
    };
    public ParcelUuid uuid;
    public int property;
    public int permissions;
    public List<BleGattDescriptor> descriptors;

    public BleGattCharacter(Parcel parcel) {
        this.uuid = (ParcelUuid)parcel.readParcelable(ParcelUuid.class.getClassLoader());
        this.property = parcel.readInt();
        this.permissions = parcel.readInt();
        this.descriptors = parcel.createTypedArrayList(BleGattDescriptor.CREATOR);
    }

    public BleGattCharacter(BluetoothGattCharacteristic object) {
        this.uuid = new ParcelUuid(object.getUuid());
        this.property = object.getProperties();
        this.permissions = object.getPermissions();
        for (BluetoothGattDescriptor bluetoothGattDescriptor : object.getDescriptors()) {
            this.getDescriptors().add(new BleGattDescriptor(bluetoothGattDescriptor));
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeParcelable((Parcelable)this.uuid, n);
        parcel.writeInt(this.property);
        parcel.writeInt(this.permissions);
        parcel.writeTypedList(this.descriptors);
    }

    public UUID getUuid() {
        return this.uuid.getUuid();
    }

    public void setUuid(ParcelUuid parcelUuid) {
        this.uuid = parcelUuid;
    }

    public int getProperty() {
        return this.property;
    }

    public void setProperty(int n) {
        this.property = n;
    }

    public int getPermissions() {
        return this.permissions;
    }

    public void setPermissions(int n) {
        this.permissions = n;
    }

    public List<BleGattDescriptor> getDescriptors() {
        if (this.descriptors == null) {
            ArrayList<BleGattDescriptor> arrayList;
            ArrayList<BleGattDescriptor> arrayList2 = arrayList;
            arrayList = new ArrayList<BleGattDescriptor>();
            this.descriptors = arrayList2;
        }
        return this.descriptors;
    }

    public void setDescriptors(List<BleGattDescriptor> list) {
        this.descriptors = list;
    }

    public String toString() {
        return "BleGattCharacter{uuid=" + this.uuid + ", property=" + this.property + ", permissions=" + this.permissions + ", descriptors=" + this.descriptors + '}';
    }
}

