/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.connect.request;

import android.bluetooth.BluetoothGattCharacteristic;
import com.tuya.sdk.blelib.connect.listener.WriteCharacterListener;
import com.tuya.sdk.blelib.connect.request.BleRequest;
import com.tuya.sdk.blelib.connect.response.BleGeneralResponse;
import com.tuya.sdk.blelib.utils.BluetoothLog;
import com.tuya.sdk.blelib.utils.ByteUtils;
import java.util.UUID;

public class BleWriteNoRspRequest
extends BleRequest
implements WriteCharacterListener {
    public UUID mServiceUUID;
    public UUID mCharacterUUID;
    public byte[] mBytes;

    public BleWriteNoRspRequest(UUID uUID, UUID uUID2, byte[] byArray, BleGeneralResponse bleGeneralResponse) {
        super(bleGeneralResponse);
        this.mServiceUUID = uUID;
        this.mCharacterUUID = uUID2;
        this.mBytes = byArray;
    }

    private void startWrite() {
        BleWriteNoRspRequest bleWriteNoRspRequest = this;
        UUID uUID = bleWriteNoRspRequest.mServiceUUID;
        UUID uUID2 = bleWriteNoRspRequest.mCharacterUUID;
        byte[] byArray = bleWriteNoRspRequest.mBytes;
        if (!bleWriteNoRspRequest.writeCharacteristicWithNoRsp(uUID, uUID2, byArray)) {
            this.onRequestCompleted(-1);
        } else {
            this.startRequestTiming();
        }
    }

    @Override
    public void processRequest() {
        int n = this.getCurrentStatus();
        if (n != 0) {
            if (n != 2) {
                if (n != 19) {
                    this.onRequestCompleted(-1);
                } else {
                    this.startWrite();
                }
            } else {
                this.startWrite();
            }
        } else {
            this.onRequestCompleted(-1);
        }
    }

    @Override
    public void onCharacteristicWrite(BluetoothGattCharacteristic bluetoothGattCharacteristic, int n, byte[] byArray) {
        BluetoothLog.d("BleWriteNoRspRequest onCharacteristicWrite() called with: characteristic = [" + bluetoothGattCharacteristic + "], status = [" + n + "], value = [" + ByteUtils.byteToString(byArray) + "]");
        this.stopRequestTiming();
        if (n == 0) {
            this.onRequestCompleted(0);
        } else {
            this.onRequestCompleted(-1);
        }
    }
}

