/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.connect.request;

import android.bluetooth.BluetoothGattDescriptor;
import com.tuya.sdk.blelib.connect.listener.WriteDescriptorListener;
import com.tuya.sdk.blelib.connect.request.BleRequest;
import com.tuya.sdk.blelib.connect.response.BleGeneralResponse;
import java.util.UUID;

public class BleWriteDescriptorRequest
extends BleRequest
implements WriteDescriptorListener {
    public UUID mServiceUUID;
    public UUID mCharacterUUID;
    public UUID mDescriptorUUID;
    public byte[] mBytes;

    public BleWriteDescriptorRequest(UUID uUID, UUID uUID2, UUID uUID3, byte[] byArray, BleGeneralResponse bleGeneralResponse) {
        super(bleGeneralResponse);
        this.mServiceUUID = uUID;
        this.mCharacterUUID = uUID2;
        this.mDescriptorUUID = uUID3;
        this.mBytes = byArray;
    }

    private void startWrite() {
        BleWriteDescriptorRequest bleWriteDescriptorRequest = this;
        UUID uUID = bleWriteDescriptorRequest.mServiceUUID;
        UUID uUID2 = bleWriteDescriptorRequest.mCharacterUUID;
        UUID uUID3 = bleWriteDescriptorRequest.mDescriptorUUID;
        byte[] byArray = bleWriteDescriptorRequest.mBytes;
        if (!bleWriteDescriptorRequest.writeDescriptor(uUID, uUID2, uUID3, byArray)) {
            this.onRequestCompleted(-1);
        } else {
            this.startRequestTiming();
        }
    }

    @Override
    public void processRequest() {
        int n = this.getCurrentStatus();
        if (n != 0) {
            if (n != 2) {
                if (n != 19) {
                    this.onRequestCompleted(-1);
                } else {
                    this.startWrite();
                }
            } else {
                this.startWrite();
            }
        } else {
            this.onRequestCompleted(-1);
        }
    }

    @Override
    public void onDescriptorWrite(BluetoothGattDescriptor bluetoothGattDescriptor, int n) {
        this.stopRequestTiming();
        if (n == 0) {
            this.onRequestCompleted(0);
        } else {
            this.onRequestCompleted(-1);
        }
    }
}

