/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.connect.request;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import com.tuya.sdk.blelib.Constants;
import com.tuya.sdk.blelib.RuntimeChecker;
import com.tuya.sdk.blelib.connect.IBleConnectDispatcher;
import com.tuya.sdk.blelib.connect.IBleConnectWorker;
import com.tuya.sdk.blelib.connect.listener.GattResponseListener;
import com.tuya.sdk.blelib.connect.request.IBleRequest;
import com.tuya.sdk.blelib.connect.response.BleGeneralResponse;
import com.tuya.sdk.blelib.model.BleGattProfile;
import com.tuya.sdk.blelib.utils.BluetoothLog;
import com.tuya.sdk.blelib.utils.BluetoothUtils;
import com.tuya.sdk.blelib.utils.WtUtil;
import java.util.UUID;

public abstract class BleRequest
implements IBleConnectWorker,
IBleRequest,
Handler.Callback,
GattResponseListener,
RuntimeChecker {
    public static final int MSG_REQUEST_TIMEOUT = 32;
    public BleGeneralResponse mResponse;
    public Bundle mExtra;
    public String mAddress;
    public IBleConnectDispatcher mDispatcher;
    public IBleConnectWorker mWorker;
    public Handler mHandler;
    public Handler mResponseHandler;
    public boolean mRequestTimeout;
    public RuntimeChecker mRuntimeChecker;
    public boolean mFinished;

    public BleRequest(BleGeneralResponse bleGeneralResponse) {
        BleRequest bleRequest = this;
        bleRequest.mResponse = bleGeneralResponse;
        bleRequest.mExtra = new Bundle();
        bleRequest.mHandler = new Handler(Looper.myLooper(), (Handler.Callback)this);
        bleRequest.mResponseHandler = new Handler(Looper.getMainLooper());
    }

    public String getAddress() {
        return this.mAddress;
    }

    public void setAddress(String string) {
        this.mAddress = string;
    }

    public void setWorker(IBleConnectWorker iBleConnectWorker) {
        this.mWorker = iBleConnectWorker;
    }

    public void onResponse(final int n) {
        if (this.mFinished) {
            return;
        }
        this.mFinished = true;
        this.mResponseHandler.post(new Runnable(){

            @Override
            public void run() {
                block3: {
                    if (BleRequest.this.mResponse == null) break block3;
                    try {
                        BleRequest.this.mResponse.onResponse(n, BleRequest.this.mExtra);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        });
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        return stringBuilder.toString();
    }

    public void putIntExtra(String string, int n) {
        this.mExtra.putInt(string, n);
    }

    public int getIntExtra(String string, int n) {
        return this.mExtra.getInt(string, n);
    }

    public void putByteArray(String string, byte[] byArray) {
        this.mExtra.putByteArray(string, byArray);
    }

    public void putParcelable(String string, Parcelable parcelable) {
        this.mExtra.putParcelable(string, parcelable);
    }

    public Bundle getExtra() {
        return this.mExtra;
    }

    public String getStatusText() {
        return Constants.getStatusText(this.getCurrentStatus());
    }

    @Override
    public boolean readDescriptor(UUID uUID, UUID uUID2, UUID uUID3) {
        return this.mWorker.readDescriptor(uUID, uUID2, uUID3);
    }

    @Override
    public boolean writeDescriptor(UUID uUID, UUID uUID2, UUID uUID3, byte[] byArray) {
        return this.mWorker.writeDescriptor(uUID, uUID2, uUID3, byArray);
    }

    public abstract void processRequest();

    @Override
    public boolean openGatt() {
        return this.mWorker.openGatt();
    }

    @Override
    public boolean discoverService() {
        return this.mWorker.discoverService();
    }

    @Override
    public int getCurrentStatus() {
        return this.mWorker.getCurrentStatus();
    }

    @Override
    public final void process(IBleConnectDispatcher objectArray) {
        this.checkRuntime();
        this.mDispatcher = objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray = objectArray2;
        objectArray[0] = this.getClass().getSimpleName();
        objectArray2[1] = this.getStatusText();
        BluetoothLog.w(WtUtil.format("Process %s, status = %s", objectArray));
        if (!BluetoothUtils.isBleSupported()) {
            this.onRequestCompleted(-4);
        } else {
            try {
                BleRequest bleRequest = this;
                bleRequest.registerGattResponseListener(bleRequest);
                bleRequest.processRequest();
            }
            catch (Throwable throwable) {
                BluetoothLog.e(throwable);
                this.onRequestCompleted(-10);
            }
        }
    }

    public void onRequestCompleted(int n) {
        BleRequest bleRequest = this;
        BleRequest bleRequest2 = this;
        bleRequest2.checkRuntime();
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n;
        bleRequest2.log(WtUtil.format("request complete: code = %d", objectArray2));
        bleRequest2.mHandler.removeCallbacksAndMessages(null);
        bleRequest2.clearGattResponseListener(bleRequest2);
        bleRequest.onResponse(n);
        bleRequest.mDispatcher.onRequestCompleted(this);
    }

    @Override
    public void closeGatt() {
        BleRequest bleRequest = this;
        bleRequest.log(WtUtil.format("close gatt", new Object[0]));
        bleRequest.mWorker.closeGatt();
    }

    @Override
    public void disconnect() {
        BleRequest bleRequest = this;
        bleRequest.log(WtUtil.format("disconnect gatt", new Object[0]));
        bleRequest.mWorker.disconnect();
    }

    public boolean handleMessage(Message message) {
        if (message.what == 32) {
            this.mRequestTimeout = true;
            this.closeGatt();
        }
        return true;
    }

    @Override
    public void requestConnectionPriority(int n) {
        this.mWorker.requestConnectionPriority(n);
    }

    @Override
    public void registerGattResponseListener(GattResponseListener gattResponseListener) {
        this.mWorker.registerGattResponseListener(gattResponseListener);
    }

    @Override
    public void clearGattResponseListener(GattResponseListener gattResponseListener) {
        this.mWorker.clearGattResponseListener(gattResponseListener);
    }

    @Override
    public boolean refreshDeviceCache() {
        return this.mWorker.refreshDeviceCache();
    }

    @Override
    public boolean readCharacteristic(UUID uUID, UUID uUID2) {
        return this.mWorker.readCharacteristic(uUID, uUID2);
    }

    @Override
    public boolean writeCharacteristic(UUID uUID, UUID uUID2, byte[] byArray) {
        return this.mWorker.writeCharacteristic(uUID, uUID2, byArray);
    }

    @Override
    public boolean writeCharacteristicWithNoRsp(UUID uUID, UUID uUID2, byte[] byArray) {
        return this.mWorker.writeCharacteristicWithNoRsp(uUID, uUID2, byArray);
    }

    @Override
    public boolean setCharacteristicNotification(UUID uUID, UUID uUID2, boolean bl) {
        return this.mWorker.setCharacteristicNotification(uUID, uUID2, bl);
    }

    @Override
    public boolean setCharacteristicIndication(UUID uUID, UUID uUID2, boolean bl) {
        return this.mWorker.setCharacteristicIndication(uUID, uUID2, bl);
    }

    @Override
    public void onBluetoothClosedDelay() {
        this.mWorker.onBluetoothClosedDelay();
    }

    @Override
    public boolean requestMTU(int n) {
        return this.mWorker.requestMTU(n);
    }

    @Override
    public boolean readRemoteRssi() {
        return this.mWorker.readRemoteRssi();
    }

    public void log(String string) {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.getClass().getSimpleName();
        objectArray[1] = this.getAddress();
        objectArray[2] = string;
        BluetoothLog.v(WtUtil.format("%s %s >>> %s", objectArray2));
    }

    public void setRuntimeChecker(RuntimeChecker runtimeChecker) {
        this.mRuntimeChecker = runtimeChecker;
    }

    @Override
    public void checkRuntime() {
        this.mRuntimeChecker.checkRuntime();
    }

    @Override
    public void cancel() {
        BleRequest bleRequest = this;
        bleRequest.checkRuntime();
        bleRequest.log(WtUtil.format("request canceled", new Object[0]));
        bleRequest.mHandler.removeCallbacksAndMessages(null);
        bleRequest.clearGattResponseListener(bleRequest);
        bleRequest.onResponse(-2);
    }

    public long getTimeoutInMillis() {
        return 30000L;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onConnectStatusChanged(boolean bl) {
        if (!bl) {
            void var1_4;
            if (this.mRequestTimeout) {
                int n = -7;
            } else {
                int n = -1;
            }
            this.onRequestCompleted((int)var1_4);
        }
    }

    public void startRequestTiming() {
        long l = this.getTimeoutInMillis();
        this.mHandler.sendEmptyMessageDelayed(32, l);
    }

    public void stopRequestTiming() {
        this.mHandler.removeMessages(32);
    }

    @Override
    public BleGattProfile getGattProfile() {
        return this.mWorker.getGattProfile();
    }
}

