/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.connect.request;

import android.bluetooth.BluetoothGattCharacteristic;
import com.tuya.sdk.blelib.connect.listener.ReadCharacterListener;
import com.tuya.sdk.blelib.connect.request.BleRequest;
import com.tuya.sdk.blelib.connect.response.BleGeneralResponse;
import java.util.UUID;

public class BleReadRequest
extends BleRequest
implements ReadCharacterListener {
    public UUID mServiceUUID;
    public UUID mCharacterUUID;

    public BleReadRequest(UUID uUID, UUID uUID2, BleGeneralResponse bleGeneralResponse) {
        super(bleGeneralResponse);
        this.mServiceUUID = uUID;
        this.mCharacterUUID = uUID2;
    }

    private void startRead() {
        BleReadRequest bleReadRequest = this;
        UUID uUID = bleReadRequest.mServiceUUID;
        if (!bleReadRequest.readCharacteristic(uUID, bleReadRequest.mCharacterUUID)) {
            this.onRequestCompleted(-1);
        } else {
            this.startRequestTiming();
        }
    }

    @Override
    public void processRequest() {
        int n = this.getCurrentStatus();
        if (n != 0) {
            if (n != 2) {
                if (n != 19) {
                    this.onRequestCompleted(-1);
                } else {
                    this.startRead();
                }
            } else {
                this.startRead();
            }
        } else {
            this.onRequestCompleted(-1);
        }
    }

    @Override
    public void onCharacteristicRead(BluetoothGattCharacteristic bluetoothGattCharacteristic, int n, byte[] byArray) {
        this.stopRequestTiming();
        if (n == 0) {
            BleReadRequest bleReadRequest = this;
            bleReadRequest.putByteArray("extra.byte.value", byArray);
            bleReadRequest.onRequestCompleted(0);
        } else {
            this.onRequestCompleted(-1);
        }
    }
}

