/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.connect.request;

import android.bluetooth.BluetoothGattDescriptor;
import com.tuya.sdk.blelib.connect.listener.ReadDescriptorListener;
import com.tuya.sdk.blelib.connect.request.BleRequest;
import com.tuya.sdk.blelib.connect.response.BleGeneralResponse;
import java.util.UUID;

public class BleReadDescriptorRequest
extends BleRequest
implements ReadDescriptorListener {
    public UUID mServiceUUID;
    public UUID mCharacterUUID;
    public UUID mDescriptorUUID;

    public BleReadDescriptorRequest(UUID uUID, UUID uUID2, UUID uUID3, BleGeneralResponse bleGeneralResponse) {
        super(bleGeneralResponse);
        this.mServiceUUID = uUID;
        this.mCharacterUUID = uUID2;
        this.mDescriptorUUID = uUID3;
    }

    private void startRead() {
        BleReadDescriptorRequest bleReadDescriptorRequest = this;
        UUID uUID = bleReadDescriptorRequest.mServiceUUID;
        UUID uUID2 = bleReadDescriptorRequest.mCharacterUUID;
        UUID uUID3 = bleReadDescriptorRequest.mDescriptorUUID;
        if (!bleReadDescriptorRequest.readDescriptor(uUID, uUID2, uUID3)) {
            this.onRequestCompleted(-1);
        } else {
            this.startRequestTiming();
        }
    }

    @Override
    public void processRequest() {
        int n = this.getCurrentStatus();
        if (n != 0) {
            if (n != 2) {
                if (n != 19) {
                    this.onRequestCompleted(-1);
                } else {
                    this.startRead();
                }
            } else {
                this.startRead();
            }
        } else {
            this.onRequestCompleted(-1);
        }
    }

    @Override
    public void onDescriptorRead(BluetoothGattDescriptor bluetoothGattDescriptor, int n, byte[] byArray) {
        this.stopRequestTiming();
        if (n == 0) {
            BleReadDescriptorRequest bleReadDescriptorRequest = this;
            bleReadDescriptorRequest.putByteArray("extra.byte.value", byArray);
            bleReadDescriptorRequest.onRequestCompleted(0);
        } else {
            this.onRequestCompleted(-1);
        }
    }
}

