/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.connect.request;

import android.bluetooth.BluetoothGattDescriptor;
import com.tuya.sdk.blelib.connect.listener.WriteDescriptorListener;
import com.tuya.sdk.blelib.connect.request.BleRequest;
import com.tuya.sdk.blelib.connect.response.BleGeneralResponse;
import java.util.UUID;

public class BleNotifyRequest
extends BleRequest
implements WriteDescriptorListener {
    public UUID mServiceUUID;
    public UUID mCharacterUUID;

    public BleNotifyRequest(UUID uUID, UUID uUID2, BleGeneralResponse bleGeneralResponse) {
        super(bleGeneralResponse);
        this.mServiceUUID = uUID;
        this.mCharacterUUID = uUID2;
    }

    private void openNotify() {
        BleNotifyRequest bleNotifyRequest = this;
        UUID uUID = bleNotifyRequest.mServiceUUID;
        if (!bleNotifyRequest.setCharacteristicNotification(uUID, bleNotifyRequest.mCharacterUUID, true)) {
            this.onRequestCompleted(-1);
        } else {
            this.startRequestTiming();
        }
    }

    @Override
    public void processRequest() {
        int n = this.getCurrentStatus();
        if (n != 0) {
            if (n != 2) {
                if (n != 19) {
                    this.onRequestCompleted(-1);
                } else {
                    this.openNotify();
                }
            } else {
                this.openNotify();
            }
        } else {
            this.onRequestCompleted(-1);
        }
    }

    @Override
    public void onDescriptorWrite(BluetoothGattDescriptor bluetoothGattDescriptor, int n) {
        this.stopRequestTiming();
        if (n == 0) {
            this.onRequestCompleted(0);
        } else {
            this.onRequestCompleted(-1);
        }
    }
}

