/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.connect.request;

import com.tuya.sdk.blelib.connect.listener.ServiceDiscoverListener;
import com.tuya.sdk.blelib.connect.request.BleRequest;
import com.tuya.sdk.blelib.connect.response.BleGeneralResponse;
import com.tuya.sdk.blelib.model.BleGattProfile;

public class BleDiscoveryServiceRequest
extends BleRequest
implements ServiceDiscoverListener {
    public BleDiscoveryServiceRequest(BleGeneralResponse bleGeneralResponse) {
        super(bleGeneralResponse);
    }

    private void startDiscovery() {
        if (!this.discoverService()) {
            this.onRequestCompleted(-1);
        } else {
            this.startRequestTiming();
        }
    }

    private void onConnectSuccess() {
        BleGattProfile bleGattProfile = this.getGattProfile();
        if (bleGattProfile != null) {
            this.putParcelable("extra.gatt.profile", bleGattProfile);
        }
        this.onRequestCompleted(0);
    }

    @Override
    public void processRequest() {
        int n = this.getCurrentStatus();
        if (n != 0) {
            if (n != 2) {
                if (n != 19) {
                    this.onRequestCompleted(-1);
                } else {
                    this.startDiscovery();
                }
            } else {
                this.startDiscovery();
            }
        } else {
            this.onRequestCompleted(-1);
        }
    }

    @Override
    public void onServicesDiscovered(int n, BleGattProfile bleGattProfile) {
        this.stopRequestTiming();
        if (n == 0) {
            this.onConnectSuccess();
        } else {
            this.onRequestCompleted(-1);
        }
    }
}

