/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.connect.request;

import android.os.Message;
import com.tuya.sdk.blelib.connect.listener.ServiceDiscoverListener;
import com.tuya.sdk.blelib.connect.options.BleConnectOptions;
import com.tuya.sdk.blelib.connect.request.BleRequest;
import com.tuya.sdk.blelib.connect.response.BleGeneralResponse;
import com.tuya.sdk.blelib.model.BleGattProfile;
import com.tuya.sdk.blelib.utils.BluetoothLog;
import com.tuya.sdk.blelib.utils.WtUtil;

public class BleConnectRequest
extends BleRequest
implements ServiceDiscoverListener {
    public static final int MSG_CONNECT = 1;
    public static final int MSG_DISCOVER_SERVICE = 2;
    public static final int MSG_CONNECT_TIMEOUT = 3;
    public static final int MSG_DISCOVER_SERVICE_TIMEOUT = 4;
    public static final int MSG_RETRY_DISCOVER_SERVICE = 5;
    public BleConnectOptions mConnectOptions;
    public int mConnectCount;
    public int mServiceDiscoverCount;

    public BleConnectRequest(BleConnectOptions bleConnectOptions, BleGeneralResponse bleGeneralResponse) {
        super(bleGeneralResponse);
        if (bleConnectOptions == null) {
            bleConnectOptions = new BleConnectOptions.Builder().build();
        }
        this.mConnectOptions = bleConnectOptions;
    }

    private void processConnect() {
        BleConnectRequest bleConnectRequest = this;
        bleConnectRequest.mHandler.removeCallbacksAndMessages(null);
        bleConnectRequest.mServiceDiscoverCount = 0;
        int n = bleConnectRequest.getCurrentStatus();
        if (n != 0) {
            if (n != 2) {
                if (n == 19) {
                    this.onConnectSuccess();
                }
            } else {
                this.processDiscoverService();
            }
        } else if (!this.doOpenNewGatt()) {
            this.closeGatt();
        } else {
            long l = this.mConnectOptions.getConnectTimeout();
            this.mHandler.sendEmptyMessageDelayed(3, l);
        }
    }

    private boolean doOpenNewGatt() {
        BleConnectRequest bleConnectRequest = this;
        ++bleConnectRequest.mConnectCount;
        return bleConnectRequest.openGatt();
    }

    private boolean doDiscoverService() {
        BleConnectRequest bleConnectRequest = this;
        ++bleConnectRequest.mServiceDiscoverCount;
        return bleConnectRequest.discoverService();
    }

    private void retryConnectIfNeeded() {
        if (this.mConnectCount < this.mConnectOptions.getConnectRetry() + 1) {
            this.retryConnectLater();
        } else {
            this.onRequestCompleted(-1);
        }
    }

    private void retryDiscoverServiceIfNeeded() {
        if (this.mServiceDiscoverCount < this.mConnectOptions.getServiceDiscoverRetry() + 1) {
            this.retryDiscoverServiceLater();
        } else {
            this.disconnect();
        }
    }

    private void onServiceDiscoverFailed() {
        BleConnectRequest bleConnectRequest = this;
        BluetoothLog.v(WtUtil.format("onServiceDiscoverFailed", new Object[0]));
        bleConnectRequest.refreshDeviceCache();
        bleConnectRequest.mHandler.sendEmptyMessage(5);
    }

    private void processDiscoverService() {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = this.getStatusText();
        BluetoothLog.v(WtUtil.format("processDiscoverService, status = %s", objectArray2));
        int n = this.getCurrentStatus();
        if (n != 0) {
            if (n != 2) {
                if (n == 19) {
                    this.onConnectSuccess();
                }
            } else if (!this.doDiscoverService()) {
                this.onServiceDiscoverFailed();
            } else {
                long l = this.mConnectOptions.getServiceDiscoverTimeout();
                this.mHandler.sendEmptyMessageDelayed(4, l);
            }
        } else {
            this.retryConnectIfNeeded();
        }
    }

    private void retryConnectLater() {
        BleConnectRequest bleConnectRequest = this;
        bleConnectRequest.log(WtUtil.format("retry connect later", new Object[0]));
        bleConnectRequest.mHandler.removeCallbacksAndMessages(null);
        bleConnectRequest.mHandler.sendEmptyMessageDelayed(1, 1000L);
    }

    private void retryDiscoverServiceLater() {
        BleConnectRequest bleConnectRequest = this;
        bleConnectRequest.log(WtUtil.format("retry discover service later", new Object[0]));
        bleConnectRequest.mHandler.removeCallbacksAndMessages(null);
        bleConnectRequest.mHandler.sendEmptyMessageDelayed(2, 1000L);
    }

    private void processConnectTimeout() {
        BleConnectRequest bleConnectRequest = this;
        bleConnectRequest.log(WtUtil.format("connect timeout", new Object[0]));
        bleConnectRequest.mHandler.removeCallbacksAndMessages(null);
        bleConnectRequest.closeGatt();
    }

    private void processDiscoverServiceTimeout() {
        BleConnectRequest bleConnectRequest = this;
        bleConnectRequest.log(WtUtil.format("service discover timeout", new Object[0]));
        bleConnectRequest.mHandler.removeCallbacksAndMessages(null);
        bleConnectRequest.disconnect();
    }

    private void onConnectSuccess() {
        BleGattProfile bleGattProfile = this.getGattProfile();
        if (bleGattProfile != null) {
            this.putParcelable("extra.gatt.profile", bleGattProfile);
        }
        this.onRequestCompleted(0);
    }

    @Override
    public void processRequest() {
        this.processConnect();
    }

    @Override
    public boolean handleMessage(Message message) {
        switch (message.what) {
            default: {
                break;
            }
            case 5: {
                this.retryDiscoverServiceIfNeeded();
                break;
            }
            case 4: {
                this.processDiscoverServiceTimeout();
                break;
            }
            case 3: {
                this.processConnectTimeout();
                break;
            }
            case 2: {
                this.processDiscoverService();
                break;
            }
            case 1: {
                this.processConnect();
            }
        }
        return super.handleMessage(message);
    }

    @Override
    public String toString() {
        return "BleConnectRequest{options=" + this.mConnectOptions + '}';
    }

    @Override
    public void onConnectStatusChanged(boolean bl) {
        BleConnectRequest bleConnectRequest = this;
        bleConnectRequest.checkRuntime();
        bleConnectRequest.mHandler.removeMessages(3);
        if (bl) {
            this.mHandler.sendEmptyMessageDelayed(2, 300L);
        } else {
            BleConnectRequest bleConnectRequest2 = this;
            bleConnectRequest2.mHandler.removeCallbacksAndMessages(null);
            bleConnectRequest2.retryConnectIfNeeded();
        }
    }

    @Override
    public void onServicesDiscovered(int n, BleGattProfile bleGattProfile) {
        BleConnectRequest bleConnectRequest = this;
        bleConnectRequest.checkRuntime();
        bleConnectRequest.mHandler.removeMessages(4);
        if (n == 0) {
            this.onConnectSuccess();
        } else {
            this.onServiceDiscoverFailed();
        }
    }
}

