/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.connect;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.tuya.sdk.blelib.Constants;
import com.tuya.sdk.blelib.RuntimeChecker;
import com.tuya.sdk.blelib.connect.IBleConnectWorker;
import com.tuya.sdk.blelib.connect.listener.GattResponseListener;
import com.tuya.sdk.blelib.connect.listener.IBluetoothGattResponse;
import com.tuya.sdk.blelib.connect.listener.ReadCharacterListener;
import com.tuya.sdk.blelib.connect.listener.ReadDescriptorListener;
import com.tuya.sdk.blelib.connect.listener.ReadRssiListener;
import com.tuya.sdk.blelib.connect.listener.RequestMtuListener;
import com.tuya.sdk.blelib.connect.listener.ServiceDiscoverListener;
import com.tuya.sdk.blelib.connect.listener.WriteCharacterListener;
import com.tuya.sdk.blelib.connect.listener.WriteDescriptorListener;
import com.tuya.sdk.blelib.connect.request.BleConnectRequest;
import com.tuya.sdk.blelib.connect.response.BluetoothGattResponse;
import com.tuya.sdk.blelib.model.BleGattProfile;
import com.tuya.sdk.blelib.utils.BluetoothLog;
import com.tuya.sdk.blelib.utils.BluetoothUtils;
import com.tuya.sdk.blelib.utils.ByteUtils;
import com.tuya.sdk.blelib.utils.Version;
import com.tuya.sdk.blelib.utils.WtUtil;
import com.tuya.sdk.blelib.utils.proxy.ProxyBulk;
import com.tuya.sdk.blelib.utils.proxy.ProxyInterceptor;
import com.tuya.sdk.blelib.utils.proxy.ProxyUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class BleConnectWorker
implements Handler.Callback,
IBleConnectWorker,
IBluetoothGattResponse,
ProxyInterceptor,
RuntimeChecker {
    public static final int MSG_GATT_RESPONSE = 288;
    public BluetoothGatt mBluetoothGatt;
    public BluetoothDevice mBluetoothDevice;
    public GattResponseListener mGattResponseListener;
    public Handler mWorkerHandler;
    public volatile int mConnectStatus;
    public BleGattProfile mBleGattProfile;
    public Map<UUID, Map<UUID, BluetoothGattCharacteristic>> mDeviceProfile;
    public IBluetoothGattResponse mBluetoothGattResponse;
    public RuntimeChecker mRuntimeChecker;

    public BleConnectWorker(String string, RuntimeChecker runtimeChecker) {
        BluetoothAdapter bluetoothAdapter = BluetoothUtils.getBluetoothAdapter();
        if (bluetoothAdapter != null) {
            this.mBluetoothDevice = bluetoothAdapter.getRemoteDevice(string);
            this.mRuntimeChecker = runtimeChecker;
            this.mWorkerHandler = new Handler(Looper.myLooper(), (Handler.Callback)this);
            this.mDeviceProfile = new HashMap<UUID, Map<UUID, BluetoothGattCharacteristic>>();
            this.mBluetoothGattResponse = (IBluetoothGattResponse)ProxyUtils.getProxy(this, IBluetoothGattResponse.class, this);
            return;
        }
        throw new IllegalStateException("ble adapter null");
    }

    private void refreshServiceProfile() {
        HashMap hashMap;
        Object[] objectArray = new Object[1];
        Object object = objectArray;
        objectArray[0] = this.mBluetoothDevice.getAddress();
        BluetoothLog.v(WtUtil.format("refreshServiceProfile for %s", (Object[])object));
        object = hashMap;
        hashMap = new HashMap();
        for (Object object2 : this.mBluetoothGatt.getServices()) {
            UUID uUID = object2.getUuid();
            Map map = (Map)object.get(uUID);
            if (map == null) {
                HashMap hashMap2;
                BluetoothLog.v("Service: " + uUID);
                map = hashMap2;
                hashMap2 = new HashMap();
                object.put(object2.getUuid(), map);
            }
            object2 = object2.getCharacteristics().iterator();
            while (object2.hasNext()) {
                uUID = (BluetoothGattCharacteristic)object2.next();
                BluetoothLog.v("character: uuid = " + uUID.getUuid());
                map.put(uUID.getUuid(), uUID);
            }
        }
        BleConnectWorker bleConnectWorker = this;
        bleConnectWorker.mDeviceProfile.clear();
        bleConnectWorker.mDeviceProfile.putAll((Map<UUID, Map<UUID, BluetoothGattCharacteristic>>)object);
        bleConnectWorker.mBleGattProfile = new BleGattProfile(this.mDeviceProfile);
    }

    private BluetoothGattCharacteristic getCharacter(UUID uUID, UUID uUID2) {
        Map<UUID, BluetoothGattCharacteristic> map;
        BluetoothGattCharacteristic bluetoothGattCharacteristic = null;
        if (uUID != null && uUID2 != null && (map = this.mDeviceProfile.get(uUID)) != null) {
            bluetoothGattCharacteristic = map.get(uUID2);
        }
        if (bluetoothGattCharacteristic == null && (this = this.mBluetoothGatt) != null && (this = this.getService(uUID)) != null) {
            bluetoothGattCharacteristic = this.getCharacteristic(uUID2);
        }
        return bluetoothGattCharacteristic;
    }

    private void setConnectStatus(int n) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = Constants.getStatusText(n);
        BluetoothLog.v(WtUtil.format("setConnectStatus status = %s", objectArray3));
        objectArray.mConnectStatus = n;
    }

    private void broadcastConnectStatus(int n) {
        Intent intent = new Intent("action.connect_status_changed");
        intent.putExtra("extra.mac", this.mBluetoothDevice.getAddress());
        intent.putExtra("extra.status", n);
        BluetoothUtils.sendBroadcast(intent);
    }

    private void broadcastCharacterChanged(UUID uUID, UUID uUID2, byte[] byArray) {
        Intent intent = new Intent("action.character_changed");
        intent.putExtra("extra.mac", this.mBluetoothDevice.getAddress());
        intent.putExtra("extra.service.uuid", (Serializable)uUID);
        intent.putExtra("extra.character.uuid", (Serializable)uUID2);
        intent.putExtra("extra.byte.value", byArray);
        BluetoothUtils.sendBroadcast(intent);
    }

    private BluetoothGatt connectGattApi21(Context context, BluetoothDevice bluetoothDevice, BluetoothGattCallback bluetoothGattCallback) {
        Class<?> clazz;
        try {
            clazz = bluetoothDevice.getClass();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return bluetoothDevice.connectGatt(context, false, bluetoothGattCallback);
        }
        Class[] classArray = new Class[4];
        classArray[0] = Context.class;
        classArray[1] = Boolean.TYPE;
        classArray[2] = BluetoothGattCallback.class;
        classArray[3] = Integer.TYPE;
        Method method = clazz.getMethod("connectGatt", classArray);
        BluetoothDevice bluetoothDevice2 = bluetoothDevice;
        BluetoothLog.w("gatt = device.connectGatt(autoConnect = false, TRANSPORT_LE) (hidden)");
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = objectArray;
        Object[] objectArray4 = objectArray;
        Object[] objectArray5 = objectArray;
        objectArray[0] = context;
        objectArray3[1] = false;
        objectArray4[2] = bluetoothGattCallback;
        objectArray5[3] = 2;
        return (BluetoothGatt)method.invoke((Object)bluetoothDevice2, objectArray2);
    }

    private String getAddress() {
        return this.mBluetoothDevice.getAddress();
    }

    private boolean isCharacteristicReadable(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        return bluetoothGattCharacteristic != null && (bluetoothGattCharacteristic.getProperties() & 2) != 0;
    }

    private boolean isCharacteristicWritable(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        return bluetoothGattCharacteristic != null && (bluetoothGattCharacteristic.getProperties() & 8) != 0;
    }

    private boolean isCharacteristicNoRspWritable(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        return bluetoothGattCharacteristic != null && (bluetoothGattCharacteristic.getProperties() & 4) != 0;
    }

    private boolean isCharacteristicNotifyable(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        return bluetoothGattCharacteristic != null && (bluetoothGattCharacteristic.getProperties() & 0x10) != 0;
    }

    private boolean isCharacteristicIndicatable(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        return bluetoothGattCharacteristic != null && (bluetoothGattCharacteristic.getProperties() & 0x20) != 0;
    }

    @Override
    public void onConnectionStateChange(int n, int n2) {
        ((BleConnectWorker)((Object)gattResponseListener)).checkRuntime();
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = ((BleConnectWorker)((Object)gattResponseListener)).mBluetoothDevice.getAddress();
        objectArray2[1] = n;
        objectArray[2] = n2;
        BluetoothLog.ii(WtUtil.format("tyble_lib_onConnectionStateChange for %s: status = %d, newState = %d", objectArray2));
        if (n == 0 && n2 == 2) {
            BleConnectWorker bleConnectWorker = gattResponseListener;
            bleConnectWorker.setConnectStatus(2);
            GattResponseListener gattResponseListener = bleConnectWorker.mGattResponseListener;
            if (gattResponseListener != null) {
                gattResponseListener.onConnectStatusChanged(true);
            }
        } else {
            ((BleConnectWorker)((Object)gattResponseListener)).closeGatt();
        }
    }

    @Override
    public void onServicesDiscovered(int n) {
        this.checkRuntime();
        Object[] objectArray = new Object[2];
        Object object = objectArray;
        object[0] = this.mBluetoothDevice.getAddress();
        objectArray[1] = n;
        BluetoothLog.v(WtUtil.format("onServicesDiscovered for %s: status = %d", object));
        if (n == 0) {
            BleConnectWorker bleConnectWorker = this;
            bleConnectWorker.setConnectStatus(19);
            if (bleConnectWorker.mGattResponseListener instanceof BleConnectRequest) {
                this.broadcastConnectStatus(16);
            }
            this.refreshServiceProfile();
        }
        if ((object = this.mGattResponseListener) instanceof ServiceDiscoverListener) {
            ((ServiceDiscoverListener)object).onServicesDiscovered(n, this.mBleGattProfile);
        }
    }

    @Override
    public void onCharacteristicRead(BluetoothGattCharacteristic bluetoothGattCharacteristic, int n, byte[] byArray) {
        BleConnectWorker bleConnectWorker = gattResponseListener;
        bleConnectWorker.checkRuntime();
        Object[] objectArray = new Object[5];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = ((BleConnectWorker)((Object)gattResponseListener)).mBluetoothDevice.getAddress();
        objectArray2[1] = n;
        objectArray2[2] = bluetoothGattCharacteristic.getService().getUuid();
        objectArray2[3] = bluetoothGattCharacteristic.getUuid();
        objectArray[4] = ByteUtils.byteToString(byArray);
        BluetoothLog.v(WtUtil.format("onCharacteristicRead for %s: status = %d, service = 0x%s, character = 0x%s, value = %s", objectArray2));
        GattResponseListener gattResponseListener = bleConnectWorker.mGattResponseListener;
        if (gattResponseListener instanceof ReadCharacterListener) {
            ((ReadCharacterListener)gattResponseListener).onCharacteristicRead(bluetoothGattCharacteristic, n, byArray);
        }
    }

    @Override
    public void onCharacteristicWrite(BluetoothGattCharacteristic bluetoothGattCharacteristic, int n, byte[] byArray) {
        BleConnectWorker bleConnectWorker = gattResponseListener;
        bleConnectWorker.checkRuntime();
        Object[] objectArray = new Object[5];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = ((BleConnectWorker)((Object)gattResponseListener)).mBluetoothDevice.getAddress();
        objectArray2[1] = n;
        objectArray2[2] = bluetoothGattCharacteristic.getService().getUuid();
        objectArray2[3] = bluetoothGattCharacteristic.getUuid();
        objectArray[4] = ByteUtils.byteToString(byArray);
        BluetoothLog.v(WtUtil.format("onCharacteristicWrite for %s: status = %d, service = 0x%s, character = 0x%s, value = %s", objectArray2));
        GattResponseListener gattResponseListener = bleConnectWorker.mGattResponseListener;
        if (gattResponseListener instanceof WriteCharacterListener) {
            ((WriteCharacterListener)gattResponseListener).onCharacteristicWrite(bluetoothGattCharacteristic, n, byArray);
        }
    }

    @Override
    public void onCharacteristicChanged(BluetoothGattCharacteristic bluetoothGattCharacteristic, byte[] byArray) {
        BleConnectWorker bleConnectWorker = uUID;
        BluetoothGattCharacteristic bluetoothGattCharacteristic2 = bluetoothGattCharacteristic;
        ((BleConnectWorker)((Object)uUID)).checkRuntime();
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = ((BleConnectWorker)((Object)uUID)).mBluetoothDevice.getAddress();
        objectArray2[1] = ByteUtils.byteToString(byArray);
        objectArray2[2] = bluetoothGattCharacteristic.getService().getUuid();
        objectArray[3] = bluetoothGattCharacteristic.getUuid();
        BluetoothLog.v(WtUtil.format("onCharacteristicChanged for %s: value = %s, service = 0x%s, character = 0x%s", objectArray2));
        UUID uUID = bluetoothGattCharacteristic2.getService().getUuid();
        bleConnectWorker.broadcastCharacterChanged(uUID, bluetoothGattCharacteristic2.getUuid(), byArray);
    }

    @Override
    public void onDescriptorRead(BluetoothGattDescriptor bluetoothGattDescriptor, int n, byte[] byArray) {
        BleConnectWorker bleConnectWorker = gattResponseListener;
        bleConnectWorker.checkRuntime();
        Object[] objectArray = new Object[5];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = ((BleConnectWorker)((Object)gattResponseListener)).mBluetoothDevice.getAddress();
        objectArray2[1] = n;
        objectArray2[2] = bluetoothGattDescriptor.getCharacteristic().getService().getUuid();
        objectArray2[3] = bluetoothGattDescriptor.getCharacteristic().getUuid();
        objectArray[4] = bluetoothGattDescriptor.getUuid();
        BluetoothLog.v(WtUtil.format("onDescriptorRead for %s: status = %d, service = 0x%s, character = 0x%s, descriptor = 0x%s", objectArray2));
        GattResponseListener gattResponseListener = bleConnectWorker.mGattResponseListener;
        if (gattResponseListener instanceof ReadDescriptorListener) {
            ((ReadDescriptorListener)gattResponseListener).onDescriptorRead(bluetoothGattDescriptor, n, byArray);
        }
    }

    @Override
    public void onDescriptorWrite(BluetoothGattDescriptor bluetoothGattDescriptor, int n) {
        BleConnectWorker bleConnectWorker = gattResponseListener;
        bleConnectWorker.checkRuntime();
        Object[] objectArray = new Object[5];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = ((BleConnectWorker)((Object)gattResponseListener)).mBluetoothDevice.getAddress();
        objectArray2[1] = n;
        objectArray2[2] = bluetoothGattDescriptor.getCharacteristic().getService().getUuid();
        objectArray2[3] = bluetoothGattDescriptor.getCharacteristic().getUuid();
        objectArray[4] = bluetoothGattDescriptor.getUuid();
        BluetoothLog.v(WtUtil.format("onDescriptorWrite for %s: status = %d, service = 0x%s, character = 0x%s, descriptor = 0x%s", objectArray2));
        GattResponseListener gattResponseListener = bleConnectWorker.mGattResponseListener;
        if (gattResponseListener instanceof WriteDescriptorListener) {
            ((WriteDescriptorListener)gattResponseListener).onDescriptorWrite(bluetoothGattDescriptor, n);
        }
    }

    @Override
    public void onReadRemoteRssi(int n, int n2) {
        BleConnectWorker bleConnectWorker = gattResponseListener;
        bleConnectWorker.checkRuntime();
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = ((BleConnectWorker)((Object)gattResponseListener)).mBluetoothDevice.getAddress();
        objectArray2[1] = n;
        objectArray[2] = n2;
        BluetoothLog.v(WtUtil.format("onReadRemoteRssi for %s, rssi = %d, status = %d", objectArray2));
        GattResponseListener gattResponseListener = bleConnectWorker.mGattResponseListener;
        if (gattResponseListener instanceof ReadRssiListener) {
            ((ReadRssiListener)gattResponseListener).onReadRemoteRssi(n, n2);
        }
    }

    @Override
    public void onMtuChanged(int n, int n2) {
        BleConnectWorker bleConnectWorker = gattResponseListener;
        bleConnectWorker.checkRuntime();
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = ((BleConnectWorker)((Object)gattResponseListener)).mBluetoothDevice.getAddress();
        objectArray2[1] = n;
        objectArray[2] = n2;
        BluetoothLog.v(WtUtil.format("onMtuChanged for %s, mtu = %d, status = %d", objectArray2));
        GattResponseListener gattResponseListener = bleConnectWorker.mGattResponseListener;
        if (gattResponseListener instanceof RequestMtuListener) {
            ((RequestMtuListener)gattResponseListener).onMtuChanged(n, n2);
        }
    }

    @Override
    public boolean openGatt() {
        BluetoothGattResponse bluetoothGattResponse;
        BleConnectWorker bleConnectWorker = this;
        bleConnectWorker.checkRuntime();
        Context context = new Object[1];
        Context context2 = context;
        context[0] = this.getAddress();
        BluetoothLog.v(WtUtil.format("openGatt for %s", (Object[])context2));
        if (bleConnectWorker.mBluetoothGatt != null) {
            BluetoothLog.e(WtUtil.format("Previous gatt not closed", new Object[0]));
            return false;
        }
        context2 = BluetoothUtils.getContext();
        BluetoothGattResponse bluetoothGattResponse2 = bluetoothGattResponse;
        bluetoothGattResponse = new BluetoothGattResponse(this.mBluetoothGattResponse);
        this.mBluetoothGatt = Version.isMarshmallow() ? this.mBluetoothDevice.connectGatt(context2, false, (BluetoothGattCallback)bluetoothGattResponse2, 2) : (Version.isHighLollipop() ? this.connectGattApi21(context2, this.mBluetoothDevice, bluetoothGattResponse2) : this.mBluetoothDevice.connectGatt(context2, false, (BluetoothGattCallback)bluetoothGattResponse2));
        if (this.mBluetoothGatt == null) {
            BluetoothLog.e(WtUtil.format("openGatt failed: connectGatt return null!", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void closeGatt() {
        BleConnectWorker bleConnectWorker = this;
        bleConnectWorker.checkRuntime();
        BluetoothGatt bluetoothGatt = new Object[1];
        Object object = bluetoothGatt;
        bluetoothGatt[0] = this.getAddress();
        BluetoothLog.v(WtUtil.format("closeGatt for %s", (Object[])object));
        object = bleConnectWorker.mBluetoothGatt;
        if (object != null) {
            object.close();
            this.mBluetoothGatt = null;
        }
        if ((object = this.mGattResponseListener) != null) {
            object.onConnectStatusChanged(false);
        }
        BleConnectWorker bleConnectWorker2 = this;
        bleConnectWorker2.setConnectStatus(0);
        bleConnectWorker2.broadcastConnectStatus(32);
    }

    @Override
    public void disconnect() {
        BleConnectWorker bleConnectWorker = this;
        bleConnectWorker.checkRuntime();
        BluetoothGatt bluetoothGatt = new Object[1];
        BluetoothGatt bluetoothGatt2 = bluetoothGatt;
        bluetoothGatt[0] = this.getAddress();
        BluetoothLog.v(WtUtil.format("disconnect for %s", (Object[])bluetoothGatt2));
        bluetoothGatt2 = bleConnectWorker.mBluetoothGatt;
        if (bluetoothGatt2 != null) {
            bluetoothGatt2.disconnect();
        } else {
            BluetoothLog.e(WtUtil.format("disconnect but gatt is null!", new Object[0]));
        }
        this.setConnectStatus(0);
    }

    @Override
    public boolean discoverService() {
        BleConnectWorker bleConnectWorker = bleConnectWorker2;
        bleConnectWorker.checkRuntime();
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = bleConnectWorker2.getAddress();
        BluetoothLog.v(WtUtil.format("discoverService for %s", objectArray2));
        BleConnectWorker bleConnectWorker2 = bleConnectWorker.mBluetoothGatt;
        if (bleConnectWorker2 == null) {
            BluetoothLog.e(WtUtil.format("discoverService but gatt is null!", new Object[0]));
            return false;
        }
        if (!bleConnectWorker2.discoverServices()) {
            BluetoothLog.e(WtUtil.format("discoverServices failed", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void requestConnectionPriority(int n) {
        if (this.mBluetoothGatt == null) {
            BluetoothLog.e(WtUtil.format("discoverService but gatt is null!", new Object[0]));
            return;
        }
        if (Version.isHighLollipop()) {
            this.mBluetoothGatt.requestConnectionPriority(n);
        }
    }

    @Override
    public void onBluetoothClosedDelay() {
        BluetoothLog.ii("tyble_onBluetoothStateChanged closed, status = " + this.getCurrentStatus() + ", delay enable =" + BluetoothUtils.isBluetoothEnabled());
        if (!BluetoothUtils.isBluetoothEnabled() && this.getCurrentStatus() != 0) {
            this.closeGatt();
        }
    }

    @Override
    public boolean requestMTU(int n) {
        BleConnectWorker bleConnectWorker = this;
        bleConnectWorker.checkRuntime();
        if (bleConnectWorker.mBluetoothGatt == null) {
            BluetoothLog.e(WtUtil.format("discoverService but gatt is null!", new Object[0]));
            return false;
        }
        if (Version.isHighLollipop()) {
            return this.mBluetoothGatt.requestMtu(n);
        }
        return false;
    }

    @Override
    public int getCurrentStatus() {
        BleConnectWorker bleConnectWorker = this;
        bleConnectWorker.checkRuntime();
        return bleConnectWorker.mConnectStatus;
    }

    @Override
    public void registerGattResponseListener(GattResponseListener gattResponseListener) {
        this.checkRuntime();
        this.mGattResponseListener = gattResponseListener;
    }

    @Override
    public void clearGattResponseListener(GattResponseListener gattResponseListener) {
        BleConnectWorker bleConnectWorker = this;
        bleConnectWorker.checkRuntime();
        if (bleConnectWorker.mGattResponseListener == gattResponseListener) {
            this.mGattResponseListener = null;
        }
    }

    @Override
    public boolean refreshDeviceCache() {
        BleConnectWorker bleConnectWorker = bleConnectWorker2;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = bleConnectWorker2.getAddress();
        BluetoothLog.v(WtUtil.format("refreshDeviceCache for %s", objectArray2));
        bleConnectWorker.checkRuntime();
        BleConnectWorker bleConnectWorker2 = bleConnectWorker.mBluetoothGatt;
        if (bleConnectWorker2 == null) {
            BluetoothLog.e(WtUtil.format("ble gatt null", new Object[0]));
            return false;
        }
        if (!BluetoothUtils.refreshGattCache((BluetoothGatt)bleConnectWorker2)) {
            BluetoothLog.e(WtUtil.format("refreshDeviceCache failed", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public boolean readCharacteristic(UUID uUID, UUID uUID2) {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = bleConnectWorker.mBluetoothDevice.getAddress();
        objectArray[1] = uUID;
        objectArray[2] = uUID2;
        BluetoothLog.v(WtUtil.format("readCharacteristic for %s: service = 0x%s, character = 0x%s", objectArray2));
        bleConnectWorker.checkRuntime();
        uUID = bleConnectWorker.getCharacter(uUID, uUID2);
        if (uUID == null) {
            BluetoothLog.e(WtUtil.format("characteristic not exist!", new Object[0]));
            return false;
        }
        BleConnectWorker bleConnectWorker = bleConnectWorker.mBluetoothGatt;
        if (bleConnectWorker == null) {
            BluetoothLog.e(WtUtil.format("ble gatt null", new Object[0]));
            return false;
        }
        if (!bleConnectWorker.readCharacteristic((BluetoothGattCharacteristic)uUID)) {
            BluetoothLog.e(WtUtil.format("readCharacteristic failed", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public boolean writeCharacteristic(UUID uUID, UUID uUID2, byte[] byArray) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[4];
        Object[] objectArray3 = objectArray = objectArray2;
        objectArray3[0] = this.mBluetoothDevice.getAddress();
        objectArray3[1] = uUID;
        objectArray[2] = uUID2;
        objectArray2[3] = ByteUtils.byteToString(byArray);
        BluetoothLog.v(WtUtil.format("writeCharacteristic for %s: service = 0x%s, character = 0x%s, value = 0x%s", objectArray));
        this.checkRuntime();
        uUID = this.getCharacter(uUID, uUID2);
        if (uUID == null) {
            BluetoothLog.e(WtUtil.format("characteristic not exist!", new Object[0]));
            return false;
        }
        if (this.mBluetoothGatt == null) {
            BluetoothLog.e(WtUtil.format("ble gatt null", new Object[0]));
            return false;
        }
        if (byArray == null) {
            byArray = ByteUtils.EMPTY_BYTES;
        }
        uUID.setValue(byArray);
        if (!this.mBluetoothGatt.writeCharacteristic((BluetoothGattCharacteristic)uUID)) {
            BluetoothLog.e(WtUtil.format("writeCharacteristic failed", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public boolean readDescriptor(UUID uUID, UUID uUID2, UUID uUID3) {
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray[0] = bleConnectWorker.mBluetoothDevice.getAddress();
        objectArray[1] = uUID;
        objectArray[2] = uUID2;
        objectArray[3] = uUID3;
        BluetoothLog.v(WtUtil.format("readDescriptor for %s: service = 0x%s, character = 0x%s, descriptor = 0x%s", objectArray2));
        bleConnectWorker.checkRuntime();
        uUID = bleConnectWorker.getCharacter(uUID, uUID2);
        if (uUID == null) {
            BluetoothLog.e(WtUtil.format("characteristic not exist!", new Object[0]));
            return false;
        }
        if ((uUID = uUID.getDescriptor(uUID3)) == null) {
            BluetoothLog.e(WtUtil.format("descriptor not exist", new Object[0]));
            return false;
        }
        BleConnectWorker bleConnectWorker = bleConnectWorker.mBluetoothGatt;
        if (bleConnectWorker == null) {
            BluetoothLog.e(WtUtil.format("ble gatt null", new Object[0]));
            return false;
        }
        if (!bleConnectWorker.readDescriptor((BluetoothGattDescriptor)uUID)) {
            BluetoothLog.e(WtUtil.format("readDescriptor failed", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public boolean writeDescriptor(UUID uUID, UUID uUID2, UUID uUID3, byte[] byArray) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[5];
        Object[] objectArray3 = objectArray = objectArray2;
        Object[] objectArray4 = objectArray;
        objectArray3[0] = this.mBluetoothDevice.getAddress();
        objectArray4[1] = uUID;
        objectArray3[2] = uUID2;
        objectArray4[3] = uUID3;
        objectArray2[4] = ByteUtils.byteToString(byArray);
        BluetoothLog.v(WtUtil.format("writeDescriptor for %s: service = 0x%s, character = 0x%s, descriptor = 0x%s, value = 0x%s", objectArray));
        this.checkRuntime();
        uUID = this.getCharacter(uUID, uUID2);
        if (uUID == null) {
            BluetoothLog.e(WtUtil.format("characteristic not exist!", new Object[0]));
            return false;
        }
        if ((uUID = uUID.getDescriptor(uUID3)) == null) {
            BluetoothLog.e(WtUtil.format("descriptor not exist", new Object[0]));
            return false;
        }
        if (this.mBluetoothGatt == null) {
            BluetoothLog.e(WtUtil.format("ble gatt null", new Object[0]));
            return false;
        }
        if (byArray == null) {
            byArray = ByteUtils.EMPTY_BYTES;
        }
        uUID.setValue(byArray);
        if (!this.mBluetoothGatt.writeDescriptor((BluetoothGattDescriptor)uUID)) {
            BluetoothLog.e(WtUtil.format("writeDescriptor failed", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public boolean writeCharacteristicWithNoRsp(UUID uUID, UUID uUID2, byte[] byArray) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[4];
        Object[] objectArray3 = objectArray = objectArray2;
        objectArray3[0] = this.mBluetoothDevice.getAddress();
        objectArray3[1] = uUID;
        objectArray[2] = uUID2;
        objectArray2[3] = ByteUtils.byteToString(byArray);
        BluetoothLog.v(WtUtil.format("writeCharacteristicWithNoRsp for %s: service = 0x%s, character = 0x%s, value = 0x%s", objectArray));
        this.checkRuntime();
        uUID = this.getCharacter(uUID, uUID2);
        if (uUID == null) {
            BluetoothLog.e(WtUtil.format("characteristic not exist!", new Object[0]));
            return false;
        }
        if (this.mBluetoothGatt == null) {
            BluetoothLog.e(WtUtil.format("ble gatt null", new Object[0]));
            return false;
        }
        if (byArray == null) {
            byArray = ByteUtils.EMPTY_BYTES;
        }
        UUID uUID3 = uUID;
        uUID3.setValue(byArray);
        uUID3.setWriteType(1);
        if (!this.mBluetoothGatt.writeCharacteristic((BluetoothGattCharacteristic)uUID)) {
            BluetoothLog.e(WtUtil.format("writeCharacteristic failed", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public boolean setCharacteristicNotification(UUID object, UUID uUID, boolean bl) {
        Object[] objectArray;
        this.checkRuntime();
        Object[] objectArray2 = new Object[4];
        Object[] objectArray3 = objectArray = objectArray2;
        objectArray3[0] = this.getAddress();
        objectArray3[1] = object;
        objectArray[2] = uUID;
        objectArray2[3] = bl;
        BluetoothLog.v(WtUtil.format("setCharacteristicNotification for %s, service = %s, character = %s, enable = %b", objectArray));
        object = this.getCharacter((UUID)object, uUID);
        if (object == null) {
            BluetoothLog.e(WtUtil.format("characteristic not exist!", new Object[0]));
            return false;
        }
        uUID = this.mBluetoothGatt;
        if (uUID == null) {
            BluetoothLog.e(WtUtil.format("ble gatt null", new Object[0]));
            return false;
        }
        if (!uUID.setCharacteristicNotification((BluetoothGattCharacteristic)object, bl)) {
            BluetoothLog.e(WtUtil.format("setCharacteristicNotification failed", new Object[0]));
            return false;
        }
        uUID = object.getDescriptor(Constants.CLIENT_CHARACTERISTIC_CONFIG);
        if (uUID == null) {
            if (object.getDescriptor(Constants.CLIENT_2_CHARACTERISTIC_CONFIG) != null) {
                return true;
            }
            BluetoothLog.e(WtUtil.format("getDescriptor for notify null!", new Object[0]));
            return false;
        }
        object = bl ? (Object)BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE : (Object)BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE;
        if (!uUID.setValue((byte[])object)) {
            BluetoothLog.e(WtUtil.format("setValue for notify descriptor failed!", new Object[0]));
            return false;
        }
        if (!this.mBluetoothGatt.writeDescriptor((BluetoothGattDescriptor)uUID)) {
            BluetoothLog.e(WtUtil.format("writeDescriptor for notify failed", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public boolean setCharacteristicIndication(UUID uUID, UUID object, boolean bl) {
        Object[] objectArray;
        this.checkRuntime();
        Object[] objectArray2 = new Object[4];
        Object[] objectArray3 = objectArray = objectArray2;
        objectArray3[0] = this.getAddress();
        objectArray3[1] = uUID;
        objectArray[2] = object;
        objectArray2[3] = bl;
        BluetoothLog.v(WtUtil.format("setCharacteristicIndication for %s, service = %s, character = %s, enable = %b", objectArray));
        uUID = this.getCharacter(uUID, (UUID)object);
        if (uUID == null) {
            BluetoothLog.e(WtUtil.format("characteristic not exist!", new Object[0]));
            return false;
        }
        object = this.mBluetoothGatt;
        if (object == null) {
            BluetoothLog.e(WtUtil.format("ble gatt null", new Object[0]));
            return false;
        }
        if (!object.setCharacteristicNotification((BluetoothGattCharacteristic)uUID, bl)) {
            BluetoothLog.e(WtUtil.format("setCharacteristicIndication failed", new Object[0]));
            return false;
        }
        if ((uUID = uUID.getDescriptor(Constants.CLIENT_CHARACTERISTIC_CONFIG)) == null) {
            BluetoothLog.e(WtUtil.format("getDescriptor for indicate null!", new Object[0]));
            return false;
        }
        object = bl ? (Object)BluetoothGattDescriptor.ENABLE_INDICATION_VALUE : (Object)BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE;
        if (!uUID.setValue((byte[])object)) {
            BluetoothLog.e(WtUtil.format("setValue for indicate descriptor failed!", new Object[0]));
            return false;
        }
        if (!this.mBluetoothGatt.writeDescriptor((BluetoothGattDescriptor)uUID)) {
            BluetoothLog.e(WtUtil.format("writeDescriptor for indicate failed", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public boolean readRemoteRssi() {
        BleConnectWorker bleConnectWorker = bleConnectWorker2;
        bleConnectWorker.checkRuntime();
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = bleConnectWorker2.getAddress();
        BluetoothLog.v(WtUtil.format("readRemoteRssi for %s", objectArray2));
        BleConnectWorker bleConnectWorker2 = bleConnectWorker.mBluetoothGatt;
        if (bleConnectWorker2 == null) {
            BluetoothLog.e(WtUtil.format("ble gatt null", new Object[0]));
            return false;
        }
        if (!bleConnectWorker2.readRemoteRssi()) {
            BluetoothLog.e(WtUtil.format("readRemoteRssi failed", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public BleGattProfile getGattProfile() {
        return this.mBleGattProfile;
    }

    public boolean handleMessage(Message message) {
        if (message.what == 288) {
            ProxyBulk.safeInvoke(message.obj);
        }
        return true;
    }

    @Override
    public boolean onIntercept(Object object, Method method, Object[] objectArray) {
        ProxyBulk proxyBulk;
        ProxyBulk proxyBulk2 = proxyBulk;
        proxyBulk = new ProxyBulk(object, method, objectArray);
        ((BleConnectWorker)((Object)proxyBulk2)).mWorkerHandler.obtainMessage(288, (Object)proxyBulk2).sendToTarget();
        return true;
    }

    @Override
    public void checkRuntime() {
        this.mRuntimeChecker.checkRuntime();
    }
}

