/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.connect;

import android.os.HandlerThread;
import android.os.Looper;
import com.tuya.sdk.blelib.connect.BleConnectMaster;
import com.tuya.sdk.blelib.connect.IBleConnectMaster;
import com.tuya.sdk.blelib.connect.options.BleConnectOptions;
import com.tuya.sdk.blelib.connect.response.BleGeneralResponse;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;

public class BleConnectManager {
    public static final String TAG = "BleConnectManager";
    public static HashMap<String, IBleConnectMaster> mBleConnectMasters = new HashMap();
    public static HandlerThread mWorkerThread;

    public static Looper getWorkerLooper() {
        if (mWorkerThread == null) {
            mWorkerThread = new HandlerThread(TAG);
            mWorkerThread.start();
        }
        return mWorkerThread.getLooper();
    }

    public static IBleConnectMaster getBleConnectMaster(String string) {
        IBleConnectMaster iBleConnectMaster = mBleConnectMasters.get(string);
        if (iBleConnectMaster == null) {
            iBleConnectMaster = BleConnectMaster.newInstance(string, BleConnectManager.getWorkerLooper());
            mBleConnectMasters.put(string, iBleConnectMaster);
        }
        return iBleConnectMaster;
    }

    public static void connect(String string, BleConnectOptions bleConnectOptions, BleGeneralResponse bleGeneralResponse) {
        BleConnectManager.getBleConnectMaster(string).connect(bleConnectOptions, bleGeneralResponse);
    }

    public static void disconnect(String string) {
        BleConnectManager.getBleConnectMaster(string).disconnect();
    }

    public static void onlyDisconnect(String string) {
        BleConnectManager.getBleConnectMaster(string).onlyDisconnect();
    }

    public static void discoveryService(String string, BleGeneralResponse bleGeneralResponse) {
        BleConnectManager.getBleConnectMaster(string).discoveryService(bleGeneralResponse);
    }

    public static void requestPriority(String string, int n) {
        BleConnectManager.getBleConnectMaster(string).requestPriority(n);
    }

    public static void read(String string, UUID uUID, UUID uUID2, BleGeneralResponse bleGeneralResponse) {
        BleConnectManager.getBleConnectMaster(string).read(uUID, uUID2, bleGeneralResponse);
    }

    public static void write(String string, UUID uUID, UUID uUID2, byte[] byArray, BleGeneralResponse bleGeneralResponse) {
        BleConnectManager.getBleConnectMaster(string).write(uUID, uUID2, byArray, bleGeneralResponse);
    }

    public static void writeNoRsp(String string, UUID uUID, UUID uUID2, byte[] byArray, BleGeneralResponse bleGeneralResponse) {
        BleConnectManager.getBleConnectMaster(string).writeNoRsp(uUID, uUID2, byArray, bleGeneralResponse);
    }

    public static void readDescriptor(String string, UUID uUID, UUID uUID2, UUID uUID3, BleGeneralResponse bleGeneralResponse) {
        BleConnectManager.getBleConnectMaster(string).readDescriptor(uUID, uUID2, uUID3, bleGeneralResponse);
    }

    public static void writeDescriptor(String string, UUID uUID, UUID uUID2, UUID uUID3, byte[] byArray, BleGeneralResponse bleGeneralResponse) {
        BleConnectManager.getBleConnectMaster(string).writeDescriptor(uUID, uUID2, uUID3, byArray, bleGeneralResponse);
    }

    public static void notify(String string, UUID uUID, UUID uUID2, BleGeneralResponse bleGeneralResponse) {
        BleConnectManager.getBleConnectMaster(string).notify(uUID, uUID2, bleGeneralResponse);
    }

    public static void unnotify(String string, UUID uUID, UUID uUID2, BleGeneralResponse bleGeneralResponse) {
        BleConnectManager.getBleConnectMaster(string).unnotify(uUID, uUID2, bleGeneralResponse);
    }

    public static void readRssi(String string, BleGeneralResponse bleGeneralResponse) {
        BleConnectManager.getBleConnectMaster(string).readRssi(bleGeneralResponse);
    }

    public static void configMtu(String string, int n, BleGeneralResponse bleGeneralResponse) {
        BleConnectManager.getBleConnectMaster(string).configMtu(n, bleGeneralResponse);
    }

    public static void indicate(String string, UUID uUID, UUID uUID2, BleGeneralResponse bleGeneralResponse) {
        BleConnectManager.getBleConnectMaster(string).indicate(uUID, uUID2, bleGeneralResponse);
    }

    public static void clearRequest(String string, int n) {
        BleConnectManager.getBleConnectMaster(string).clearRequest(n);
    }

    public static void refreshCache(String string) {
        BleConnectManager.getBleConnectMaster(string).refreshCache();
    }

    public static void onBluetoothStateChanged(int n, int n2) {
        Iterator<IBleConnectMaster> iterator = mBleConnectMasters.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onBluetoothStateChanged(n, n2);
        }
    }

    public static void notifyMesh(String string, UUID uUID, UUID uUID2, BleGeneralResponse bleGeneralResponse) {
        BleConnectManager.getBleConnectMaster(string).notifyMesh(uUID, uUID2, bleGeneralResponse);
    }
}

