/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.connect;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.tuya.sdk.blelib.RuntimeChecker;
import com.tuya.sdk.blelib.connect.BleConnectWorker;
import com.tuya.sdk.blelib.connect.IBleConnectDispatcher;
import com.tuya.sdk.blelib.connect.IBleConnectWorker;
import com.tuya.sdk.blelib.connect.options.BleConnectOptions;
import com.tuya.sdk.blelib.connect.request.BleConfigMtuRequest;
import com.tuya.sdk.blelib.connect.request.BleConnectRequest;
import com.tuya.sdk.blelib.connect.request.BleDiscoveryServiceRequest;
import com.tuya.sdk.blelib.connect.request.BleIndicateRequest;
import com.tuya.sdk.blelib.connect.request.BleMeshNotifyRequest;
import com.tuya.sdk.blelib.connect.request.BleNotifyRequest;
import com.tuya.sdk.blelib.connect.request.BleReadDescriptorRequest;
import com.tuya.sdk.blelib.connect.request.BleReadRequest;
import com.tuya.sdk.blelib.connect.request.BleReadRssiRequest;
import com.tuya.sdk.blelib.connect.request.BleRefreshCacheRequest;
import com.tuya.sdk.blelib.connect.request.BleRequest;
import com.tuya.sdk.blelib.connect.request.BleStateChangeRequest;
import com.tuya.sdk.blelib.connect.request.BleUnnotifyRequest;
import com.tuya.sdk.blelib.connect.request.BleWriteDescriptorRequest;
import com.tuya.sdk.blelib.connect.request.BleWriteNoRspRequest;
import com.tuya.sdk.blelib.connect.request.BleWriteRequest;
import com.tuya.sdk.blelib.connect.response.BleGeneralResponse;
import com.tuya.sdk.blelib.utils.BluetoothLog;
import com.tuya.sdk.blelib.utils.ListUtils;
import com.tuya.sdk.blelib.utils.WtUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public class BleConnectDispatcher
implements IBleConnectDispatcher,
RuntimeChecker,
Handler.Callback {
    public static final int MAX_REQUEST_COUNT = 100;
    public static final int MSG_SCHEDULE_NEXT = 18;
    public List<BleRequest> mBleWorkList;
    public BleRequest mCurrentRequest;
    public IBleConnectWorker mWorker;
    public String mAddress;
    public Handler mHandler;

    public BleConnectDispatcher(String string) {
        BleConnectDispatcher bleConnectDispatcher = this;
        bleConnectDispatcher.mAddress = string;
        bleConnectDispatcher.mBleWorkList = new LinkedList<BleRequest>();
        bleConnectDispatcher.mWorker = new BleConnectWorker(string, this);
        bleConnectDispatcher.mHandler = new Handler(Looper.myLooper(), (Handler.Callback)this);
    }

    public static BleConnectDispatcher newInstance(String string) {
        return new BleConnectDispatcher(string);
    }

    private boolean isRequestMatch(BleRequest bleRequest, int n) {
        if ((n & 1) != 0) {
            return bleRequest instanceof BleReadRequest;
        }
        if ((n & 2) != 0) {
            return bleRequest instanceof BleWriteRequest || bleRequest instanceof BleWriteNoRspRequest;
        }
        if ((n & 4) != 0) {
            return bleRequest instanceof BleNotifyRequest || bleRequest instanceof BleUnnotifyRequest || bleRequest instanceof BleIndicateRequest;
        }
        if ((n & 8) != 0) {
            return bleRequest instanceof BleReadRssiRequest;
        }
        return false;
    }

    private void addNewRequest(BleRequest bleRequest) {
        BleConnectDispatcher bleConnectDispatcher = this;
        bleConnectDispatcher.checkRuntime();
        if (bleConnectDispatcher.mBleWorkList.size() < 100) {
            bleRequest.setRuntimeChecker(this);
            bleRequest.setAddress(this.mAddress);
            bleRequest.setWorker(this.mWorker);
            this.mBleWorkList.add(bleRequest);
        } else {
            bleRequest.onResponse(-8);
        }
        this.scheduleNextRequest(10L);
    }

    private void scheduleNextRequest(long l) {
        this.mHandler.sendEmptyMessageDelayed(18, l);
    }

    private void scheduleNextRequest() {
        if (this.mCurrentRequest != null) {
            return;
        }
        if (!ListUtils.isEmpty(this.mBleWorkList)) {
            BleRequest bleRequest;
            this.mCurrentRequest = bleRequest = this.mBleWorkList.remove(0);
            bleRequest.process(this);
        }
    }

    public void connect(BleConnectOptions bleConnectOptions, BleGeneralResponse bleGeneralResponse) {
        BleConnectRequest bleConnectRequest;
        BleConnectDispatcher bleConnectDispatcher = callback;
        Handler.Callback callback = bleConnectRequest;
        bleConnectRequest = new BleConnectRequest(bleConnectOptions, bleGeneralResponse);
        bleConnectDispatcher.addNewRequest((BleRequest)callback);
    }

    public void disconnect() {
        BleConnectDispatcher bleConnectDispatcher = this;
        bleConnectDispatcher.checkRuntime();
        BluetoothLog.w(WtUtil.format("Process disconnect", new Object[0]));
        Object object = bleConnectDispatcher.mCurrentRequest;
        if (object != null) {
            ((BleRequest)object).cancel();
            this.mCurrentRequest = null;
        }
        object = this.mBleWorkList.iterator();
        while (object.hasNext()) {
            ((BleRequest)object.next()).cancel();
        }
        BleConnectDispatcher bleConnectDispatcher2 = this;
        bleConnectDispatcher2.mBleWorkList.clear();
        bleConnectDispatcher2.mWorker.closeGatt();
    }

    public void onlyDisconnect() {
        BleConnectDispatcher bleConnectDispatcher = this;
        bleConnectDispatcher.checkRuntime();
        BluetoothLog.w(WtUtil.format("Process close", new Object[0]));
        Object object = bleConnectDispatcher.mCurrentRequest;
        if (object != null) {
            ((BleRequest)object).cancel();
            this.mCurrentRequest = null;
        }
        object = this.mBleWorkList.iterator();
        while (object.hasNext()) {
            ((BleRequest)object.next()).cancel();
        }
        BleConnectDispatcher bleConnectDispatcher2 = this;
        bleConnectDispatcher2.mBleWorkList.clear();
        bleConnectDispatcher2.mWorker.disconnect();
    }

    public void requestConnectionPriority(int n) {
        this.mWorker.requestConnectionPriority(n);
    }

    public void onBluetoothStateChanged(int n, int n2) {
        if (n2 == 10) {
            BleStateChangeRequest bleStateChangeRequest;
            BleConnectDispatcher bleConnectDispatcher = callback;
            Handler.Callback callback = bleStateChangeRequest;
            bleStateChangeRequest = new BleStateChangeRequest(true);
            bleConnectDispatcher.addNewRequest((BleRequest)callback);
        }
    }

    public void discoveryServices(BleGeneralResponse bleGeneralResponse) {
        BleDiscoveryServiceRequest bleDiscoveryServiceRequest;
        BleConnectDispatcher bleConnectDispatcher = callback;
        Handler.Callback callback = bleDiscoveryServiceRequest;
        bleDiscoveryServiceRequest = new BleDiscoveryServiceRequest(bleGeneralResponse);
        bleConnectDispatcher.addNewRequest((BleRequest)callback);
    }

    public void refreshCache() {
        BleRefreshCacheRequest bleRefreshCacheRequest;
        BleConnectDispatcher bleConnectDispatcher = callback;
        Handler.Callback callback = bleRefreshCacheRequest;
        bleRefreshCacheRequest = new BleRefreshCacheRequest(null);
        bleConnectDispatcher.addNewRequest((BleRequest)callback);
    }

    public void clearRequest(int n) {
        LinkedList linkedList;
        this.checkRuntime();
        Object[] objectArray = new Object[1];
        Object object = objectArray;
        objectArray[0] = n;
        BluetoothLog.w(WtUtil.format("clearRequest %d", (Object[])object));
        object = linkedList;
        linkedList = new LinkedList();
        if (n == 0) {
            object.addAll(this.mBleWorkList);
        } else {
            for (BleRequest bleRequest : this.mBleWorkList) {
                if (!this.isRequestMatch(bleRequest, n)) continue;
                object.add(bleRequest);
            }
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            ((BleRequest)iterator.next()).cancel();
        }
        this.mBleWorkList.removeAll((Collection<?>)object);
    }

    public void read(UUID uUID, UUID uUID2, BleGeneralResponse bleGeneralResponse) {
        BleReadRequest bleReadRequest;
        BleConnectDispatcher bleConnectDispatcher = callback;
        Handler.Callback callback = bleReadRequest;
        bleReadRequest = new BleReadRequest(uUID, uUID2, bleGeneralResponse);
        bleConnectDispatcher.addNewRequest((BleRequest)callback);
    }

    public void write(UUID uUID, UUID uUID2, byte[] byArray, BleGeneralResponse bleGeneralResponse) {
        BleWriteRequest bleWriteRequest;
        BleConnectDispatcher bleConnectDispatcher = callback;
        Handler.Callback callback = bleWriteRequest;
        bleWriteRequest = new BleWriteRequest(uUID, uUID2, byArray, bleGeneralResponse);
        bleConnectDispatcher.addNewRequest((BleRequest)callback);
    }

    public void writeNoRsp(UUID uUID, UUID uUID2, byte[] byArray, BleGeneralResponse bleGeneralResponse) {
        BleWriteNoRspRequest bleWriteNoRspRequest;
        BleConnectDispatcher bleConnectDispatcher = callback;
        Handler.Callback callback = bleWriteNoRspRequest;
        bleWriteNoRspRequest = new BleWriteNoRspRequest(uUID, uUID2, byArray, bleGeneralResponse);
        bleConnectDispatcher.addNewRequest((BleRequest)callback);
    }

    public void readDescriptor(UUID uUID, UUID uUID2, UUID uUID3, BleGeneralResponse bleGeneralResponse) {
        BleReadDescriptorRequest bleReadDescriptorRequest;
        BleConnectDispatcher bleConnectDispatcher = callback;
        Handler.Callback callback = bleReadDescriptorRequest;
        bleReadDescriptorRequest = new BleReadDescriptorRequest(uUID, uUID2, uUID3, bleGeneralResponse);
        bleConnectDispatcher.addNewRequest((BleRequest)callback);
    }

    public void writeDescriptor(UUID uUID, UUID uUID2, UUID uUID3, byte[] byArray, BleGeneralResponse bleGeneralResponse) {
        BleWriteDescriptorRequest bleWriteDescriptorRequest;
        BleConnectDispatcher bleConnectDispatcher = callback;
        Handler.Callback callback = bleWriteDescriptorRequest;
        bleWriteDescriptorRequest = new BleWriteDescriptorRequest(uUID, uUID2, uUID3, byArray, bleGeneralResponse);
        bleConnectDispatcher.addNewRequest((BleRequest)callback);
    }

    public void notifyMesh(UUID uUID, UUID uUID2, BleGeneralResponse bleGeneralResponse) {
        BleMeshNotifyRequest bleMeshNotifyRequest;
        BleConnectDispatcher bleConnectDispatcher = callback;
        Handler.Callback callback = bleMeshNotifyRequest;
        bleMeshNotifyRequest = new BleMeshNotifyRequest(uUID, uUID2, bleGeneralResponse);
        bleConnectDispatcher.addNewRequest((BleRequest)callback);
    }

    public void notify(UUID uUID, UUID uUID2, BleGeneralResponse bleGeneralResponse) {
        BleNotifyRequest bleNotifyRequest;
        BleConnectDispatcher bleConnectDispatcher = callback;
        Handler.Callback callback = bleNotifyRequest;
        bleNotifyRequest = new BleNotifyRequest(uUID, uUID2, bleGeneralResponse);
        bleConnectDispatcher.addNewRequest((BleRequest)callback);
    }

    public void unnotify(UUID uUID, UUID uUID2, BleGeneralResponse bleGeneralResponse) {
        BleUnnotifyRequest bleUnnotifyRequest;
        BleConnectDispatcher bleConnectDispatcher = callback;
        Handler.Callback callback = bleUnnotifyRequest;
        bleUnnotifyRequest = new BleUnnotifyRequest(uUID, uUID2, bleGeneralResponse);
        bleConnectDispatcher.addNewRequest((BleRequest)callback);
    }

    public void indicate(UUID uUID, UUID uUID2, BleGeneralResponse bleGeneralResponse) {
        BleIndicateRequest bleIndicateRequest;
        BleConnectDispatcher bleConnectDispatcher = callback;
        Handler.Callback callback = bleIndicateRequest;
        bleIndicateRequest = new BleIndicateRequest(uUID, uUID2, bleGeneralResponse);
        bleConnectDispatcher.addNewRequest((BleRequest)callback);
    }

    public void unindicate(UUID uUID, UUID uUID2, BleGeneralResponse bleGeneralResponse) {
        BleUnnotifyRequest bleUnnotifyRequest;
        BleConnectDispatcher bleConnectDispatcher = callback;
        Handler.Callback callback = bleUnnotifyRequest;
        bleUnnotifyRequest = new BleUnnotifyRequest(uUID, uUID2, bleGeneralResponse);
        bleConnectDispatcher.addNewRequest((BleRequest)callback);
    }

    public void readRemoteRssi(BleGeneralResponse bleGeneralResponse) {
        BleReadRssiRequest bleReadRssiRequest;
        BleConnectDispatcher bleConnectDispatcher = callback;
        Handler.Callback callback = bleReadRssiRequest;
        bleReadRssiRequest = new BleReadRssiRequest(bleGeneralResponse);
        bleConnectDispatcher.addNewRequest((BleRequest)callback);
    }

    public void requestMtu(int n, BleGeneralResponse bleGeneralResponse) {
        BleConfigMtuRequest bleConfigMtuRequest;
        BleConnectDispatcher bleConnectDispatcher = callback;
        Handler.Callback callback = bleConfigMtuRequest;
        bleConfigMtuRequest = new BleConfigMtuRequest(n, bleGeneralResponse);
        bleConnectDispatcher.addNewRequest((BleRequest)callback);
    }

    @Override
    public void onRequestCompleted(BleRequest bleRequest) {
        BleConnectDispatcher bleConnectDispatcher = this;
        bleConnectDispatcher.checkRuntime();
        if (bleRequest == bleConnectDispatcher.mCurrentRequest) {
            this.mCurrentRequest = null;
            this.scheduleNextRequest(10L);
            return;
        }
        throw new IllegalStateException("request not match");
    }

    @Override
    public void checkRuntime() {
        if (Thread.currentThread() == this.mHandler.getLooper().getThread()) {
            return;
        }
        throw new IllegalStateException("Thread Context Illegal");
    }

    public boolean handleMessage(Message message) {
        if (message.what == 18) {
            this.scheduleNextRequest();
        }
        return true;
    }
}

