/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.blelib.channel.packet;

import com.tuya.sdk.blelib.channel.packet.ACKPacket;
import com.tuya.sdk.blelib.channel.packet.CTRPacket;
import com.tuya.sdk.blelib.channel.packet.DataPacket;
import com.tuya.sdk.blelib.channel.packet.InvalidPacket;
import java.nio.ByteBuffer;

public abstract class Packet {
    public static final int BUFFER_SIZE = 20;
    public static final byte[] BUFFER = new byte[20];
    public static final int SN_CTR = 0;
    public static final int TYPE_CMD = 0;
    public static final int TYPE_ACK = 1;
    public static final String ACK = "ack";
    public static final String DATA = "data";
    public static final String CTR = "ctr";

    public static Header parse(byte[] byArray) {
        Header header;
        Header header2 = header;
        header = new Header(null);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        short s = byteBuffer.getShort();
        Header header3 = header2;
        header3.sn = s;
        header3.value = byArray;
        if (s == 0) {
            header2.type = byteBuffer.get();
            header2.command = byteBuffer.get();
            header2.parameter = byteBuffer.getInt();
        }
        return header2;
    }

    public static Packet getPacket(byte[] object) {
        Header header = Packet.parse(object);
        object = header;
        if (header.sn != 0) {
            return Packet.getDataPacket((Header)object);
        }
        return Packet.getFlowPacket((Header)object);
    }

    public static Packet getFlowPacket(Header header) {
        Header header2 = header;
        int n = header2.parameter;
        int n2 = header2.type;
        if (n2 != 0) {
            if (n2 != 1) {
                return new InvalidPacket();
            }
            int n3 = n;
            n = n3 >> 16;
            n2 = n3 & 0xFFFF;
            return new ACKPacket(n, n2);
        }
        return new CTRPacket(n >>= 16);
    }

    public static Packet getDataPacket(Header header) {
        return new DataPacket(header.sn, new Bytes(header.value, 2));
    }

    public abstract String getName();

    public abstract byte[] toBytes();

    public static class Bytes {
        public byte[] value;
        public int start;
        public int end;

        public Bytes(byte[] byArray, int n) {
            int n2 = byArray.length;
            this(byArray, n, n2);
        }

        public Bytes(byte[] byArray, int n, int n2) {
            this.value = byArray;
            this.start = n;
            this.end = n2;
        }

        public int getSize() {
            return this.end - this.start;
        }
    }

    public static class Header {
        public int sn;
        public int type;
        public int command;
        public int parameter;
        public byte[] value;

        public Header() {
        }

        public /* synthetic */ Header(1 var1_1) {
            this();
        }
    }
}

